/*
 * Decompiled with CFR 0.152.
 */
package mars.expcounter.com;

import net.minecraftforge.common.ForgeConfigSpec;

public class ExpClientConfigs {
    public static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.BooleanValue SHOW_NEXT_LVL;
    public static ForgeConfigSpec.BooleanValue SHOW_TOTAL;
    public static ForgeConfigSpec.IntValue COL_NEXT_LVL;
    public static ForgeConfigSpec.IntValue COL_TOTAL;
    public static ForgeConfigSpec.IntValue POS_OFF_CENTRE_NEXT_LVL;
    public static ForgeConfigSpec.IntValue POS_Y_NEXT_LVL;
    public static ForgeConfigSpec.IntValue POS_OFF_CENTRE_TOTAL;
    public static ForgeConfigSpec.IntValue POS_Y_TOTAL;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("EXP Counter Config");
        SHOW_NEXT_LVL = builder.comment("Show how much more exp until next level").define("showNextLevel", true);
        SHOW_TOTAL = builder.comment("Show total amount of exp").define("showTotal", true);
        COL_NEXT_LVL = builder.comment("Color of the counter of exp until next level in decimal").defineInRange("colNextLevel", 0xFFFF00, Integer.MIN_VALUE, Integer.MAX_VALUE);
        COL_TOTAL = builder.comment("Color of total exp counter in decimal").defineInRange("colTotal", 0xFFFF00, Integer.MIN_VALUE, Integer.MAX_VALUE);
        POS_OFF_CENTRE_NEXT_LVL = builder.comment("X axis position off centre of the counter of exp until next level").defineInRange("posOffCentreNextLevel", -50, Integer.MIN_VALUE, Integer.MAX_VALUE);
        POS_Y_NEXT_LVL = builder.comment("Y axis position of the counter of exp until next level").defineInRange("posYNextLevel", 30, Integer.MIN_VALUE, Integer.MAX_VALUE);
        POS_OFF_CENTRE_TOTAL = builder.comment("X axis position off centre of total exp counter").defineInRange("posOffCentreTotal", 50, Integer.MIN_VALUE, Integer.MAX_VALUE);
        POS_Y_TOTAL = builder.comment("Y axis position of total exp counter").defineInRange("posYTotal", 30, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        ExpClientConfigs.setupConfig(BUILDER);
        SPEC = BUILDER.build();
    }
}

