/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.mixin;

import com.aizistral.enigmaticlegacy.api.quack.IAbyssalHeartBearer;
import com.aizistral.enigmaticlegacy.client.Quote;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnderDragon.class})
public abstract class MixinEnderDragon
extends Mob
implements Enemy,
IAbyssalHeartBearer {
    @Shadow
    public int f_31084_;
    private Player abyssalHeartOwner;

    protected MixinEnderDragon() {
        super(null, null);
        throw new IllegalStateException("Can't touch this");
    }

    @Inject(method={"tickDeath"}, at={@At(value="RETURN")}, require=1)
    private void onTickDeath(CallbackInfo info) {
        if (this.f_31084_ == 200 && this.m_9236_() instanceof ServerLevel) {
            if (this.abyssalHeartOwner != null) {
                int heartsGained = SuperpositionHandler.getPersistentInteger(this.abyssalHeartOwner, "AbyssalHeartsGained", 0);
                Vector3 center = Vector3.fromEntityCenter((Entity)this);
                PermanentItemEntity heart = new PermanentItemEntity(this.m_9236_(), center.x, center.y, center.z, new ItemStack((ItemLike)EnigmaticItems.ABYSSAL_HEART, 1));
                heart.setOwnerId(this.abyssalHeartOwner.m_20148_());
                this.m_9236_().m_7967_((Entity)heart);
                SuperpositionHandler.setPersistentInteger(this.abyssalHeartOwner, "AbyssalHeartsGained", heartsGained + 1);
            }
            List players = this.m_9236_().m_45976_(ServerPlayer.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)this, 256.0));
            players.forEach(player -> Quote.WITH_DRAGONS.playOnceIfUnlocked((ServerPlayer)player, 140));
        }
    }

    @Override
    public void dropAbyssalHeart(Player player) {
        this.abyssalHeartOwner = player;
    }
}

