/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.helpers;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.items.CursedRing;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemLoreHelper {
    @OnlyIn(value=Dist.CLIENT)
    public static void indicateCursedOnesOnly(List<Component> list) {
        ChatFormatting format = Minecraft.m_91087_().f_91074_ != null ? (SuperpositionHandler.isTheCursedOne((Player)Minecraft.m_91087_().f_91074_) ? ChatFormatting.GOLD : ChatFormatting.DARK_RED) : ChatFormatting.DARK_RED;
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.cursedOnesOnly1").m_130940_(format));
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.cursedOnesOnly2").m_130940_(format));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void indicateWorthyOnesOnly(List<Component> list) {
        ChatFormatting format = ChatFormatting.DARK_RED;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            format = SuperpositionHandler.isTheWorthyOne((Player)Minecraft.m_91087_().f_91074_) ? ChatFormatting.GOLD : ChatFormatting.DARK_RED;
        }
        double requiredCurse = SuperpositionHandler.roundToPlaces(100.0 * CursedRing.superCursedTime.getValue(), 1);
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.worthyOnesOnly1"));
        list.add((Component)Component.m_237110_((String)"tooltip.enigmaticlegacy.worthyOnesOnly2", (Object[])new Object[]{Component.m_237113_((String)(requiredCurse + "%")).m_130940_(ChatFormatting.GOLD)}).m_130940_(format));
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.worthyOnesOnly3"));
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.void"));
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.worthyOnesOnly4").m_130940_(format).m_7220_((Component)Component.m_237113_((String)(" " + SuperpositionHandler.getSufferingTime((Player)player))).m_130940_(ChatFormatting.LIGHT_PURPLE)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void indicateBlessedOnesOnly(List<Component> list) {
        ChatFormatting format = EnigmaticLegacy.PROXY.getClientPlayer() != null ? (SuperpositionHandler.isTheBlessedOne(EnigmaticLegacy.PROXY.getClientPlayer()) ? ChatFormatting.GOLD : ChatFormatting.DARK_RED) : ChatFormatting.DARK_RED;
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.blessedOnesOnly1").m_130940_(format));
        list.add((Component)Component.m_237115_((String)"tooltip.enigmaticlegacy.blessedOnesOnly2").m_130940_(format));
    }

    public static void addLocalizedFormattedString(List<Component> list, String str, ChatFormatting format) {
        list.add((Component)Component.m_237115_((String)str).m_130940_(format));
    }

    public static void addLocalizedString(List<Component> list, String str) {
        list.add((Component)Component.m_237115_((String)str));
    }

    public static void addLocalizedString(List<Component> list, String str, @Nullable ChatFormatting format, Object ... values) {
        Component[] stringValues = new Component[values.length];
        int counter = 0;
        for (Object value : values) {
            MutableComponent comp = value instanceof MutableComponent ? (MutableComponent)value : Component.m_237113_((String)value.toString());
            if (format != null) {
                comp.m_130940_(format);
            }
            stringValues[counter] = comp;
            ++counter;
        }
        list.add((Component)Component.m_237110_((String)str, (Object[])stringValues));
    }

    public static ItemStack mergeDisplayData(ItemStack from, ItemStack to) {
        CompoundTag nbt = from.m_41698_("display");
        ListTag loreList = nbt.m_128437_("Lore", 8).size() > 0 ? nbt.m_128437_("Lore", 8) : to.m_41698_("display").m_128437_("Lore", 8);
        StringTag displayName = nbt.m_128461_("Name").length() > 0 ? StringTag.m_129297_((String)nbt.m_128461_("Name")) : StringTag.m_129297_((String)to.m_41698_("display").m_128461_("Name"));
        CompoundTag mergedData = new CompoundTag();
        mergedData.m_128365_("Lore", (Tag)loreList.m_6426_());
        mergedData.m_128365_("Name", (Tag)displayName.m_6426_());
        to.m_41784_().m_128365_("display", (Tag)mergedData);
        return to;
    }

    public static ItemStack addLoreString(ItemStack stack, String string) {
        CompoundTag nbt = stack.m_41698_("display");
        ListTag loreList = nbt.m_128437_("Lore", 8);
        loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)string))));
        nbt.m_128365_("Lore", (Tag)loreList);
        return stack;
    }

    public static ItemStack setLoreString(ItemStack stack, String string, int index) {
        CompoundTag nbt = stack.m_41698_("display");
        ListTag loreList = nbt.m_128437_("Lore", 8);
        if (loreList.size() - 1 >= index) {
            loreList.set(index, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)string))));
        } else {
            loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)string))));
        }
        nbt.m_128365_("Lore", (Tag)loreList);
        return stack;
    }

    public static ItemStack removeLoreString(ItemStack stack, int index) {
        CompoundTag nbt = stack.m_41698_("display");
        ListTag loreList = nbt.m_128437_("Lore", 8);
        if (loreList.size() > 0) {
            if (index == -1) {
                loreList.remove(loreList.size() - 1);
            } else if (loreList.size() - 1 >= index) {
                loreList.remove(index);
            }
        }
        nbt.m_128365_("Lore", (Tag)loreList);
        return stack;
    }

    public static ItemStack setLastLoreString(ItemStack stack, String string) {
        CompoundTag nbt = stack.m_41698_("display");
        ListTag loreList = nbt.m_128437_("Lore", 8);
        if (loreList.size() > 0) {
            loreList.set(loreList.size() - 1, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)string))));
        } else {
            loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)string))));
        }
        nbt.m_128365_("Lore", (Tag)loreList);
        return stack;
    }

    public static ItemStack setDisplayName(ItemStack stack, String name) {
        CompoundTag nbt = stack.m_41698_("display");
        nbt.m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)name)));
        return stack;
    }

    public static class AnvilParser {
        private boolean isLore;
        private int loreIndex = -1;
        private boolean removeString;
        private String handledString;

        private AnvilParser(String string) {
            this.handledString = string.toString();
            this.isLore = this.handledString.startsWith("!");
            this.removeString = this.handledString.startsWith("-!");
            if (this.isLore) {
                this.handledString = this.handledString.replaceFirst("!", "");
                String index = AnvilParser.parseIndex(this.handledString);
                this.loreIndex = Integer.parseInt(index);
                if (this.loreIndex != -1) {
                    this.handledString = this.handledString.replaceFirst(index, "");
                }
            } else if (this.removeString) {
                this.handledString = this.handledString.replaceFirst("-!", "");
                String index = AnvilParser.parseIndex(this.handledString);
                this.loreIndex = Integer.parseInt(index);
                if (this.loreIndex != -1) {
                    this.handledString = this.handledString.replaceFirst(index, "");
                }
            }
            this.handledString = AnvilParser.parseFormatting(this.handledString);
        }

        public static AnvilParser parseField(String field) {
            return new AnvilParser(field);
        }

        private static String parseFormatting(String field) {
            String formatter = Component.m_237115_((String)"tooltip.enigmaticlegacy.paragraph").getString();
            String subformat = Component.m_237115_((String)"tooltip.enigmaticlegacy.subformat").getString();
            return field.replace(subformat, formatter);
        }

        private static String parseIndex(String field) {
            Object number = "";
            int index = -1;
            for (char symbol : field.toCharArray()) {
                if (!Character.isDigit(symbol) || ((String)(number = (String)number + symbol)).length() >= 2) break;
            }
            if (!((String)number).equals("")) {
                return number;
            }
            return "" + index;
        }

        public boolean isLoreString() {
            return this.isLore;
        }

        public boolean shouldRemoveString() {
            return this.removeString;
        }

        public int getLoreIndex() {
            return this.loreIndex;
        }

        public String getFormattedString() {
            return this.handledString;
        }
    }
}

