/*
 * Decompiled with CFR 0.152.
 */
package com.biomemusic.mixin;

import com.biomemusic.AdditionalMusic;
import com.biomemusic.BiomeMusic;
import com.biomemusic.config.CommonConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicManagerMixin {
    @Unique
    private Music playedMusic = null;
    @Unique
    private long startTime = 0L;
    private long lastBiomeTime = 0L;
    @Unique
    float fadeTowards = -1.0f;
    @Unique
    float modifiedVolume = 1.0f;

    @Shadow
    public abstract void m_120186_();

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/sounds/Music;replaceCurrentMusic()Z"))
    private boolean noReplace(Music instance) {
        return false;
    }

    @Inject(method={"startPlaying"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V")})
    private void onStartMusic(Music music, CallbackInfo ci) {
        this.playedMusic = music;
        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).smartMusic && this.playedMusic != null && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null) {
            this.startTime = Minecraft.m_91087_().f_91073_.m_46467_();
            Biome biome = (Biome)Minecraft.m_91087_().f_91073_.m_204166_(Minecraft.m_91087_().f_91074_.m_20183_()).m_203334_();
            this.lastBiomeTime = biome.m_47566_().isPresent() && ((Music)biome.m_47566_().get()).equals(this.playedMusic) ? this.startTime : 0L;
            this.fadeIn();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (((CommonConfiguration)BiomeMusic.config.getCommonConfig()).smartMusic && this.playedMusic != null && this.fadeTowards != -1.0f && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_.m_46467_() - this.startTime > 300L) {
            this.modifiedVolume += (float)(this.fadeTowards > 0.1f ? 1 : -1) * (Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC) / 200.0f);
            this.modifiedVolume = Math.min(Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC), this.modifiedVolume);
            Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MUSIC, this.modifiedVolume);
            if ((double)Math.abs(this.modifiedVolume - this.fadeTowards) < 0.01) {
                if (this.fadeTowards == 0.1f) {
                    this.playedMusic = null;
                    this.m_120186_();
                }
                this.fadeTowards = -1.0f;
                Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MUSIC, Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC));
            }
        }
        if (this.playedMusic != null && BiomeMusic.rand.nextInt(20) == 0 && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (this.playedMusic == AdditionalMusic.NIGHT_ADDITIONAL && Minecraft.m_91087_().f_91073_.m_46468_() < 12000L) {
                this.fadeOut();
                return;
            }
            if (this.playedMusic == AdditionalMusic.CAVE_ADDITIONAL && AdditionalMusic.CAVE_TICKS < 30) {
                this.fadeOut();
                return;
            }
            if (!(this.playedMusic != AdditionalMusic.WATER_ADDITIONAL && this.playedMusic != Musics.f_11650_ || Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.m_5842_())) {
                this.fadeOut();
                return;
            }
            if ((this.playedMusic == AdditionalMusic.END_ADDITIONAL || this.playedMusic == Musics.f_11649_ || this.playedMusic == Musics.f_11648_) && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_9236_().m_46472_() != Level.f_46430_) {
                this.fadeOut();
                return;
            }
            if (this.playedMusic == AdditionalMusic.NETHER_ALL && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_9236_().m_46472_() != Level.f_46429_) {
                this.fadeOut();
                return;
            }
            if (this.lastBiomeTime > 0L) {
                Biome biome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
                if (biome.m_47566_().isPresent()) {
                    if (((Music)biome.m_47566_().get()).equals(this.playedMusic)) {
                        this.lastBiomeTime = level.m_46467_();
                    } else if (level.m_46467_() - this.lastBiomeTime > 600L) {
                        this.fadeOut();
                    }
                }
                return;
            }
        }
    }

    @Unique
    private void fadeOut() {
        if (this.fadeTowards != 0.1f) {
            this.modifiedVolume = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC);
            this.fadeTowards = 0.1f;
        }
    }

    @Unique
    private void fadeIn() {
        if (this.fadeTowards != Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC)) {
            this.fadeTowards = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MUSIC);
            this.modifiedVolume = 0.1f;
            Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MUSIC, this.modifiedVolume);
        }
    }
}

