/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.PlayerState;

public record SimplePlayerState(@NotNull ResourceLocation id, @NotNull @NotNull @Unmodifiable Set<@NotNull ResourceLocation> flags, int staminaDelta, int recoveryDelay) implements PlayerState
{
    public SimplePlayerState(@NotNull PlayerState originalState, int staminaDelta, int recoveryDelay) {
        this(originalState.id(), originalState.flags(), staminaDelta, recoveryDelay);
    }

    @NotNull
    public static SimplePlayerState read(@NotNull FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        ObjectOpenHashSet flags = new ObjectOpenHashSet();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            flags.add(buffer.m_130281_());
        }
        int staminaDelta = buffer.readInt();
        int recoveryDelay = buffer.m_130242_();
        return new SimplePlayerState(id, (Set<ResourceLocation>)flags, staminaDelta, recoveryDelay);
    }

    public static void write(@NotNull FriendlyByteBuf buffer, @NotNull PlayerState state) {
        buffer.m_130085_(state.id());
        Set<ResourceLocation> flags = state.flags();
        buffer.m_130130_(flags.size());
        for (ResourceLocation flag : flags) {
            buffer.m_130085_(flag);
        }
        buffer.writeInt(state.staminaDelta());
        buffer.m_130130_(state.recoveryDelay());
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        SimplePlayerState.write(buffer, this);
    }

    @Override
    public boolean equals(Object obj) {
        PlayerState another;
        return this == obj || obj instanceof PlayerState && this.id.equals((Object)(another = (PlayerState)obj).id());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

