/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.Copy;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.impl.movement.PlayerStateMap;

public abstract class PlayerMovement
implements Movement,
Copy {
    private final Player player;
    @Nullable
    private Stamina stamina;
    @Nullable
    private VesselContainer vesselContainer;
    @Nullable
    private PlayerState state;
    private int recoveryDelay;

    public PlayerMovement(@NotNull Player player) {
        this.player = Objects.requireNonNull(player, "player == null");
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    @NotNull
    public final Stamina stamina() {
        if (this.stamina != null) {
            return this.stamina;
        }
        this.stamina = Objects.requireNonNull(this.createStamina(), "createStamina() == null");
        return this.stamina;
    }

    @NotNull
    public final VesselContainer vessels() {
        if (this.vesselContainer != null) {
            return this.vesselContainer;
        }
        this.vesselContainer = Objects.requireNonNull(this.createVesselContainer(), "createVesselContainer() == null");
        return this.vesselContainer;
    }

    @NotNull
    protected abstract Stamina createStamina();

    @NotNull
    protected abstract VesselContainer createVesselContainer();

    @Override
    @NotNull
    public final PlayerState state() {
        if (this.state != null) {
            return this.state;
        }
        PlayerStateMap stateMap = this.player().m_9236_().f_46443_ ? ParagliderMod.instance().getPlayerStateMap() : ParagliderMod.instance().getLocalPlayerStateMap();
        return stateMap.getIdleState();
    }

    protected final void setState(@NotNull PlayerState state) {
        this.state = state;
    }

    @Override
    public final @Range(from=0L, to=0x7FFFFFFFL) int recoveryDelay() {
        return this.recoveryDelay;
    }

    @Override
    public final void setRecoveryDelay(int recoveryDelay) {
        this.recoveryDelay = Math.max(0, recoveryDelay);
    }

    public abstract void update();

    @Override
    public void copyFrom(@NotNull Object from) {
        Copy copy;
        if (!(from instanceof Movement)) {
            return;
        }
        Movement movement = (Movement)from;
        this.setRecoveryDelay(movement.recoveryDelay());
        if (!(from instanceof PlayerMovement)) {
            return;
        }
        PlayerMovement playerMovement = (PlayerMovement)from;
        Object object = this.stamina();
        if (object instanceof Copy) {
            copy = (Copy)object;
            copy.copyFrom(playerMovement.stamina());
        }
        if ((object = this.vessels()) instanceof Copy) {
            copy = (Copy)object;
            copy.copyFrom(playerMovement.vessels());
        }
    }

    protected void applyMovement() {
        PlayerState state = this.state();
        if (state.has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            this.player().f_19789_ = 0.0f;
            Vec3 m = this.player().m_20184_();
            if (state.has(ParagliderPlayerStates.Flags.FLAG_ASCENDING)) {
                if (m.f_82480_ < 0.25) {
                    this.player.m_20256_(new Vec3(m.f_82479_, Math.max(m.f_82480_ + 0.05, 0.25), m.f_82481_));
                }
            } else if (m.f_82480_ < -0.05) {
                this.player.m_20256_(new Vec3(m.f_82479_, -0.05, m.f_82481_));
            }
        }
    }
}

