/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import fuzs.forgeconfigscreens.client.gui.screens.SelectConfigScreen;
import fuzs.forgeconfigscreens.client.gui.screens.SelectConfigWorldScreen;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigSelectionList
extends ObjectSelectionList<Entry> {
    private static final ResourceLocation ICON_LOCATION = ForgeConfigScreens.id("textures/misc/config.png");
    private static final ResourceLocation ICON_DISABLED_LOCATION = ForgeConfigScreens.id("textures/misc/disabled_config.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");
    private static final Component SELECT_WORLD_TOOLTIP = Component.m_237115_((String)"configmenusforge.gui.select.select_world").m_130940_(ChatFormatting.GOLD);
    private static final Component NO_DATA_TOOLTIP = Component.m_237115_((String)"configmenusforge.gui.select.no_data").m_130940_(ChatFormatting.RED);
    private static final Component NO_PERMISSIONS_TOOLTIP = Component.m_237115_((String)"configmenusforge.gui.select.no_permissions").m_130940_(ChatFormatting.GOLD);
    private static final Component MULTIPLAYER_SERVER_TOOLTIP = Component.m_237115_((String)"configmenusforge.gui.select.multiplayer_server").m_130940_(ChatFormatting.GOLD);
    private final SelectConfigScreen screen;
    private final Entry loadingHeader;
    private final CompletableFuture<List<LevelSummary>> pendingLevels;
    private List<LevelSummary> levelList;
    private String filter;

    public ConfigSelectionList(SelectConfigScreen selectConfigScreen, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, String filter, @Nullable ConfigSelectionList list) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = selectConfigScreen;
        this.filter = filter;
        this.loadingHeader = new LoadingHeader(this.f_93386_);
        this.pendingLevels = list != null ? list.pendingLevels : this.loadLevels();
        this.handleNewLevels(this.pollLevelsIgnoreErrors());
    }

    private static boolean matchesConfigSearch(ModConfig config, String query) {
        if (config.getFileName().toLowerCase(Locale.ROOT).contains(query)) {
            return true;
        }
        return config.getType().extension().contains(query);
    }

    public void updateFilter(String filter) {
        if (this.levelList != null && !filter.equals(this.filter)) {
            this.fillLevels(filter);
        }
        this.filter = filter;
    }

    private CompletableFuture<List<LevelSummary>> loadLevels() {
        LevelStorageSource.LevelCandidates levelCandidates;
        if (this.f_93386_.m_91403_() == null) {
            try {
                levelCandidates = this.f_93386_.m_91392_().m_230833_();
            }
            catch (LevelStorageException var3) {
                ForgeConfigScreens.LOGGER.error("Couldn't load level list", (Throwable)var3);
                return CompletableFuture.completedFuture(List.of());
            }
        } else {
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelCandidates.m_230843_()) {
            return CompletableFuture.completedFuture(List.of());
        }
        return this.f_93386_.m_91392_().m_230813_(levelCandidates).exceptionally(throwable -> {
            this.f_93386_.m_231412_(CrashReport.m_127521_((Throwable)throwable, (String)"Couldn't load level list"));
            return List.of();
        });
    }

    @Nullable
    private List<LevelSummary> pollLevelsIgnoreErrors() {
        try {
            return this.pendingLevels.getNow(null);
        }
        catch (CancellationException | CompletionException e) {
            return null;
        }
    }

    private void handleNewLevels(@Nullable List<LevelSummary> list) {
        if (list == null) {
            this.fillLoadingLevels();
        } else {
            this.fillLevels(this.filter);
        }
        this.levelList = list;
    }

    private void fillLoadingLevels() {
        this.m_93516_();
        this.m_7085_((AbstractSelectionList.Entry)this.loadingHeader);
        this.notifyListUpdated();
    }

    private void fillLevels(String filter) {
        this.m_93516_();
        filter = filter.toLowerCase(Locale.ROOT).trim();
        ArrayList<ModConfig> toSort = new ArrayList<ModConfig>();
        for (ModConfig config2 : this.screen.getConfigs()) {
            if (!ConfigSelectionList.matchesConfigSearch(config2, filter)) continue;
            toSort.add(config2);
        }
        toSort.sort(Comparator.comparing(config -> config.getType().extension()).thenComparing(ConfigListEntry::getName));
        for (ModConfig config2 : toSort) {
            this.m_7085_((AbstractSelectionList.Entry)new ConfigListEntry(this.screen, this.f_93386_, config2));
        }
        this.notifyListUpdated();
    }

    private void notifyListUpdated() {
        this.screen.m_169407_(true);
    }

    private void updateLevelList() {
        List<LevelSummary> list = this.pollLevelsIgnoreErrors();
        if (list != this.levelList) {
            this.handleNewLevels(list);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float tickDelta) {
        this.updateLevelList();
        super.m_88315_(guiGraphics, mouseX, mouseY, tickDelta);
    }

    protected int m_5756_() {
        return this.f_93388_ / 2 + 144;
    }

    public int m_5759_() {
        return 260;
    }

    public boolean m_93696_() {
        return this.screen.m_7222_() == this;
    }

    public void setSelected(@Nullable Entry configListEntry) {
        super.m_6987_((AbstractSelectionList.Entry)configListEntry);
        this.screen.updateButtonStatus(configListEntry != null && configListEntry.isSelectable());
    }

    public static class LoadingHeader
    extends Entry {
        private static final Component LOADING_LABEL = Component.m_237115_((String)"selectWorld.loading_list");
        private final Minecraft minecraft;

        public LoadingHeader(Minecraft minecraft) {
            this.minecraft = minecraft;
        }

        public void m_6311_(GuiGraphics guiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            int i = (this.minecraft.f_91080_.f_96543_ - this.minecraft.f_91062_.m_92852_((FormattedText)LOADING_LABEL)) / 2;
            int j = pTop + (pHeight - 9) / 2;
            guiGraphics.m_280430_(this.minecraft.f_91062_, LOADING_LABEL, i, j, 0xFFFFFF);
            String s = LoadingDotsText.m_232744_((long)Util.m_137550_());
            int k = (this.minecraft.f_91080_.f_96543_ - this.minecraft.f_91062_.m_92895_(s)) / 2;
            int l = j + 9;
            guiGraphics.m_280488_(this.minecraft.f_91062_, s, k, l, 0x808080);
        }

        public Component m_142172_() {
            return LOADING_LABEL;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        public abstract boolean isSelectable();
    }

    public class ConfigListEntry
    extends Entry {
        private final SelectConfigScreen screen;
        private final Minecraft minecraft;
        private final ModConfig config;
        private final boolean mayResetValue;
        private final Component nameComponent;
        private final Component fileNameComponent;
        private final Component typeComponent;
        private long lastClickTime;

        public ConfigListEntry(SelectConfigScreen selectConfigScreen, Minecraft minecraft, ModConfig config) {
            this.screen = selectConfigScreen;
            this.minecraft = minecraft;
            this.config = config;
            this.mayResetValue = selectConfigScreen.getValueToDataMap(config).values().stream().anyMatch(IEntryData::mayResetValue);
            this.nameComponent = this.mayResetValue ? Component.m_237113_((String)ConfigListEntry.getName(config)).m_130940_(ChatFormatting.ITALIC) : Component.m_237113_((String)ConfigListEntry.getName(config));
            this.fileNameComponent = Component.m_237113_((String)config.getFileName());
            String extension = config.getType().extension();
            this.typeComponent = Component.m_237110_((String)"configmenusforge.gui.type.title", (Object[])new Object[]{StringUtils.capitalize((String)extension)});
        }

        static String getName(ModConfig config) {
            String fullName = config.getFileName();
            int start = fullName.lastIndexOf(File.separator) + 1;
            int end = fullName.lastIndexOf(".");
            return fullName.substring(start, end < start ? fullName.length() : end);
        }

        public Component m_142172_() {
            MutableComponent component = Component.m_237113_((String)ConfigListEntry.getName(this.config));
            if (this.invalidData()) {
                component = CommonComponents.m_267603_((Component[])new Component[]{component, NO_DATA_TOOLTIP});
            } else if (this.noPermissions()) {
                component = CommonComponents.m_267603_((Component[])new Component[]{component, NO_PERMISSIONS_TOOLTIP});
            }
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{component});
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            Font font = this.minecraft.f_91062_;
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.nameComponent, entryLeft + 32 + 3, entryTop + 1, 0xFFFFFF);
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.fileNameComponent, entryLeft + 32 + 3, entryTop + 9 + 3, 0x808080);
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.typeComponent, entryLeft + 32 + 3, entryTop + 9 + 9 + 3, 0x808080);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(this.isDisabled() ? ICON_DISABLED_LOCATION : ICON_LOCATION, entryLeft, entryTop, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || hovered) {
                int textureY;
                guiGraphics.m_280509_(entryLeft, entryTop, entryLeft + 32, entryTop + 32, -1601138544);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean leftHovered = mouseX - entryLeft < 32;
                int n = textureY = leftHovered ? 32 : 0;
                if (this.needsWorldInstance()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 32.0f, (float)textureY, 32, 32, 256, 256);
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)SELECT_WORLD_TOOLTIP, 200));
                    }
                } else if (this.invalidData()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 96.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)NO_DATA_TOOLTIP, 200));
                    }
                } else if (this.noPermissions()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)NO_PERMISSIONS_TOOLTIP, 200));
                    }
                } else if (this.onMultiplayerServer()) {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 32.0f, (float)textureY, 32, 32, 256, 256);
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 64.0f, (float)textureY, 32, 32, 256, 256);
                    if (leftHovered) {
                        this.screen.setActiveTooltip(this.minecraft.f_91062_.m_92923_((FormattedText)MULTIPLAYER_SERVER_TOOLTIP, 200));
                    }
                } else {
                    guiGraphics.m_280163_(ICON_OVERLAY_LOCATION, entryLeft, entryTop, 0.0f, (float)textureY, 32, 32, 256, 256);
                }
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.isDisabled()) {
                return true;
            }
            ConfigSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(ConfigSelectionList.this.m_93511_() != null);
            if (mouseX - (double)ConfigSelectionList.this.m_5747_() <= 32.0) {
                this.openConfig();
                return true;
            }
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.openConfig();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public void openConfig() {
            if (this.needsWorldInstance()) {
                this.selectWorld();
            } else {
                ConfigScreen screen = ConfigScreen.create(this.screen, this.screen.getDisplayName(), this.config, this.screen.getValueToDataMap(this.config));
                this.minecraft.m_91152_((Screen)screen);
            }
        }

        private void selectWorld() {
            SelectConfigWorldScreen screen = new SelectConfigWorldScreen(this.screen, this.screen.getDisplayName(), this.config, ConfigSelectionList.this.levelList);
            this.minecraft.m_91152_((Screen)screen);
        }

        public boolean invalidData() {
            return this.screen.getValueToDataMap(this.config).isEmpty();
        }

        public boolean needsWorldInstance() {
            return !ConfigSelectionList.this.levelList.isEmpty() && this.config.getType() == ModConfig.Type.SERVER && this.minecraft.m_91403_() == null;
        }

        private boolean noPermissions() {
            return this.config.getType() == ModConfig.Type.SERVER && !this.screen.getServerPermissions();
        }

        public boolean onMultiplayerServer() {
            return this.config.getType() == ModConfig.Type.SERVER && !this.minecraft.m_91090_();
        }

        boolean isDisabled() {
            return !this.needsWorldInstance() && (this.invalidData() || this.noPermissions());
        }

        public ModConfig getConfig() {
            return this.config;
        }

        public boolean mayResetValue() {
            return this.mayResetValue;
        }

        @Override
        public boolean isSelectable() {
            return !this.isDisabled();
        }
    }
}

