/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.api.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.util.CustomTranslationTextComponent;
import java.util.Optional;
import net.minecraft.util.StringRepresentable;

public record LunarTextComponents(CustomTranslationTextComponent name, Optional<Notification> riseNotification, Optional<Notification> setNotification) {
    public static final Codec<LunarTextComponents> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CustomTranslationTextComponent.CODEC.fieldOf("name").forGetter(textComponents -> textComponents.name), (App)Notification.CODEC.optionalFieldOf("start_notification").orElse(Optional.empty()).forGetter(clientSettings -> clientSettings.riseNotification), (App)Notification.CODEC.optionalFieldOf("end_notification").orElse(Optional.empty()).forGetter(clientSettings -> clientSettings.setNotification)).apply((Applicative)builder, LunarTextComponents::new));

    public LunarTextComponents(CustomTranslationTextComponent name, CustomTranslationTextComponent riseNotification, CustomTranslationTextComponent setNotification) {
        this(name, Optional.of(new Notification(riseNotification, NotificationType.CHAT)), Optional.of(new Notification(setNotification, NotificationType.CHAT)));
    }

    public LunarTextComponents(CustomTranslationTextComponent name, Notification riseNotification, Notification setNotification) {
        this(name, Optional.of(riseNotification), Optional.of(setNotification));
    }

    public record Notification(CustomTranslationTextComponent customTranslationTextComponent, NotificationType notificationType) {
        public static final Codec<Notification> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CustomTranslationTextComponent.CODEC.fieldOf("component").forGetter(notification -> notification.customTranslationTextComponent), (App)NotificationType.CODEC.fieldOf("type").forGetter(notification -> notification.notificationType)).apply((Applicative)builder, Notification::new));
    }

    public static enum NotificationType implements StringRepresentable
    {
        CHAT,
        NONE,
        HOT_BAR;

        public static final Codec<NotificationType> CODEC;

        public static NotificationType byName(String name) {
            return NotificationType.valueOf(name.toUpperCase());
        }

        public String m_7912_() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.m_216439_(NotificationType::values);
        }
    }
}

