/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;

public class GuiUtil {
    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static Font getFont() {
        return Minecraft.m_91087_().f_91062_;
    }

    public static Minecraft minecraft() {
        return Minecraft.m_91087_();
    }

    public static void drawString(PoseStack stack, String text, int x, int y, int color, boolean shadow) {
        Font font = GuiUtil.minecraft().f_91062_;
        MultiBufferSource.BufferSource source = GuiUtil.minecraft().m_91269_().m_110104_();
        font.m_272078_(text, (float)x, (float)y, color, shadow, stack.m_85850_().m_252922_(), (MultiBufferSource)source, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
        RenderSystem.disableDepthTest();
        source.m_109911_();
        RenderSystem.enableDepthTest();
    }

    public static void prepTextScale(PoseStack poseStack, Consumer<PoseStack> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(x, y + yAdd, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        runnable.accept(poseStack);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderScaled(PoseStack stack, String text, int x, int y, float scale, int color, boolean shadow) {
        GuiUtil.prepTextScale(stack, m -> GuiUtil.drawString(stack, text, 0, 0, color, shadow), x, y, scale);
    }
}

