/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.init.ModObjects;

public class CobblestoneGeneratorRecipes
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    public ResourceLocation recipeId;
    private final HashMap<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();
    public Ingredient result;
    public int resultCount;
    public int duration;

    public CobblestoneGeneratorRecipes(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.result.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess access) {
        return this.m_8043_(access).m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.m_43908_()[0];
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    public int getIngredientCost(ItemStack stack) {
        for (Map.Entry<Ingredient, Integer> entry : this.ingredients.entrySet()) {
            if (!entry.getKey().test(stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModObjects.ROCK_GENERATING_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CobblestoneGeneratorRecipes> {
        public CobblestoneGeneratorRecipes fromJson(ResourceLocation recipeId, JsonObject json) {
            CobblestoneGeneratorRecipes recipe = new CobblestoneGeneratorRecipes(recipeId);
            JsonObject ingredient = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            recipe.resultCount = GsonHelper.m_13824_((JsonObject)ingredient, (String)"count", (int)1);
            recipe.result = Ingredient.m_43917_((JsonElement)json.get("result"));
            recipe.duration = GsonHelper.m_13824_((JsonObject)json, (String)"duration", (int)600);
            return recipe;
        }

        @Nullable
        public CobblestoneGeneratorRecipes fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            CobblestoneGeneratorRecipes recipe = new CobblestoneGeneratorRecipes(recipeId);
            recipe.result = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            recipe.duration = buffer.readInt();
            recipe.resultCount = buffer.readInt();
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buffer, CobblestoneGeneratorRecipes recipe) {
            recipe.result.m_43923_(buffer);
            buffer.writeInt(recipe.duration);
            buffer.writeInt(recipe.resultCount);
        }
    }
}

