/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;

public class UpgradeItem
extends Item {
    private String tooltipName;
    private Component tooltip;
    public int upgradeType;

    public UpgradeItem(Item.Properties properties, int Type2, String tooltipName) {
        super(properties);
        this.upgradeType = Type2;
        this.tooltipName = tooltipName;
    }

    public UpgradeItem(Item.Properties properties, int Type2) {
        super(properties);
        this.upgradeType = Type2;
    }

    public UpgradeItem(Item.Properties properties, int Type2, Component tooltip) {
        super(properties);
        this.upgradeType = Type2;
        this.tooltip = tooltip;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSameType(UpgradeItem upg) {
        return this.upgradeType == upg.upgradeType;
    }

    public boolean isValid(SmeltingBlockEntity blockEntity) {
        return this.isEnabled() && blockEntity.getUpgrades().stream().allMatch(this::isUpgradeCompatibleWith);
    }

    public boolean isUpgradeCompatibleWith(UpgradeItem upg) {
        return true;
    }

    public Component getDisabledMessage() {
        return Component.m_237115_((String)"tooltip.betterfurnacesreforged.upgrade.disabled").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!this.isEnabled()) {
            tooltip.add(this.getDisabledMessage());
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.betterfurnacesreforged.upgrade_right_click").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GOLD).m_131155_(Boolean.valueOf(true))));
        if (this.tooltip != null || this.tooltipName != null) {
            tooltip.add((Component)(this.tooltip == null ? Component.m_237115_((String)("tooltip.betterfurnacesreforged.upgrade." + this.tooltipName)).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)) : this.tooltip));
        }
    }
}

