/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.compat;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ibm.icu.impl.Pair;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.ArrayUtils;
import wily.betterfurnaces.Config;
import wily.betterfurnaces.blocks.CobblestoneGeneratorBlock;
import wily.betterfurnaces.client.screen.AbstractBasicScreen;
import wily.betterfurnaces.client.screen.CobblestoneGeneratorScreen;
import wily.betterfurnaces.client.screen.ForgeScreen;
import wily.betterfurnaces.client.screen.FurnaceScreen;
import wily.betterfurnaces.compat.BFRRecipeTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.items.TierUpgradeItem;
import wily.betterfurnaces.recipes.CobblestoneGeneratorRecipes;
import wily.betterfurnaces.util.FluidRenderUtil;
import wily.betterfurnaces.util.GuiUtil;
import wily.betterfurnaces.util.RecipeUtil;
import wily.factoryapi.base.client.IWindowWidget;
import wily.ultimatefurnaces.init.ModObjectsUF;

@JeiPlugin
public class BfJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("betterfurnacesreforged", "_plugin");
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        if (Config.enableJeiCatalysts.get().booleanValue() && Config.enableJeiPlugin.get().booleanValue()) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)ModObjects.COBBLESTONE_GENERATOR.get()), new RecipeType[]{BFRRecipeTypes.ROCK_GENERATING_JEI});
            Object[] blocks = new Block[]{(Block)ModObjects.IRON_FURNACE.get(), (Block)ModObjects.GOLD_FURNACE.get(), (Block)ModObjects.DIAMOND_FURNACE.get(), (Block)ModObjects.NETHERHOT_FURNACE.get(), (Block)ModObjects.EXTREME_FURNACE.get(), (Block)ModObjects.EXTREME_FORGE.get()};
            if (Config.enableUltimateFurnaces.get().booleanValue()) {
                blocks = (Block[])ArrayUtils.addAll((Object[])blocks, (Object[])new Block[]{(Block)ModObjectsUF.COPPER_FURNACE.get(), (Block)ModObjectsUF.STEEL_FURNACE.get(), (Block)ModObjectsUF.AMETHYST_FURNACE.get(), (Block)ModObjectsUF.PLATINUM_FURNACE.get(), (Block)ModObjectsUF.ULTIMATE_FURNACE.get(), (Block)ModObjectsUF.COPPER_FORGE.get(), (Block)ModObjectsUF.IRON_FORGE.get(), (Block)ModObjectsUF.GOLD_FORGE.get(), (Block)ModObjectsUF.DIAMOND_FORGE.get(), (Block)ModObjectsUF.NETHERHOT_FORGE.get(), (Block)ModObjectsUF.ULTIMATE_FORGE.get()});
            }
            for (Block block : blocks) {
                ItemStack smelting = new ItemStack((ItemLike)block);
                registry.addRecipeCatalyst(smelting, new RecipeType[]{RecipeTypes.SMELTING});
                registry.addRecipeCatalyst(smelting, new RecipeType[]{RecipeTypes.FUELING});
                ItemStack blasting = smelting.m_41777_();
                blasting.m_41784_().m_128405_("type", 1);
                registry.addRecipeCatalyst(blasting, new RecipeType[]{RecipeTypes.BLASTING});
                ItemStack smoking = smelting.m_41777_();
                smoking.m_41784_().m_128405_("type", 2);
                registry.addRecipeCatalyst(smoking, new RecipeType[]{RecipeTypes.SMOKING});
            }
        }
    }

    private void addDescription(IRecipeRegistration registry, ItemStack itemDefinition, Component ... message) {
        registry.addIngredientInfo((Object)itemDefinition, (IIngredientType)VanillaTypes.ITEM_STACK, message);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CobblestoneGeneratorCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        RecipeManager recipeManager = world.m_7465_();
        registration.addRecipes(BFRRecipeTypes.ROCK_GENERATING_JEI, RecipeUtil.getRecipes(recipeManager, (net.minecraft.world.item.crafting.RecipeType)ModObjects.ROCK_GENERATING_RECIPE.get()));
        Registration.ITEMS.forEach(item -> {
            Object patt4964$temp = item.get();
            if (patt4964$temp instanceof TierUpgradeItem) {
                TierUpgradeItem i = (TierUpgradeItem)((Object)((Object)patt4964$temp));
                this.addDescription(registration, new ItemStack((ItemLike)i), new Component[]{Component.m_237113_((String)I18n.m_118938_((String)"tooltip.betterfurnacesreforged.upgrade.tier", (Object[])new Object[]{i.from.m_49954_().getString(), i.to.m_49954_().getString()}))});
            }
        });
        if (Config.enableUltimateFurnaces.get().booleanValue()) {
            Registration.ITEMS.forEach(item -> {
                Object patt5296$temp = item.get();
                if (patt5296$temp instanceof TierUpgradeItem) {
                    TierUpgradeItem i = (TierUpgradeItem)((Object)((Object)patt5296$temp));
                    this.addDescription(registration, new ItemStack((ItemLike)i), new Component[]{Component.m_237113_((String)I18n.m_118938_((String)"tooltip.betterfurnacesreforged.upgrade.tier", (Object[])new Object[]{i.from.m_49954_().getString(), i.to.m_49954_().getString()}))});
                }
            });
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        if (Config.enableJeiClickArea.get().booleanValue() && Config.enableJeiPlugin.get().booleanValue()) {
            registry.addGenericGuiContainerHandler(AbstractBasicScreen.class, new IGuiContainerHandler<AbstractBasicScreen<?>>(){

                public List<Rect2i> getGuiExtraAreas(AbstractBasicScreen<?> containerScreen) {
                    ArrayList<Rect2i> list = new ArrayList<Rect2i>();
                    for (Renderable nested : containerScreen.getNestedRenderables()) {
                        if (!(nested instanceof IWindowWidget)) continue;
                        IWindowWidget w = (IWindowWidget)nested;
                        list.add(w.getBounds());
                    }
                    return list;
                }
            });
            registry.addRecipeClickArea(FurnaceScreen.class, 79, 35, 24, 17, new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
            registry.addRecipeClickArea(ForgeScreen.class, 80, 80, 24, 17, new RecipeType[]{RecipeTypes.SMELTING, RecipeTypes.FUELING});
            registry.addRecipeClickArea(CobblestoneGeneratorScreen.class, 58, 44, 17, 12, new RecipeType[]{BFRRecipeTypes.ROCK_GENERATING_JEI});
            registry.addRecipeClickArea(CobblestoneGeneratorScreen.class, 101, 44, 17, 12, new RecipeType[]{BFRRecipeTypes.ROCK_GENERATING_JEI});
        }
    }

    public static class CobblestoneGeneratorCategory
    implements IRecipeCategory<CobblestoneGeneratorRecipes> {
        private final Component title = ((CobblestoneGeneratorBlock)((Object)ModObjects.COBBLESTONE_GENERATOR.get())).m_49954_();
        private final IDrawable background;
        private final LoadingCache<Integer, Pair<IDrawableAnimated, IDrawableAnimated>> cachedProgressAnim;
        protected final IGuiHelper guiHelper;
        public static final ResourceLocation GUI = new ResourceLocation("betterfurnacesreforged", "textures/container/cobblestone_generator_gui.png");

        public CobblestoneGeneratorCategory(final IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(GUI, 46, 21, 85, 52);
            this.guiHelper = guiHelper;
            this.cachedProgressAnim = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, Pair<IDrawableAnimated, IDrawableAnimated>>(){

                public Pair<IDrawableAnimated, IDrawableAnimated> load(Integer cookTime) {
                    return Pair.of((Object)guiHelper.drawableBuilder(GUI, 176, 24, 17, 12).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false), (Object)guiHelper.drawableBuilder(GUI, 176, 36, 17, 12).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.RIGHT, false));
                }
            });
        }

        public void draw(CobblestoneGeneratorRecipes recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
            GuiUtil.renderScaled(graphics.m_280168_(), (float)recipe.duration / 20.0f + "s", 62, 45, 0.75f, 0x7E7E7E, false);
            FluidRenderUtil.renderTiledFluid(graphics, 12, 23, 17, 12, FluidStack.create((Fluid)Fluids.f_76195_, (long)1000L), false);
            FluidRenderUtil.renderTiledFluid(graphics, 55, 23, 17, 12, FluidStack.create((Fluid)Fluids.f_76193_, (long)1000L), true);
            Pair cache = (Pair)this.cachedProgressAnim.getUnchecked((Object)recipe.duration);
            ((IDrawableAnimated)cache.first).draw(graphics, 12, 23);
            this.guiHelper.createDrawable(GUI, 176, 0, 17, 12).draw(graphics, 12, 23);
            ((IDrawableAnimated)cache.second).draw(graphics, 55, 23);
            this.guiHelper.createDrawable(GUI, 176, 12, 17, 12).draw(graphics, 55, 23);
        }

        public RecipeType<CobblestoneGeneratorRecipes> getRecipeType() {
            return BFRRecipeTypes.ROCK_GENERATING_JEI;
        }

        public Component getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setRecipe(IRecipeLayoutBuilder builder, CobblestoneGeneratorRecipes recipe, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 34, 24).addItemStack(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
            builder.addSlot(RecipeIngredientRole.INPUT, 7, 6).addItemStack(new ItemStack((ItemLike)Items.f_42448_));
            builder.addSlot(RecipeIngredientRole.INPUT, 62, 6).addItemStack(new ItemStack((ItemLike)Items.f_42447_));
        }
    }
}

