/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.client.screen.AbstractBasicScreen;
import wily.betterfurnaces.client.screen.BetterFurnacesDrawables;
import wily.betterfurnaces.client.screen.FactoryUpgradeWindow;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.SmeltingMenu;
import wily.betterfurnaces.items.FactoryUpgradeItem;
import wily.betterfurnaces.items.GeneratorUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.betterfurnaces.network.Messages;
import wily.betterfurnaces.network.PacketShowSettingsButton;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.base.client.drawable.DrawableStaticProgress;
import wily.factoryapi.base.client.drawable.FactoryDrawableButton;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.util.StorageStringUtil;

public class SmeltingScreen<T extends SmeltingMenu>
extends AbstractBasicScreen<T> {
    Inventory playerInv;
    private FactoryDrawableButton showConfigButton;

    public ResourceLocation GUI() {
        return new ResourceLocation("betterfurnacesreforged:textures/container/furnace_gui.png");
    }

    protected int factoryShowButtonY() {
        return 3;
    }

    protected DrawableStatic fluidTankType() {
        return BetterFurnacesDrawables.FLUID_TANK.createStatic(this.f_97735_ + 73, this.f_97736_ + 49);
    }

    protected DrawableStaticProgress energyTankType() {
        int[] nArray;
        if (((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            int[] nArray2 = new int[2];
            nArray2[0] = 116;
            nArray = nArray2;
            nArray2[1] = 26;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = ((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get())) ? 26 : 31;
            nArray = nArray3;
            nArray3[1] = 17;
        }
        int[] pos = nArray;
        return (((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get())) ? BetterFurnacesDrawables.THIN_ENERGY_CELL : BetterFurnacesDrawables.ENERGY_CELL).createStatic(this.f_97735_ + pos[0], this.f_97736_ + pos[1]);
    }

    protected DrawableStatic generatorTankType() {
        return BetterFurnacesDrawables.MINI_FLUID_TANK.createStatic(this.f_97735_ + 54, this.f_97736_ + 18);
    }

    protected DrawableStatic xpTankType() {
        return BetterFurnacesDrawables.MINI_FLUID_TANK.createStatic(this.f_97735_ + 73, this.f_97736_ + 49);
    }

    public boolean storedFactoryUpgradeType(int type) {
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
            FactoryUpgradeItem stack = (FactoryUpgradeItem)((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).getUpgradeTypeSlotItem((UpgradeItem)((Object)ModObjects.FACTORY.get())).m_41720_();
            if (type == 0) {
                return true;
            }
            if (type == 1) {
                return stack.canInput;
            }
            if (type == 2) {
                return stack.canOutput;
            }
            if (type == 3) {
                return stack.pipeSide;
            }
            if (type == 4) {
                return stack.redstoneSignal;
            }
        }
        return false;
    }

    public SmeltingScreen(T t, Inventory inv, Component name) {
        super(t, inv, name);
        this.playerInv = inv;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96541_.f_91062_.m_92895_(this.m_96636_().getString())) / 2;
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).isForge()) {
            this.f_97730_ = (this.f_97726_ - this.f_96541_.f_91062_.m_92895_(this.f_169604_.getString())) / 2;
        }
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97729_ = this.f_97727_ - 160;
        this.showConfigButton = this.addNestedRenderable((FactoryDrawableButton)((FactoryDrawableButton)((FactoryDrawableButton)new FactoryDrawableButton(this.f_97735_ + 7, this.f_97736_ + this.factoryShowButtonY(), BetterFurnacesDrawables.FACTORY_BUTTON).selection(IFactoryDrawableType.Direction.HORIZONTAL)).visible(() -> this.storedFactoryUpgradeType(0))).onPress((b, i) -> Messages.INSTANCE.sendToServer((Object)new PacketShowSettingsButton(((SmeltingMenu)this.m_6262_()).getPos(), b.isSelected() ? 1 : 0))));
        this.addNestedRenderable(new FactoryUpgradeWindow((AbstractDrawableButton<?>)this.showConfigButton, this.f_97735_ - 53, this.f_97736_ + this.factoryShowButtonY(), this));
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int i, int j, float f) {
        this.showConfigButton.select(Boolean.valueOf(((SmeltingMenu)this.m_6262_()).showInventoryButtons()));
        if (this.showConfigButton.isSelected()) {
            this.showConfigButton.tooltips(SmeltingScreen.getShiftInfoGui());
        } else {
            this.showConfigButton.tooltip((Component)Component.m_237115_((String)"tooltip.betterfurnacesreforged.gui_open"));
        }
        super.m_88315_(graphics, i, j, f);
        this.showConfigButton.clearTooltips();
    }

    public static List<Component> getShiftInfoGui() {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"tooltip.betterfurnacesreforged.gui_close"));
        MutableComponent tooltip1 = Component.m_237115_((String)"tooltip.betterfurnacesreforged.gui_hold_shift");
        MutableComponent shift = Component.m_237113_((String)"[Shift]");
        MutableComponent tooltip2 = Component.m_237115_((String)"tooltip.betterfurnacesreforged.gui_shift_more_options");
        tooltip1.m_130940_(ChatFormatting.GRAY);
        shift.m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
        tooltip2.m_130940_(ChatFormatting.GRAY);
        list.add(tooltip1.m_7220_((Component)shift).m_7220_((Component)tooltip2));
        return list;
    }

    public Component m_96636_() {
        return ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).m_7755_();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
        int actualMouseX = mouseX - this.f_97735_;
        int actualMouseY = mouseY - this.f_97736_;
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).isLiquid() && this.fluidTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            graphics.m_280557_(this.f_96547_, StorageStringUtil.getFluidTooltip((String)"tooltip.factory_api.fluid_stored", (IPlatformFluidHandler)((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).fluidTank), actualMouseX, actualMouseY);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) && this.generatorTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            ItemStack gen = ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
            graphics.m_280557_(this.f_96547_, StorageStringUtil.getFluidTooltip((String)"tooltip.factory_api.fluid_stored", (IPlatformFluidHandler)((GeneratorUpgradeItem)gen.m_41720_()).getFluidStorage(gen)), actualMouseX, actualMouseY);
        }
        if ((((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) || ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) && this.energyTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            graphics.m_280557_(this.f_96547_, (Component)StorageStringUtil.getEnergyTooltip((String)"tooltip.factory_api.energy_stored", (IPlatformEnergyStorage)((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).energyStorage), actualMouseX, actualMouseY);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasXPTank() && this.xpTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            graphics.m_280557_(this.f_96547_, StorageStringUtil.getFluidTooltip((String)"tooltip.factory_api.fluid_stored", (IPlatformFluidHandler)((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).xpTank), actualMouseX, actualMouseY);
        }
    }

    protected void blitSmeltingSprites(GuiGraphics graphics) {
        int i;
        if (((SmeltingMenu)this.m_6262_()).BurnTimeGet() > 0) {
            i = ((SmeltingMenu)this.m_6262_()).getBurnLeftScaled(13);
            graphics.m_280218_(this.GUI(), this.f_97735_ + 55, this.f_97736_ + 37 + 12 - i, 176, 12 - i, 14, i + 1);
        }
        i = ((SmeltingMenu)this.m_6262_()).getCookScaled(24);
        graphics.m_280218_(this.GUI(), this.f_97735_ + 79, this.f_97736_ + 34, 176, 14, i + 1, 16);
        BetterFurnacesDrawables.SLOT.draw(graphics, this.f_97735_ + 53, this.f_97736_ + 17);
        boolean storage = ((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).hasUpgrade((UpgradeItem)((Object)ModObjects.STORAGE.get()));
        if (storage) {
            BetterFurnacesDrawables.SLOT.draw(graphics, this.f_97735_ + 35, this.f_97736_ + 17);
            BetterFurnacesDrawables.SLOT.draw(graphics, this.f_97735_ + 35, this.f_97736_ + 53);
        }
        if (!((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            BetterFurnacesDrawables.BIG_SLOT.draw(graphics, this.f_97735_ + 111, this.f_97736_ + 30);
            if (storage) {
                BetterFurnacesDrawables.SLOT.draw(graphics, this.f_97735_ + 137, this.f_97736_ + 34);
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(this.GUI(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.blitSmeltingSprites(graphics);
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) || ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            boolean storage = ((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()));
            graphics.m_280218_(BetterFurnacesDrawables.WIDGETS, this.energyTankType().m_110085_(), this.energyTankType().m_110086_(), 240 + (storage ? 8 : 0), 34 * (storage ? 2 : 1), 16 - (storage ? 8 : 0), 34);
            this.energyTankType().drawProgress(graphics, ((SmeltingMenu)this.m_6262_()).getEnergyStored(), ((SmeltingMenu)this.m_6262_()).getMaxEnergyStored());
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).isLiquid()) {
            graphics.m_280218_(BetterFurnacesDrawables.WIDGETS, this.fluidTankType().m_110085_(), this.fluidTankType().m_110086_(), 192, 38, 20, 22);
            this.fluidTankType().drawAsFluidTank(graphics, ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).fluidTank.getFluidStack(), ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).fluidTank.getMaxFluid(), true);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasXPTank()) {
            graphics.m_280218_(BetterFurnacesDrawables.WIDGETS, this.xpTankType().m_110085_(), this.xpTankType().m_110086_(), 208, 0, 16, 16);
            this.xpTankType().drawAsFluidTank(graphics, ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).xpTank.getFluidStack(), ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).xpTank.getMaxFluid(), true);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            ItemStack generatorUp = ((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
            this.generatorTankType().drawAsFluidTank(graphics, ItemContainerUtil.getFluid((ItemStack)generatorUp), 4L * FluidStack.bucketAmount(), true);
        }
        if (this.storedFactoryUpgradeType(3) && this.showConfigButton.isSelected()) {
            boolean input = false;
            boolean output = false;
            boolean both = false;
            boolean fuel = false;
            for (int set : ((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).furnaceSettings.getFurnaceSetting("Settings")) {
                if (set == 1) {
                    input = true;
                    continue;
                }
                if (set == 2) {
                    output = true;
                    continue;
                }
                if (set == 3) {
                    both = true;
                    continue;
                }
                if (set != 4) continue;
                fuel = true;
            }
            this.blitSlotsLayer(graphics, input, both, fuel, output);
        }
    }

    protected void blitSlotsLayer(GuiGraphics graphics, boolean input, boolean both, boolean fuel, boolean output) {
        boolean storage = ((SmeltingBlockEntity)((SmeltingMenu)this.f_97732_).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()));
        if (!((SmeltingBlockEntity)((SmeltingMenu)this.m_6262_()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            if (input || both) {
                if (storage) {
                    BetterFurnacesDrawables.INPUT_SLOT_OUTLINE.draw(graphics, this.f_97735_ + 35, this.f_97736_ + 17);
                }
                BetterFurnacesDrawables.INPUT_SLOT_OUTLINE.draw(graphics, this.f_97735_ + 53, this.f_97736_ + 17);
            }
            if (output || both) {
                if (storage) {
                    BetterFurnacesDrawables.OUTPUT_SLOT_OUTLINE.draw(graphics, this.f_97735_ + 137, this.f_97736_ + 34);
                }
                BetterFurnacesDrawables.BIG_OUTPUT_SLOT_OUTLINE.draw(graphics, this.f_97735_ + 111, this.f_97736_ + 30);
            }
        }
        if (fuel) {
            if (storage) {
                BetterFurnacesDrawables.FUEL_SLOT_OUTLINE.draw(graphics, this.f_97735_ + 35, this.f_97736_ + 53);
            }
            BetterFurnacesDrawables.FUEL_SLOT_OUTLINE.draw(graphics, this.f_97735_ + 53, this.f_97736_ + 53);
        }
    }
}

