/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.util.VoxelShapeUtil;

public class ForgeBlock
extends SmeltingBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape FORGE_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)ForgeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ForgeBlock.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), ForgeBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), ForgeBlock.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), ForgeBlock.m_49796_((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), ForgeBlock.m_49796_((double)1.75, (double)15.0, (double)1.75, (double)14.5, (double)15.0, (double)14.5), ForgeBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ForgeBlock.m_49796_((double)1.0, (double)0.5, (double)1.0, (double)15.0, (double)15.0, (double)15.0)}), (BooleanOp)BooleanOp.f_82689_);

    public ForgeBlock(BlockBehaviour.Properties properties, Supplier<Integer> defaultCookTime) {
        super(properties.m_60955_(), defaultCookTime);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ForgeBlock(BlockBehaviour.Properties properties, Item.Properties itemProperties, Supplier<Integer> defaultCookTime) {
        this(properties.m_60955_(), defaultCookTime);
        this.itemProperties = itemProperties;
    }

    public VoxelShape m_5940_(BlockState p_48735_, BlockGetter p_48736_, BlockPos p_48737_, CollisionContext p_48738_) {
        return VoxelShapeUtil.rotate((VoxelShape)FORGE_SHAPE, (Direction)((Direction)p_48735_.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_7820_().m_122424_();
        boolean flag = ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    protected InteractionResult interactUpgrade(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack stack) {
        Item hand = player.m_21120_(handIn).m_41720_();
        if (!(hand instanceof UpgradeItem)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof SmeltingBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        SmeltingBlockEntity smelt = (SmeltingBlockEntity)be;
        ItemStack newStack = new ItemStack((ItemLike)stack.m_41720_(), 1);
        newStack.m_41751_(stack.m_41783_());
        if (((UpgradeItem)hand).upgradeType == 1) {
            if (!smelt.inventory.m_8020_(10).m_41619_() && !player.m_7500_()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)((Container)be).m_8020_(10));
            }
            smelt.inventory.m_6836_(10, newStack);
            world.m_5594_(null, be.m_58899_(), SoundEvents.f_11677_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                player.m_21120_(handIn).m_41774_(1);
            }
        } else {
            return super.interactUpgrade(world, pos, player, handIn, stack);
        }
        ((SmeltingBlockEntity)be).onUpdateSent();
        return InteractionResult.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            if (world.m_7702_(pos) == null) {
                return;
            }
            if (!(world.m_7702_(pos) instanceof SmeltingBlockEntity)) {
                return;
            }
            SmeltingBlockEntity be = (SmeltingBlockEntity)world.m_7702_(pos);
            if (state.m_61143_((Property)BlockStateProperties.f_61372_) == Direction.UP) {
                double d0 = (double)pos.m_123341_() + 0.5;
                double d1 = (double)pos.m_123342_() + rand.m_188500_() * 6.0 / 16.0;
                double d2 = (double)pos.m_123343_() + 0.5;
                double d4 = rand.m_188500_() * 0.6 - 0.3;
                if (rand.m_188500_() < 0.1) {
                    world.m_7785_(d0, (double)pos.m_123342_(), d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0);
            } else {
                for (int l = 0; l < 3; ++l) {
                    double d0 = (float)pos.m_123341_() + rand.m_188501_();
                    double d1 = (float)pos.m_123342_() + rand.m_188501_();
                    double d2 = (float)pos.m_123343_() + rand.m_188501_();
                    int i1 = rand.m_188503_(2) * 2 - 1;
                    double d3 = ((double)rand.m_188501_() - 0.5) * 0.2;
                    double d4 = ((double)rand.m_188501_() - 0.5) * 0.2;
                    double d5 = ((double)rand.m_188501_() - 0.5) * 0.2;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123800_, d0, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityTypes.FORGE_TILE.get()).m_155264_(blockPos, blockState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ForgeBlock.createFurnaceTicker(level, type, (BlockEntityType<? extends SmeltingBlockEntity>)((BlockEntityType)BlockEntityTypes.FORGE_TILE.get()));
    }

    @Override
    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        if (p_185499_2_ == Rotation.CLOCKWISE_90 || p_185499_2_ == Rotation.COUNTERCLOCKWISE_90) {
            if ((Direction)p_185499_1_.m_61143_((Property)FACING) == Direction.WEST || (Direction)p_185499_1_.m_61143_((Property)FACING) == Direction.EAST) {
                return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)Direction.UP);
            }
            if ((Direction)p_185499_1_.m_61143_((Property)FACING) == Direction.UP || (Direction)p_185499_1_.m_61143_((Property)FACING) == Direction.DOWN) {
                return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)Direction.WEST);
            }
        }
        return p_185499_1_;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, WATERLOGGED, BlockStateProperties.f_61443_, COLORED});
    }
}

