/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import com.google.common.collect.Lists;
import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import dev.architectury.registry.fuel.FuelRegistry;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.Config;
import wily.betterfurnaces.ProjectMMO;
import wily.betterfurnaces.blockentity.FactoryUpgradeSettings;
import wily.betterfurnaces.blockentity.ForgeBlockEntity;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blockentity.LRUCache;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.SlotFuel;
import wily.betterfurnaces.inventory.SlotInput;
import wily.betterfurnaces.inventory.SlotOutput;
import wily.betterfurnaces.inventory.SlotUpgrade;
import wily.betterfurnaces.inventory.SmeltingMenu;
import wily.betterfurnaces.items.FuelEfficiencyUpgradeItem;
import wily.betterfurnaces.items.GeneratorUpgradeItem;
import wily.betterfurnaces.items.LiquidFuelUpgradeItem;
import wily.betterfurnaces.items.OreProcessingUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportState;

public class SmeltingBlockEntity
extends InventoryBlockEntity
implements RecipeHolder,
StackedContentsCompatible {
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    private Random rand = new Random();
    public int showInventorySettings;
    public boolean showOrientation;
    protected int timer;
    private int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime = this.getCookTime();
    private int recipesUsed;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    public RecipeType<? extends AbstractCookingRecipe> recipeType;
    public FactoryUpgradeSettings furnaceSettings;
    private final LRUCache<Item, Optional<AbstractCookingRecipe>> cache = LRUCache.newInstance(Config.cacheCapacity.get());
    protected LRUCache<Item, Optional<AbstractCookingRecipe>> blasting_cache = LRUCache.newInstance(Config.cacheCapacity.get());
    protected LRUCache<Item, Optional<AbstractCookingRecipe>> smoking_cache = LRUCache.newInstance(Config.cacheCapacity.get());
    public final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> SmeltingBlockEntity.this.furnaceBurnTime;
                case 1 -> SmeltingBlockEntity.this.recipesUsed;
                case 2 -> SmeltingBlockEntity.this.cookTime;
                case 3 -> SmeltingBlockEntity.this.totalCookTime;
                case 4 -> SmeltingBlockEntity.this.showInventorySettings;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SmeltingBlockEntity.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    SmeltingBlockEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    SmeltingBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    SmeltingBlockEntity.this.totalCookTime = value;
                    break;
                }
                case 4: {
                    SmeltingBlockEntity.this.showInventorySettings = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    public static final SlotsIdentifier XP = new SlotsIdentifier(ChatFormatting.GREEN, "green");
    public final IPlatformFluidHandler fluidTank = new FactoryFluidHandler(this.LiquidCapacity(), (BlockEntity)this, fs -> LiquidFuelUpgradeItem.supportsFluid(fs.getFluid()), SlotsIdentifier.LAVA, TransportState.EXTRACT_INSERT);
    public final IPlatformFluidHandler xpTank = new FactoryFluidHandler(2L * FluidStack.bucketAmount(), (BlockEntity)this, xp -> xp.getFluid().m_6212_(Config.getLiquidXP()), XP, TransportState.EXTRACT_INSERT);
    public final IPlatformEnergyStorage energyStorage = new FactoryEnergyStorage(this.EnergyCapacity(), (BlockEntity)this);
    TagKey<Item> ore = this.getItemTag(new ResourceLocation(Platform.isForge() ? "forge" : "c", "ores"));

    public int[] FUEL() {
        int[] inputs = new int[]{1};
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            inputs = new int[]{1, 7};
        }
        return inputs;
    }

    public int HEATER() {
        return this.FUEL()[0];
    }

    public int[] UPGRADES() {
        return new int[]{3, 4, 5};
    }

    public int FINPUT() {
        return this.INPUTS()[0];
    }

    public int LINPUT() {
        return this.INPUTS()[this.INPUTS().length - 1];
    }

    public int FOUTPUT() {
        return this.OUTPUTS()[0];
    }

    public int LOUTPUT() {
        return this.OUTPUTS()[this.OUTPUTS().length - 1];
    }

    public int[] INPUTS() {
        int[] inputs = new int[]{0};
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            inputs = new int[]{0, 6};
        }
        return inputs;
    }

    public int[] OUTPUTS() {
        int[] outputs = new int[]{2};
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            outputs = new int[]{2, 8};
        }
        return outputs;
    }

    public int[] FSLOTS() {
        return ArrayUtils.addAll((int[])this.ISLOTS(), (int[])this.OUTPUTS());
    }

    public int[] ISLOTS() {
        return ArrayUtils.addAll((int[])this.INPUTS(), (int[])this.FUEL());
    }

    public int EnergyUse() {
        return 500;
    }

    public long LiquidCapacity() {
        return 4L * FluidStack.bucketAmount();
    }

    public int EnergyCapacity() {
        return 16000;
    }

    public boolean isForge() {
        return this instanceof ForgeBlockEntity;
    }

    public SmeltingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.recipeType = RecipeType.f_44108_;
        this.furnaceSettings = new FactoryUpgradeSettings(() -> this.getUpgradeTypeSlotItem((UpgradeItem)((Object)((Object)ModObjects.FACTORY.get())))){

            @Override
            public void onChanged() {
                if (SmeltingBlockEntity.this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
                    SmeltingBlockEntity.this.inventory.m_6836_(SmeltingBlockEntity.this.getUpgradeTypeSlot((UpgradeItem)((Object)ModObjects.FACTORY.get())), (ItemStack)this.factory.get());
                }
                SmeltingBlockEntity.this.m_6596_();
            }
        };
    }

    public SmeltingBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get(), pos, state);
    }

    private int getFromCache(LRUCache<Item, Optional<AbstractCookingRecipe>> c, Item key) {
        if (c == null) {
            return 0;
        }
        if (c.get(key) == null) {
            return 0;
        }
        return ((Optional)c.get(key)).orElse(null) == null ? 0 : ((AbstractCookingRecipe)((Optional)c.get(key)).orElse(null)).m_43753_();
    }

    public boolean hasRecipe(ItemStack stack) {
        return this.grabRecipe(stack).isPresent();
    }

    protected LRUCache<Item, Optional<AbstractCookingRecipe>> getCache() {
        LRUCache[] caches = new LRUCache[]{this.cache, this.blasting_cache, this.smoking_cache};
        return caches[this.getUpdatedType() >= 3 ? 0 : this.getUpdatedType()];
    }

    private Optional<AbstractCookingRecipe> getRecipe(ItemStack stack, RecipeType recipeType) {
        return this.f_58857_.m_7465_().m_44015_(recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
    }

    private Optional<AbstractCookingRecipe> grabRecipe(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional<AbstractCookingRecipe> recipe = (Optional<AbstractCookingRecipe>)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.getRecipe(stack, this.recipeType);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    public boolean hasXPTank() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.XP.get()));
    }

    public boolean hasEnder() {
        return this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FUEL.get()));
    }

    public int getEnderMultiplier() {
        if (this.hasEnder()) {
            return ((FuelEfficiencyUpgradeItem)this.getUpgradeTypeSlotItem((UpgradeItem)((UpgradeItem)((Object)ModObjects.FUEL.get()))).m_41720_()).getMultiplier;
        }
        return 1;
    }

    public boolean isLiquid() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.LIQUID.get()));
    }

    private boolean isEnergy() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) && this.energyStorage.getEnergyStored() >= this.EnergyUse();
    }

    public int getCookTime() {
        if (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) || this.arraySlotAllEmpty(this.INPUTS())) {
            return this.getDefaultCookTime();
        }
        int speed = this.getSpeed();
        if (speed == -1) {
            return -1;
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int j = 0;
        int length = this.INPUTS().length;
        for (int i : this.INPUTS()) {
            int iC;
            ItemStack stack = this.inventory.m_8020_(i);
            int cache = this.getFromCache(this.getCache(), stack.m_41720_());
            int n = iC = cache <= 0 ? this.grabRecipe(stack).map(AbstractCookingRecipe::m_43753_).orElse(-1) : cache;
            if (iC <= 0) {
                --length;
                continue;
            }
            j += iC;
        }
        int n = j = length <= 0 ? 0 : j / length;
        if (j < this.getDefaultCookTime()) {
            return (int)((float)j * ((float)this.getDefaultCookTime() / 200.0f));
        }
        return this.getDefaultCookTime();
    }

    public List<UpgradeItem> getUpgrades() {
        ArrayList<UpgradeItem> list = new ArrayList<UpgradeItem>();
        for (int slot : this.UPGRADES()) {
            Item item = this.inventory.m_8020_(slot).m_41720_();
            if (!(item instanceof UpgradeItem)) continue;
            UpgradeItem upg = (UpgradeItem)item;
            list.add(upg);
        }
        return list;
    }

    public boolean hasUpgrade(UpgradeItem upg) {
        for (int slot : this.UPGRADES()) {
            if (!((Object)((Object)upg)).equals(this.inventory.m_8020_(slot).m_41720_()) || !upg.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpgradeType(UpgradeItem upg) {
        return this.getUpgradeTypeSlot(upg) >= 0;
    }

    public int getDefaultCookTime() {
        return this.f_58857_ != null && this.m_58900_().m_60734_() instanceof SmeltingBlock ? ((SmeltingBlock)this.m_58900_().m_60734_()).defaultCookTime.get() : 200;
    }

    public ItemStack getUpgradeTypeSlotItem(UpgradeItem upg) {
        int i = this.getUpgradeTypeSlot(upg);
        return i < 0 ? ItemStack.f_41583_ : this.inventory.m_8020_(i);
    }

    public int getUpgradeTypeSlot(UpgradeItem upg) {
        for (int slot : this.UPGRADES()) {
            UpgradeItem upgradeItem;
            Item item = this.inventory.m_8020_(slot).m_41720_();
            if (!(item instanceof UpgradeItem) || !(upgradeItem = (UpgradeItem)item).isEnabled() || !upg.isSameType(upgradeItem)) continue;
            return slot;
        }
        return -1;
    }

    public ItemStack getUpgradeSlotItem(Item upg) {
        for (int slot : this.UPGRADES()) {
            if (upg != this.inventory.m_8020_(slot).m_41720_()) continue;
            return this.inventory.m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    public static int getFluidBurnTime(FluidStack stack) {
        return stack == null ? 0 : FuelRegistry.get((ItemStack)stack.getFluid().m_6859_().m_7968_());
    }

    public void forceUpdateAllStates() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() != this.isBurning()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
    }

    public int correspondentOutputSlot(int input) {
        return this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get())) ? Arrays.stream(this.OUTPUTS()).filter(i -> this.canSmelt(this.irecipeSlot(input).orElse(null), input, i)).min().orElse(-1) : this.FOUTPUT() - this.FINPUT() + input;
    }

    public void trySmelt() {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            int i = this.correspondentOutputSlot(this.FINPUT());
            if (i >= 0) {
                this.smeltItem(this.irecipeSlot(this.FINPUT()).orElse(null), this.FINPUT(), i);
            }
        } else {
            for (int i : this.INPUTS()) {
                if (!this.canSmelt(this.irecipeSlot(i).orElse(null), i, this.correspondentOutputSlot(i))) continue;
                this.smeltItem(this.irecipeSlot(i).orElse(null), i, this.correspondentOutputSlot(i));
            }
        }
    }

    public int getUpdatedType() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.BLAST.get())) ? 1 : (this.hasUpgrade((UpgradeItem)((Object)ModObjects.SMOKE.get())) ? 2 : (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) ? 3 : 0));
    }

    @Override
    public Component m_5446_() {
        String tier = this.m_58900_().m_60734_().arch$registryName().m_135815_().split("_")[0];
        return this.getUpdatedType() != 0 ? Component.m_237110_((String)("tooltip.betterfurnacesreforged." + tier + "_tier"), (Object[])new Object[]{this.getUpdatedType() == 1 ? Blocks.f_50620_.m_49954_().getString() : (this.getUpdatedType() == 2 ? Blocks.f_50619_.m_49954_().getString() : (this.getUpdatedType() == 3 ? Component.m_237115_((String)"tooltip.betterfurnacesreforged.generator").getString() : ""))}) : super.m_5446_();
    }

    public Optional<AbstractCookingRecipe> irecipeSlot(int input) {
        if (!ArrayUtils.contains((int[])this.INPUTS(), (int)input)) {
            return Optional.empty();
        }
        if (!this.inventory.m_8020_(input).m_41619_()) {
            return this.grabRecipe(this.inventory.m_8020_(input));
        }
        return Optional.empty();
    }

    public boolean hasArraySlotSpace(int[] slots) {
        for (int i : slots) {
            boolean noFull;
            boolean bl = noFull = this.inventory.m_8020_(i).m_41613_() < this.inventory.m_8020_(i).m_41741_() && !this.inventory.m_8020_(i).m_41619_();
            if (noFull) continue;
            return true;
        }
        return false;
    }

    public boolean arraySlotFilled(int[] slots, boolean isFilled) {
        for (int i : slots) {
            boolean filled = this.inventory.m_8020_(i).m_41619_();
            if (!isFilled) {
                boolean bl = filled = !filled;
            }
            if (filled) continue;
            return true;
        }
        return false;
    }

    public boolean arraySlotAllEmpty(int[] slots) {
        for (int i : slots) {
            boolean empty = this.inventory.m_8020_(i).m_41619_();
            if (empty) continue;
            return false;
        }
        return true;
    }

    public boolean canGeneratorWork() {
        if (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            ItemStack stack = this.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
            return ItemContainerUtil.isFluidContainer((ItemStack)stack) && ItemContainerUtil.getFluid((ItemStack)stack).getAmount() > 0L && this.energyStorage.getEnergySpace() > 0;
        }
        return false;
    }

    public boolean smeltValid() {
        if (!this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            for (int i : this.INPUTS()) {
                if (!this.canSmelt(this.irecipeSlot(i).orElse(null), i, this.correspondentOutputSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState blockState, SmeltingBlockEntity be) {
        boolean wasBurning = be.isBurning();
        boolean flag1 = false;
        boolean flag2 = false;
        if (be.isBurning()) {
            --be.furnaceBurnTime;
        }
        if (be.hasXPTank()) {
            be.grantStoredRecipeExperience(level, null);
        }
        if (!be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get())) && be.showOrientation) {
            be.showOrientation = false;
        }
        ItemStack fuel = be.inventory.m_8020_(be.FUEL()[0]);
        if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.COLOR.get()))) {
            if (!((Boolean)level.m_8055_(be.m_58899_()).m_61143_((Property)SmeltingBlock.COLORED)).booleanValue()) {
                level.m_7731_(be.m_58899_(), (BlockState)level.m_8055_(be.m_58899_()).m_61124_((Property)SmeltingBlock.COLORED, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (((Boolean)level.m_8055_(be.m_58899_()).m_61143_((Property)SmeltingBlock.COLORED)).booleanValue()) {
            level.m_7731_(be.m_58899_(), (BlockState)level.m_8055_(be.m_58899_()).m_61124_((Property)SmeltingBlock.COLORED, (Comparable)Boolean.valueOf(false)), 3);
        }
        int updatedType = be.getUpdatedType();
        RecipeType[] recipeTypes = new RecipeType[]{RecipeType.f_44108_, RecipeType.f_44109_, RecipeType.f_44110_};
        if (updatedType == 3) {
            for (int i : new int[]{be.FINPUT(), be.FOUTPUT()}) {
                ItemStack stack = be.inventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)be.m_58899_().m_123341_(), (double)(be.m_58899_().m_123342_() + 1), (double)be.m_58899_().m_123343_(), (ItemStack)stack);
            }
        } else if (be.recipeType != recipeTypes[updatedType]) {
            be.recipeType = recipeTypes[updatedType];
        }
        if (!be.isForge() && (Integer)level.m_8055_(be.m_58899_()).m_61143_((Property)SmeltingBlock.TYPE) != updatedType) {
            level.m_7731_(be.m_58899_(), (BlockState)level.m_8055_(be.m_58899_()).m_61124_((Property)SmeltingBlock.TYPE, (Comparable)Integer.valueOf(updatedType)), 3);
        }
        if (!level.f_46443_) {
            ItemContainerUtil.ItemFluidContext context;
            long amount;
            int mode;
            int get_cook_time = be.getCookTime();
            ++be.timer;
            if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    IPlatformEnergyStorage energyStorage;
                    Direction d = directionArray[i];
                    BlockEntity other = be.m_58904_().m_7702_(be.m_58899_().m_121945_(d));
                    if (other == null || (energyStorage = (IPlatformEnergyStorage)FactoryAPIPlatform.getPlatformFactoryStorage((BlockEntity)be).getStorage(Storages.ENERGY, d.m_122424_()).get()) == null) continue;
                    be.energyStorage.consumeEnergy(energyStorage.receiveEnergy(Math.min(energyStorage.getMaxReceive(), be.energyStorage.getMaxConsume()), false), false);
                }
            }
            if (be.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
                ItemStack storageFuel;
                ItemStack storageInput = be.inventory.m_8020_(6);
                if (!storageInput.m_41619_()) {
                    be.inventory.m_6836_(6, be.inventory.insertItem(be.FINPUT(), storageInput, false));
                }
                if (!(storageFuel = be.inventory.m_8020_(7)).m_41619_()) {
                    be.inventory.m_6836_(7, be.inventory.insertItem(be.FUEL()[0], storageFuel, false));
                }
            } else if (!be.isForge()) {
                for (int i : new int[]{6, 7, 8}) {
                    ItemStack stack = be.inventory.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)be.m_58899_().m_123341_(), (double)(be.m_58899_().m_123342_() + 1), (double)be.m_58899_().m_123343_(), (ItemStack)stack);
                }
            }
            if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) && ItemContainerUtil.isEnergyContainer((ItemStack)fuel) && ItemContainerUtil.getEnergy((ItemStack)fuel) > 0 && be.energyStorage.getEnergySpace() > 0) {
                be.energyStorage.receiveEnergy(ItemContainerUtil.extractEnergy((int)be.energyStorage.getEnergySpace(), (ItemStack)fuel).contextEnergy(), false);
                be.inventory.m_6836_(be.FUEL()[0], fuel);
            }
            if (be.totalCookTime != get_cook_time) {
                be.totalCookTime = get_cook_time;
            }
            if ((mode = be.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    int i = 0;
                    for (Direction side : Direction.values()) {
                        if (level.m_277185_(worldPosition.m_121955_(side.m_122436_()), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        be.cookTime = 0;
                        be.furnaceBurnTime = 0;
                        be.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (Direction side : Direction.values()) {
                        if (level.m_277185_(worldPosition.m_121955_(side.m_122436_()), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        be.cookTime = 0;
                        be.furnaceBurnTime = 0;
                        be.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < Direction.values().length; ++i) {
                    be.provides[i] = be.m_58900_().m_60775_((BlockGetter)be.f_58857_, worldPosition, Direction.values()[i]);
                }
            } else {
                for (i = 0; i < Direction.values().length; ++i) {
                    be.provides[i] = 0;
                }
            }
            if (be.doesNeedUpdateSend()) {
                be.onUpdateSent();
            }
            if (be.isLiquid() && LiquidFuelUpgradeItem.supportsItemFluidHandler(fuel) && (amount = be.fluidTank.fill((context = ItemContainerUtil.drainItem((long)be.fluidTank.getTotalSpace(), (ItemStack)fuel)).fluidStack(), false)) > 0L) {
                level.m_6263_(null, (double)worldPosition.m_123341_(), (double)worldPosition.m_123342_(), (double)worldPosition.m_123343_(), SoundEvents.f_11783_, SoundSource.PLAYERS, 0.6f, 0.8f);
                be.inventory.m_6836_(be.FUEL()[0], context.container());
            }
            if ((be.isBurning() || !fuel.m_41619_() || be.isLiquid() || be.isEnergy() && !be.canGeneratorWork()) && (be.arraySlotFilled(be.INPUTS(), true) || be.canGeneratorWork())) {
                boolean valid;
                boolean bl = valid = be.smeltValid() || be.canGeneratorWork();
                if (!be.isBurning() && valid) {
                    if (be.isLiquid() && !be.fluidTank.getFluidStack().isEmpty() && SmeltingBlockEntity.getFluidBurnTime(be.fluidTank.getFluidStack()) > 0) {
                        int fluidAmount = 200 * (int)FluidStack.bucketAmount() / SmeltingBlockEntity.getFluidBurnTime(be.fluidTank.getFluidStack());
                        if (be.fluidTank.getFluidStack().getAmount() >= (long)fluidAmount) {
                            be.recipesUsed = be.furnaceBurnTime = be.getEnderMultiplier() * get_cook_time;
                            be.fluidTank.drain((long)fluidAmount, false);
                        }
                    } else if (be.isEnergy()) {
                        be.recipesUsed = be.furnaceBurnTime = be.getEnderMultiplier() * get_cook_time;
                        for (int a : be.INPUTS()) {
                            be.energyStorage.consumeEnergy(be.EnergyUse() * be.OreProcessingMultiplier(be.inventory.m_8020_(a)), false);
                        }
                    } else {
                        be.recipesUsed = be.furnaceBurnTime = (int)Math.ceil((double)(be.getEnderMultiplier() * SmeltingBlockEntity.getBurnTime(fuel)) * ((double)get_cook_time / 200.0));
                    }
                    if (be.isBurning()) {
                        flag1 = true;
                        if (be.hasEnder() && be.hasUpgrade((UpgradeItem)((Object)ModObjects.FUEL.get()))) {
                            be.breakDurabilityItem(be.getUpgradeSlotItem((Item)ModObjects.FUEL.get()));
                        }
                        if (!(be.isLiquid() && be.fluidTank.getFluidStack().getAmount() >= 10L || be.isEnergy())) {
                            if (ItemContainerUtil.isFluidContainer((ItemStack)fuel)) {
                                ItemContainerUtil.ItemFluidContext context2 = ItemContainerUtil.drainItem((long)be.fluidTank.getTotalSpace(), (ItemStack)fuel);
                                be.inventory.m_6836_(be.FUEL()[0], context2.container());
                            }
                            if (!fuel.m_41619_() && SmeltingBlockEntity.isItemFuel(fuel)) {
                                fuel.m_41774_(1);
                                if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.FUEL.get()))) {
                                    be.breakDurabilityItem(be.getUpgradeSlotItem((Item)ModObjects.FUEL.get()));
                                }
                            }
                        }
                    }
                }
                if (be.isBurning() && valid) {
                    ++be.cookTime;
                    if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                        ItemContainerUtil.ItemFluidContext context3 = ItemContainerUtil.drainItem((long)(FluidStack.bucketAmount() / 1000L), (ItemStack)be.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get()));
                        if (!context3.fluidStack().isEmpty()) {
                            be.inventory.m_6836_(be.getUpgradeTypeSlot((UpgradeItem)((Object)ModObjects.GENERATOR.get())), context3.container());
                        }
                        be.energyStorage.receiveEnergy(Math.round(500.0f / (float)get_cook_time), false);
                    }
                    if (be.cookTime >= be.totalCookTime) {
                        be.cookTime = 0;
                        be.totalCookTime = be.getCookTime();
                        if (!be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                            be.trySmelt();
                            if (be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
                                be.handleAutoIO();
                            }
                        }
                        flag1 = true;
                    }
                } else {
                    be.cookTime = 0;
                }
            } else if (!be.isBurning() && be.cookTime > 0) {
                be.cookTime = Mth.m_14045_((int)(be.cookTime - 2), (int)0, (int)be.totalCookTime);
            }
            if (wasBurning != be.isBurning()) {
                flag1 = true;
                be.f_58857_.m_7731_(be.f_58858_, (BlockState)be.f_58857_.m_8055_(be.f_58858_).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(be.isBurning())), 3);
            }
            if (be.timer % 24 == 0 && be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get())) && be.cookTime <= 0) {
                if (be.arraySlotFilled(be.INPUTS(), false)) {
                    be.handleAutoIO();
                    flag1 = true;
                } else if (be.hasArraySlotSpace(be.INPUTS())) {
                    be.handleAutoIO();
                    flag1 = true;
                }
                if (be.arraySlotFilled(be.OUTPUTS(), true)) {
                    be.handleAutoIO();
                    flag1 = true;
                }
                if (be.inventory.m_8020_(be.FUEL()[0]).m_41619_() && !be.isLiquid() && !be.isEnergy()) {
                    be.handleAutoIO();
                    flag1 = true;
                } else if (be.inventory.m_8020_(be.FUEL()[0]).m_41613_() < be.inventory.m_8020_(be.FUEL()[0]).m_41741_() || ItemContainerUtil.isFluidContainer((ItemStack)fuel) && ItemContainerUtil.getFluid((ItemStack)fuel).getAmount() < be.fluidTank.getTotalSpace()) {
                    be.handleAutoIO();
                    flag1 = true;
                }
            }
        }
        if (flag1) {
            be.m_6596_();
        }
    }

    public Color getColor() {
        if (this.getUpgradeSlotItem((Item)ModObjects.COLOR.get()).m_41619_()) {
            return Color.WHITE;
        }
        CompoundTag nbt = this.getUpgradeSlotItem((Item)ModObjects.COLOR.get()).m_41783_();
        return new Color(nbt.m_128451_("red"), nbt.m_128451_("green"), nbt.m_128451_("blue"));
    }

    public int getSettingBottom() {
        return this.furnaceSettings.get(this.getIndexBottom());
    }

    public int getSettingTop() {
        return this.furnaceSettings.get(this.getIndexTop());
    }

    public int getSettingFront() {
        return this.furnaceSettings.get(this.getIndexFront());
    }

    public int getSettingBack() {
        return this.furnaceSettings.get(this.getIndexBack());
    }

    public int getSettingLeft() {
        return this.furnaceSettings.get(this.getIndexLeft());
    }

    public int getSettingRight() {
        return this.furnaceSettings.get(this.getIndexRight());
    }

    protected BlockSide[] getSidesOrder() {
        return BlockSide.values();
    }

    public int getIndexBottom() {
        return BlockSide.BOTTOM.blockStateToFacing(this.m_58900_(), this.getSidesOrder()).ordinal();
    }

    public int getIndexTop() {
        return BlockSide.TOP.blockStateToFacing(this.m_58900_(), this.getSidesOrder()).ordinal();
    }

    public int getIndexFront() {
        return BlockSide.FRONT.blockStateToFacing(this.m_58900_(), this.getSidesOrder()).ordinal();
    }

    public int getIndexBack() {
        return BlockSide.BACK.blockStateToFacing(this.m_58900_(), this.getSidesOrder()).ordinal();
    }

    public int getIndexLeft() {
        return BlockSide.LEFT.blockStateToFacing(this.m_58900_(), this.getSidesOrder()).ordinal();
    }

    public int getIndexRight() {
        return BlockSide.RIGHT.blockStateToFacing(this.m_58900_(), this.getSidesOrder()).ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.get(6);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.get(7);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.get(8);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.get(9);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private TagKey<Item> getItemTag(ResourceLocation resourceLocation) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
    }

    private boolean hasRawOreTag(ItemStack stack) {
        if (Config.checkRawOresName.get().booleanValue()) {
            return stack.m_41720_().arch$registryName().m_135815_().startsWith("raw_");
        }
        if (Platform.isForge()) {
            return stack.m_204117_(this.getItemTag(new ResourceLocation("forge", "raw_materials")));
        }
        if (stack.m_204117_(this.getItemTag(new ResourceLocation("c", "raw_materials")))) {
            return true;
        }
        for (TagKey tag : stack.m_204131_().toList()) {
            if (!tag.f_203868_().toString().contains("raw_") || !tag.f_203868_().toString().contains("_ores")) continue;
            return true;
        }
        return false;
    }

    protected boolean isOre(ItemStack input) {
        if (Config.checkCommonOresName.get().booleanValue()) {
            return input.m_41720_().arch$registryName().m_135815_().endsWith("_ore");
        }
        return input.m_204117_(this.ore);
    }

    protected boolean isRaw(ItemStack input) {
        return this.hasRawOreTag(input);
    }

    protected int OreProcessingMultiplier(ItemStack input) {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.ORE_PROCESSING.get()))) {
            OreProcessingUpgradeItem oreup = (OreProcessingUpgradeItem)this.getUpgradeTypeSlotItem((UpgradeItem)((Object)ModObjects.ORE_PROCESSING.get())).m_41720_();
            if (this.isRaw(input) && oreup.acceptRaw || this.isOre(input) && oreup.acceptOre) {
                return oreup.getMultiplier;
            }
        } else if (input.m_41619_()) {
            return 0;
        }
        return 1;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new SmeltingMenu((MenuType)ModObjects.FURNACE_CONTAINER.get(), i, this.f_58857_, this.m_58899_(), playerInventory, playerEntity, this.fields);
    }

    protected boolean canSmelt(@Nullable Recipe<?> recipe, int INPUT, int OUTPUT) {
        ItemStack recipeOutput;
        ItemStack input = this.getInv().m_8020_(INPUT);
        if (OUTPUT >= 0 && !input.m_41619_() && recipe != null && !(recipeOutput = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_)).m_41619_()) {
            ItemStack output = this.getInv().m_8020_(OUTPUT);
            if (output.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.m_41613_() + recipeOutput.m_41613_() * this.OreProcessingMultiplier(input) <= output.m_41741_();
        }
        return false;
    }

    private ItemStack getResult(@Nullable Recipe<?> recipe, ItemStack input) {
        ItemStack out = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41777_();
        out.m_41764_(out.m_41613_() * this.OreProcessingMultiplier(input));
        return out;
    }

    protected int addOrSetItem(ItemStack stack, Container inv, int index) {
        ItemStack slotStack = inv.m_8020_(index);
        if (slotStack.m_41619_()) {
            inv.m_6836_(index, stack.m_41777_());
            return Math.min(inv.m_6893_(), stack.m_41613_());
        }
        int resultCount = slotStack.m_41613_() + stack.m_41613_();
        int maxStack = Math.min(inv.m_6893_(), slotStack.m_41741_());
        if (slotStack.m_150930_(stack.m_41720_()) && slotStack.m_41613_() < maxStack) {
            if (resultCount <= maxStack) {
                slotStack.m_41769_(Math.max(stack.m_41613_(), 1));
                return Math.max(stack.m_41613_(), 1);
            }
            int count = maxStack - slotStack.m_41613_();
            slotStack.m_41764_(maxStack);
            return count;
        }
        return 0;
    }

    protected void smeltItem(@Nullable Recipe<?> recipe, int INPUT, int OUTPUT) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe, INPUT, OUTPUT)) {
            ItemStack input = this.getInv().m_8020_(INPUT);
            if (this.addOrSetItem(this.getResult(recipe, input), (Container)this.inventory, OUTPUT) > 0 && this.hasUpgrade((UpgradeItem)((Object)ModObjects.ORE_PROCESSING.get())) && this.isOre(input)) {
                this.breakDurabilityItem(this.getUpgradeSlotItem((Item)ModObjects.ORE_PROCESSING.get()));
            }
            this.checkXP(recipe);
            if (!this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            ItemStack fuel = this.inventory.m_8020_(this.FUEL()[0]);
            if (input.m_41720_() == Blocks.f_50057_.m_5456_() && !fuel.m_41619_() && ItemContainerUtil.isFluidContainer((ItemStack)fuel)) {
                ItemContainerUtil.fillItem((ItemStack)fuel, (FluidStack)FluidStack.create((Fluid)Fluids.f_76193_, (long)1000L));
                this.inventory.m_6836_(this.FUEL()[0], fuel);
            }
            if (Platform.isModLoaded((String)"pmmo")) {
                ProjectMMO.burnEvent(input, this.f_58857_, this.f_58858_);
            }
            input.m_41774_(1);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.furnaceBurnTime = tag.m_128451_("BurnTime");
        this.cookTime = tag.m_128451_("CookTime");
        this.totalCookTime = tag.m_128451_("CookTimeTotal");
        this.timer = 0;
        this.recipesUsed = SmeltingBlockEntity.getBurnTime(this.getInv().m_8020_(1));
        this.fluidTank.deserializeTag((Tag)tag.m_128469_("fluidTank"));
        this.xpTank.deserializeTag((Tag)tag.m_128469_("xpTank"));
        CompoundTag compoundnbt = tag.m_128469_("RecipesUsed");
        this.energyStorage.deserializeTag((Tag)tag.m_128469_("energy"));
        for (String s : compoundnbt.m_128431_()) {
            this.recipes.put((Object)new ResourceLocation(s), compoundnbt.m_128451_(s));
        }
        this.showInventorySettings = tag.m_128451_("ShowInvSettings");
        this.showOrientation = tag.m_128471_("ShowOrientation");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("BurnTime", this.furnaceBurnTime);
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("CookTimeTotal", this.totalCookTime);
        tag.m_128365_("fluidTank", this.fluidTank.serializeTag());
        tag.m_128365_("xpTank", this.xpTank.serializeTag());
        tag.m_128365_("energy", this.energyStorage.serializeTag());
        tag.m_128405_("ShowInvSettings", this.showInventorySettings);
        tag.m_128379_("ShowOrientation", this.showOrientation);
        CompoundTag compoundnbt = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)compoundnbt);
        super.m_183515_(tag);
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        return FuelRegistry.get((ItemStack)stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return SmeltingBlockEntity.getBurnTime(stack) > 0;
    }

    public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(Storages.Storage<T> storage, Direction facing) {
        if (storage == Storages.FLUID) {
            if (facing == null || !this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) && !this.hasXPTank() || facing.ordinal() == this.getIndexTop() || facing.ordinal() == this.getIndexBottom()) {
                if (this.isLiquid()) {
                    return () -> facing == null ? this.fluidTank : FactoryAPIPlatform.filteredOf((IPlatformFluidHandler)this.fluidTank, (Direction)Direction.NORTH, (TransportState)TransportState.INSERT);
                }
            } else {
                if (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                    ItemStack gen = this.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
                    return () -> {
                        IPlatformFluidHandler iPlatformFluidHandler;
                        Item patt38183$temp = gen.m_41720_();
                        if (patt38183$temp instanceof GeneratorUpgradeItem) {
                            GeneratorUpgradeItem item = (GeneratorUpgradeItem)patt38183$temp;
                            iPlatformFluidHandler = facing == null ? item.getFluidStorage(gen) : FactoryAPIPlatform.filteredOf((IPlatformFluidHandler)item.getFluidStorage(gen), (Direction)Direction.NORTH, (TransportState)TransportState.INSERT);
                        } else {
                            iPlatformFluidHandler = null;
                        }
                        return iPlatformFluidHandler;
                    };
                }
                if (this.hasXPTank()) {
                    return () -> facing == null ? this.xpTank : FactoryAPIPlatform.filteredOf((IPlatformFluidHandler)this.xpTank, (Direction)Direction.NORTH, (TransportState)TransportState.EXTRACT);
                }
            }
        }
        if (storage == Storages.ITEM) {
            return () -> facing == null ? this.inventory : FactoryAPIPlatform.filteredOf((IPlatformItemHandler)this.inventory, (Direction)facing, (int[])((int[])this.getSlotsTransport(facing).key()), (TransportState)((TransportState)this.getSlotsTransport(facing).value()));
        }
        if (storage == Storages.ENERGY && (this.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) || this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())))) {
            return () -> facing == null ? this.energyStorage : FactoryAPIPlatform.filteredOf((IPlatformEnergyStorage)this.energyStorage, (Direction)Direction.NORTH, (TransportState)TransportState.ofBoolean((boolean)true, (!this.hasUpgrade((UpgradeItem)((Object)((Object)ModObjects.GENERATOR.get()))) ? 1 : 0) != 0));
        }
        return ArbitrarySupplier.empty();
    }

    @Override
    public Pair<int[], TransportState> getSlotsTransport(Direction side) {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
            if (this.furnaceSettings.get(side.ordinal()) == 1) {
                return Pair.of((Object)this.ISLOTS(), (Object)TransportState.INSERT);
            }
            if (this.furnaceSettings.get(side.ordinal()) == 2) {
                return Pair.of((Object)this.OUTPUTS(), (Object)TransportState.EXTRACT_INSERT);
            }
            if (this.furnaceSettings.get(side.ordinal()) == 3) {
                return Pair.of((Object)this.FSLOTS(), (Object)TransportState.EXTRACT_INSERT);
            }
            if (this.furnaceSettings.get(side.ordinal()) == 4) {
                return Pair.of((Object)new int[]{this.FUEL()[0]}, (Object)TransportState.EXTRACT_INSERT);
            }
        } else {
            if (side == Direction.UP) {
                return Pair.of((Object)this.INPUTS(), (Object)TransportState.INSERT);
            }
            if (side == Direction.DOWN) {
                return Pair.of((Object)this.OUTPUTS(), (Object)TransportState.EXTRACT);
            }
            return Pair.of((Object)new int[]{this.FUEL()[0]}, (Object)TransportState.EXTRACT_INSERT);
        }
        return Pair.of((Object)new int[0], (Object)TransportState.NONE);
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack) {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
            return !ArrayUtils.contains((int[])this.INPUTS(), (int)index) && !ArrayUtils.contains((int[])this.UPGRADES(), (int)index) && (!ArrayUtils.contains((int[])this.FUEL(), (int)index) || !SmeltingBlockEntity.isItemFuel(stack) && (!ItemContainerUtil.isEnergyContainer((ItemStack)stack) || ItemContainerUtil.getEnergy((ItemStack)stack) <= 0));
        }
        return ArrayUtils.contains((int[])this.OUTPUTS(), (int)index);
    }

    @Override
    public void addSlots(NonNullList<FactoryItemSlot> slots, @Nullable Player player) {
        slots.add((Object)new SlotInput(this, 0, 54, 18, s -> !this.hasUpgrade((UpgradeItem)((Object)((Object)ModObjects.GENERATOR.get())))));
        slots.add((Object)new SlotFuel(this, 1, 54, 54));
        slots.add((Object)new SlotOutput(player, this, 2, 116, 35, s -> !this.hasUpgrade((UpgradeItem)((Object)((Object)ModObjects.GENERATOR.get())))));
        slots.add((Object)new SlotUpgrade(this, 3, 8, 18));
        slots.add((Object)new SlotUpgrade(this, 4, 8, 36));
        slots.add((Object)new SlotUpgrade(this, 5, 8, 54));
        slots.add((Object)new SlotInput(this, 6, 36, 18, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)ModObjects.STORAGE.get())))));
        slots.add((Object)new SlotFuel(this, 7, 36, 54, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)ModObjects.STORAGE.get())))));
        slots.add((Object)new SlotOutput(player, this, 8, 138, 35, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)ModObjects.STORAGE.get())))));
    }

    public void checkXP(@Nullable Recipe<?> recipe) {
        if (!this.f_58857_.f_46443_) {
            boolean flag2 = false;
            if (this.recipes.size() > Config.furnaceXPDropValue.get()) {
                this.grantStoredRecipeExperience(this.f_58857_, new Vec3((double)(this.f_58858_.m_123341_() + this.rand.nextInt(2) - 1), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() + this.rand.nextInt(2) - 1)));
                this.recipes.clear();
            } else {
                for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                    if (!this.f_58857_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).isPresent() || entry.getIntValue() <= Config.furnaceXPDropValue2.get()) continue;
                    if (!flag2) {
                        this.grantStoredRecipeExperience(this.f_58857_, new Vec3((double)(this.f_58858_.m_123341_() + this.rand.nextInt(2) - 1), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() + this.rand.nextInt(2) - 1)));
                    }
                    flag2 = true;
                }
                if (flag2) {
                    this.recipes.clear();
                }
            }
        }
    }

    public void m_6029_(Recipe<?> recipeHolder) {
        ResourceLocation resourcelocation = recipeHolder.m_6423_();
        this.recipes.addTo((Object)resourcelocation, 1);
    }

    public Recipe<?> m_7928_() {
        return null;
    }

    public void unlockRecipes(Player player) {
        List<Recipe<?>> list = this.grantStoredRecipeExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(list);
        this.recipes.clear();
    }

    public List<Recipe<?>> grantStoredRecipeExperience(Level level, Vec3 worldPosition) {
        ArrayList list = Lists.newArrayList();
        this.recipes.object2IntEntrySet().fastForEach(entry -> level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(h -> {
            list.add(h);
            if (this.hasXPTank()) {
                int amountLiquidXp = Mth.m_14143_((float)((float)entry.getIntValue() * ((AbstractCookingRecipe)h).m_43750_())) * 5;
                if (amountLiquidXp >= 1) {
                    this.xpTank.fill(FluidStack.create((Fluid)Config.getLiquidXP(), (long)((long)amountLiquidXp * FluidStack.bucketAmount() / 1000L)), false);
                    this.recipes.clear();
                }
            } else if (worldPosition != null) {
                SmeltingBlockEntity.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), ((AbstractCookingRecipe)h).m_43750_());
            }
        }));
        return list;
    }

    public void handleAutoIO() {
        for (Direction dir : Direction.values()) {
            IPlatformItemHandler other;
            BlockEntity tile = this.m_58904_().m_7702_(this.m_58899_().m_121955_(dir.m_122436_()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 && this.furnaceSettings.get(dir.ordinal()) != 4 || (other = (IPlatformItemHandler)FactoryAPIPlatform.getPlatformFactoryStorage((BlockEntity)tile).getStorage(Storages.ITEM, dir.m_122424_()).get()) == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1) {
                ItemStack stack;
                int i;
                for (int INPUT : this.INPUTS()) {
                    if (this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 3 || this.inventory.m_8020_(INPUT).m_41613_() >= this.inventory.m_8020_(INPUT).m_41741_()) continue;
                    for (i = 0; i < other.m_6643_(); ++i) {
                        if (other.m_8020_(i).m_41619_() || (!this.hasRecipe(stack = other.extractItem(i, other.m_8020_(i).m_41741_(), true)) || !this.inventory.m_8020_(INPUT).m_41619_()) && !ItemStack.m_150942_((ItemStack)this.inventory.m_8020_(INPUT), (ItemStack)stack)) continue;
                        this.inventory.insertItem(INPUT, other.extractItem(i, other.m_8020_(i).m_41741_() - this.inventory.m_8020_(INPUT).m_41613_(), false), false);
                    }
                }
                for (int FUEL : this.FUEL()) {
                    if (this.furnaceSettings.get(dir.ordinal()) != 4 || this.inventory.m_8020_(FUEL).m_41613_() >= this.inventory.m_8020_(FUEL).m_41741_()) continue;
                    for (i = 0; i < other.m_6643_(); ++i) {
                        if (!SmeltingBlockEntity.isItemFuel(other.m_8020_(i)) || other.m_8020_(i).m_41619_() || (!SmeltingBlockEntity.isItemFuel(stack = other.extractItem(i, other.m_8020_(i).m_41741_(), true)) || !this.inventory.m_8020_(FUEL).m_41619_()) && !ItemStack.m_150942_((ItemStack)this.inventory.m_8020_(FUEL), (ItemStack)stack)) continue;
                        this.inventory.insertItem(FUEL, other.extractItem(i, other.m_8020_(i).m_41741_() - this.inventory.m_8020_(FUEL).m_41613_(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1) continue;
            for (int FUEL : this.FUEL()) {
                ItemStack fuel;
                if (this.furnaceSettings.get(dir.ordinal()) != 4 || this.inventory.m_8020_(FUEL).m_41619_() || SmeltingBlockEntity.isItemFuel(fuel = this.inventory.m_8020_(FUEL))) continue;
                for (int i = 0; i < other.m_6643_(); ++i) {
                    ItemStack stack = this.inventory.extractItem(FUEL, this.inventory.m_8020_(FUEL).m_41741_() - other.m_8020_(i).m_41613_(), true);
                    if (!other.m_7013_(i, stack) || !other.m_8020_(i).m_41619_() && (!other.m_7013_(i, stack) || !ItemStack.m_150942_((ItemStack)other.m_8020_(i), (ItemStack)stack) || other.m_8020_(i).m_41613_() + stack.m_41613_() > other.m_6893_())) continue;
                    this.inventory.m_6836_(FUEL, other.insertItem(i, stack, false));
                }
            }
            for (int output : this.OUTPUTS()) {
                if (this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || this.inventory.m_8020_(output).m_41619_() || BuiltInRegistries.f_256975_.m_7981_((Object)tile.m_58900_().m_60734_()).toString().contains("storagedrawers:")) continue;
                for (int i = 0; i < other.m_6643_(); ++i) {
                    ItemStack stack = this.inventory.extractItem(output, this.inventory.m_8020_(output).m_41741_() - other.m_8020_(i).m_41613_(), true);
                    if (!other.m_7013_(i, stack) || !other.m_8020_(i).m_41619_() && (!other.m_7013_(i, stack) || !ItemStack.m_150942_((ItemStack)other.m_8020_(i), (ItemStack)stack) || other.m_8020_(i).m_41613_() + stack.m_41613_() > other.m_6893_())) continue;
                    this.inventory.m_6836_(output, other.insertItem(i, stack, false));
                }
            }
        }
    }

    private static void splitAndSpawnExperience(Level level, Vec3 worldPosition, int craftedAmount, float experience) {
        int i = Mth.m_14143_((float)((float)craftedAmount * experience));
        float f = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            level.m_7967_((Entity)new ExperienceOrb(level, worldPosition.f_82479_, worldPosition.f_82480_, worldPosition.f_82481_, j));
        }
    }

    public void m_5809_(StackedContents helper) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            helper.m_36491_(this.inventory.m_8020_(i));
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
    }
}

