/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.IInventoryBlockEntity;
import wily.betterfurnaces.network.Messages;
import wily.betterfurnaces.network.PacketSyncAdditionalInt;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.FactoryItemHandler;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;

public abstract class InventoryBlockEntity
extends BlockEntity
implements IInventoryBlockEntity,
ExtendedMenuProvider,
Nameable,
IFactoryStorage {
    protected Component name;
    public FactoryItemHandler inventory;
    public List<Bearer<Integer>> additionalSyncInts = new ArrayList<Bearer<Integer>>();

    public InventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.inventory = new FactoryItemHandler(this.getInventorySize(), this, TransportState.EXTRACT_INSERT){

            public boolean m_271862_(Container container, int i, ItemStack itemStack) {
                return super.m_271862_(container, i, itemStack) && InventoryBlockEntity.this.IcanExtractItem(i, itemStack);
            }
        };
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        this.m_6596_();
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
        this.m_6596_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.m_142466_(tag);
        this.m_6596_();
        this.f_58857_.m_6933_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), 2, 3);
    }

    public void updateBlockState() {
        this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this.m_58900_(), 2);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.m_130064_(this.m_58899_());
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.m_5446_();
    }

    public void breakDurabilityItem(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41763_()) {
            stack.m_220157_(1, this.f_58857_.f_46441_, null);
            if (stack.m_41773_() >= stack.m_41776_()) {
                stack.m_41774_(1);
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void syncAdditionalMenuData(AbstractContainerMenu menu, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.additionalSyncInts.forEach(i -> Messages.INSTANCE.sendToPlayer(sp, (Object)new PacketSyncAdditionalInt(this.m_58899_(), this.additionalSyncInts, (Bearer<Integer>)i, (Integer)i.get())));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!this.additionalSyncInts.isEmpty()) {
            int[] ints = tag.m_128465_("additionalInts");
            for (int i = 0; i < ints.length; ++i) {
                this.additionalSyncInts.get(i).set((Object)ints[i]);
            }
        }
        this.inventory.deserializeTag(tag.m_128469_("inventory"));
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.additionalSyncInts.isEmpty()) {
            tag.m_128408_("additionalInts", this.additionalSyncInts.stream().map(Bearer::get).toList());
        }
        tag.m_128365_("inventory", (Tag)this.inventory.serializeTag());
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public boolean m_8077_() {
        return this.name != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    @NotNull
    public IPlatformItemHandler getInv() {
        return this.inventory;
    }

    @Override
    public abstract boolean IcanExtractItem(int var1, ItemStack var2);
}

