/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class FactoryUpgradeSettings {
    public static String Settings = "Settings";
    public static String AutoIO = "AutoIO";
    public static String Redstone = "Redstone";
    public Supplier<ItemStack> factory;

    public FactoryUpgradeSettings(Supplier<ItemStack> stack) {
        this.factory = stack;
        if (!FactoryUpgradeSettings.containsAnyTag(this.factory.get())) {
            CompoundTag tag = this.factory.get().m_41784_();
            tag.m_128385_(Settings, new int[]{0, 0, 0, 0, 0, 0});
            tag.m_128385_(AutoIO, new int[]{0, 0});
            tag.m_128385_(Redstone, new int[]{0, 0});
            this.placeDefaultConfig();
            stack.get().m_41751_(tag);
        }
    }

    public static boolean containsAnyTag(ItemStack factory) {
        CompoundTag tag = factory.m_41784_();
        return tag.m_128441_(Settings) && tag.m_128441_(AutoIO) && tag.m_128441_(Redstone);
    }

    public int get(int index) {
        if (this.factory.get().m_41619_() || !FactoryUpgradeSettings.containsAnyTag(this.factory.get())) {
            return 0;
        }
        int[] all = ArrayUtils.addAll((int[])this.getFurnaceSetting(Settings), (int[])ArrayUtils.addAll((int[])this.getFurnaceSetting(AutoIO), (int[])this.getFurnaceSetting(Redstone)));
        return all[index];
    }

    public <T> T byIndex(int index, T settings, T autoio, T redstone) {
        return index < 6 ? settings : (index < 8 ? autoio : redstone);
    }

    public void set(int index, int value) {
        if (this.factory.get().m_41619_()) {
            return;
        }
        String actualSettings = this.byIndex(index, Settings, AutoIO, Redstone);
        int actualIndex = this.byIndex(index, index, index - 6, index - 8);
        int[] settings = this.getFurnaceSetting(actualSettings);
        settings[actualIndex] = value;
        this.setFurnaceSetting(actualSettings, settings);
        this.onChanged();
    }

    public int size() {
        if (this.factory.get().m_41619_()) {
            return 0;
        }
        return this.getFurnaceSetting(Settings).length + this.getFurnaceSetting(AutoIO).length + this.getFurnaceSetting(Redstone).length;
    }

    public int[] getFurnaceSetting(String setting) {
        return this.factory.get().m_41784_().m_128465_(setting);
    }

    public void setFurnaceSetting(String setting, int[] settings) {
        this.factory.get().m_41784_().m_128385_(setting, settings);
    }

    public void onChanged() {
    }

    public void placeDefaultConfig() {
        for (Direction dir : Direction.values()) {
            this.set(dir.ordinal(), 4);
        }
        this.set(0, 2);
        this.set(1, 1);
    }
}

