/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import dev.architectury.fluid.FluidStack;
import it.unimi.dsi.fastutil.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blocks.CobblestoneGeneratorBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.CobblestoneGeneratorMenu;
import wily.betterfurnaces.inventory.SlotOutput;
import wily.betterfurnaces.inventory.SlotUpgrade;
import wily.betterfurnaces.items.FuelEfficiencyUpgradeItem;
import wily.betterfurnaces.items.OreProcessingUpgradeItem;
import wily.betterfurnaces.recipes.CobblestoneGeneratorRecipes;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportState;

public class CobblestoneGeneratorBlockEntity
extends InventoryBlockEntity {
    public static List<CobblestoneGeneratorRecipes> recipes;
    protected CobblestoneGeneratorRecipes recipe;
    public static Predicate<ItemStack> HAS_LAVA;
    public static Predicate<ItemStack> HAS_WATER;
    public final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return CobblestoneGeneratorBlockEntity.this.cobTime;
            }
            if (index == 1) {
                return CobblestoneGeneratorBlockEntity.this.resultType;
            }
            if (index == 2) {
                return CobblestoneGeneratorBlockEntity.this.actualCobTime;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                CobblestoneGeneratorBlockEntity.this.cobTime = value;
            }
            if (index == 1) {
                CobblestoneGeneratorBlockEntity.this.resultType = value;
            }
            if (index == 2) {
                CobblestoneGeneratorBlockEntity.this.actualCobTime = value;
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    public static final int INPUT = 0;
    public static final int INPUT1 = 1;
    public static final int OUTPUT = 2;
    public static final int UPGRADE = 3;
    public static final int UPGRADE1 = 4;
    private int cobTime;
    private int actualCobTime = this.getCobTime();
    public int resultType = 0;
    public Bearer<Integer> autoOutput = Bearer.of((Object)1);

    @Override
    public Pair<int[], TransportState> getSlotsTransport(Direction side) {
        return Pair.of((Object)new int[0], (Object)TransportState.EXTRACT);
    }

    public static boolean hasFluidAsBucket(ItemStack stack, Fluid fluid) {
        return ItemContainerUtil.isFluidContainer((ItemStack)stack) && ItemContainerUtil.getFluid((ItemStack)stack).isFluidEqual(FluidStack.create((Fluid)fluid, (long)FluidStack.bucketAmount()));
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack) {
        return index == 2;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new CobblestoneGeneratorMenu(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity, this.fields);
    }

    public CobblestoneGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.COB_GENERATOR_TILE.get(), pos, state);
        this.additionalSyncInts.add(this.autoOutput);
    }

    @Override
    public void syncAdditionalMenuData(AbstractContainerMenu menu, Player player) {
        super.syncAdditionalMenuData(menu, player);
    }

    public boolean hasAutoOutput() {
        return (Integer)this.autoOutput.get() == 1;
    }

    public void forceUpdateAllStates() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (((Integer)state.m_61143_((Property)CobblestoneGeneratorBlock.TYPE)).intValue() != this.cobGen()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)CobblestoneGeneratorBlock.TYPE, (Comparable)Integer.valueOf(this.cobGen())), 3);
        }
    }

    protected List<CobblestoneGeneratorRecipes> getSortedCobRecipes() {
        return Objects.requireNonNull(this.m_58904_()).m_7465_().m_44013_((RecipeType)ModObjects.ROCK_GENERATING_RECIPE.get()).stream().sorted(Comparator.comparing(o -> o.m_6423_().m_135815_())).toList();
    }

    public void initRecipes() {
        recipes = this.getSortedCobRecipes();
    }

    public void setRecipe(int index) {
        if (this.f_58857_ != null) {
            this.recipe = (CobblestoneGeneratorRecipes)Objects.requireNonNullElseGet(recipes, this::getSortedCobRecipes).get(index);
        }
    }

    public void changeRecipe(boolean next) {
        if (recipes != null) {
            int newIndex = this.resultType + (next ? 1 : -1);
            if (newIndex > recipes.size() - 1) {
                newIndex = 0;
            }
            if (newIndex < 0) {
                newIndex = recipes.size() - 1;
            }
            this.setRecipe(newIndex);
            this.resultType = newIndex;
            this.updateBlockState();
        }
    }

    public void tick(BlockState state) {
        boolean can3;
        if (this.actualCobTime != this.getCobTime()) {
            this.actualCobTime = this.getCobTime();
        }
        if (this.cobTime > this.getCobTime()) {
            this.cobTime = this.getCobTime();
        }
        if (recipes == null) {
            this.initRecipes();
        }
        if (this.recipe == null && recipes != null || this.f_58857_.f_46443_ && recipes.indexOf(this.recipe) != this.resultType) {
            this.setRecipe(this.resultType);
            this.updateBlockState();
        }
        if (!this.m_58904_().f_46443_) {
            this.forceUpdateAllStates();
        }
        ItemStack output = this.inventory.m_8020_(2);
        ItemStack upgrade = this.inventory.m_8020_(3);
        ItemStack upgrade1 = this.inventory.m_8020_(4);
        boolean active = true;
        for (Direction side : Direction.values()) {
            if (this.f_58857_.m_277185_(this.f_58858_.m_121955_(side.m_122436_()), side) <= 0) continue;
            active = false;
        }
        boolean can = output.m_41613_() + 1 <= output.m_41741_();
        boolean can1 = output.m_41619_();
        boolean bl = can3 = output.m_41720_() == this.getResult().m_41720_();
        if ((this.cobGen() == 3 || this.cobTime > 0 && this.cobTime < this.actualCobTime) && active && (can && can3 || can1)) {
            ++this.cobTime;
        }
        if (this.cobTime >= this.getCobTime() && (can && can3 || can1)) {
            if (!this.f_58857_.f_46443_) {
                if (can1) {
                    this.getInv().m_6836_(2, this.getResult());
                } else {
                    output.m_41769_(this.getResult().m_41613_());
                }
                if (upgrade1.m_41720_() == ModObjects.ORE_PROCESSING.get()) {
                    this.breakDurabilityItem(upgrade1);
                }
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.3f);
                if (upgrade.m_41720_() == ModObjects.FUEL.get()) {
                    this.breakDurabilityItem(upgrade);
                }
            }
            this.cobTime = 0;
            RandomSource rand = this.f_58857_.f_46441_;
            double d0 = (double)this.f_58858_.m_123341_() + 0.5;
            double d1 = (double)this.f_58858_.m_123342_() + 0.5;
            double d2 = (double)this.f_58858_.m_123343_() + 0.5;
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction.Axis direction$axis = direction.m_122434_();
            double d4 = rand.m_188500_() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = rand.m_188500_() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            for (int i = 0; i < 6; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
        if (!output.m_41619_() && !this.f_58857_.f_46443_ && this.hasAutoOutput()) {
            CobblestoneGeneratorBlockEntity.handleAutoOutput(this, 2);
        }
    }

    protected int cobGen() {
        ItemStack input = this.getInv().m_8020_(0);
        ItemStack input1 = this.getInv().m_8020_(1);
        if (HAS_LAVA.test(input) && input1.m_41619_()) {
            return 1;
        }
        if (HAS_WATER.test(input1) && input.m_41619_()) {
            return 2;
        }
        if (HAS_LAVA.test(input) && HAS_WATER.test(input1)) {
            return 3;
        }
        return 0;
    }

    protected int FuelEfficiencyMultiplier() {
        ItemStack upgrade = this.inventory.m_8020_(3);
        if (!upgrade.m_41619_() && upgrade.m_41720_() instanceof FuelEfficiencyUpgradeItem) {
            return 2;
        }
        return 1;
    }

    protected int getCobTime() {
        if (this.recipe != null) {
            return this.recipe.duration / this.FuelEfficiencyMultiplier();
        }
        return -1;
    }

    public ItemStack getResult() {
        ItemStack result = this.recipe != null ? new ItemStack((ItemLike)this.recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()) : new ItemStack((ItemLike)Items.f_42594_);
        result.m_41764_(this.getResultCount());
        return result;
    }

    protected int getResultCount() {
        ItemStack upgrade1 = this.inventory.m_8020_(4);
        if (upgrade1.m_41720_() instanceof OreProcessingUpgradeItem) {
            return 2;
        }
        return 1;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cobTime = tag.m_128451_("CobTime");
        this.resultType = tag.m_128451_("ResultType");
        this.actualCobTime = tag.m_128451_("ActualCobTime");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("CobTime", this.cobTime);
        tag.m_128405_("ResultType", this.resultType);
        tag.m_128405_("ActualCobTime", this.actualCobTime);
        super.m_183515_(tag);
    }

    public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(Storages.Storage<T> storage, Direction facing) {
        if (!this.m_58901_() && storage == Storages.ITEM) {
            return () -> this.inventory;
        }
        return ArbitrarySupplier.empty();
    }

    @Override
    public void addSlots(NonNullList<FactoryItemSlot> slots, @Nullable Player player) {
        slots.add((Object)new FactoryItemSlot(this, SlotsIdentifier.LAVA, TransportState.INSERT, 0, 53, 27){

            public boolean m_5857_(ItemStack stack) {
                return HAS_LAVA.test(stack);
            }
        });
        slots.add((Object)new FactoryItemSlot(this, SlotsIdentifier.WATER, TransportState.INSERT, 1, 108, 27){

            public boolean m_5857_(ItemStack stack) {
                return HAS_WATER.test(stack);
            }
        });
        slots.add((Object)new SlotOutput(player, this, 2, 80, 45));
        slots.add((Object)new SlotUpgrade(this, 3, 8, 18){

            @Override
            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof FuelEfficiencyUpgradeItem;
            }
        });
        slots.add((Object)new SlotUpgrade(this, 4, 8, 36){

            @Override
            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof OreProcessingUpgradeItem;
            }
        });
    }

    public static void handleAutoOutput(InventoryBlockEntity be, int output) {
        for (Direction dir : Direction.values()) {
            IPlatformItemHandler other;
            BlockEntity tile = be.m_58904_().m_7702_(be.m_58899_().m_121945_(dir));
            if (tile == null || (other = (IPlatformItemHandler)FactoryAPIPlatform.getPlatformFactoryStorage((BlockEntity)tile).getStorage(Storages.ITEM, dir.m_122424_()).get()) == null || be.inventory.m_8020_(output).m_41619_() || BuiltInRegistries.f_256975_.m_7981_((Object)tile.m_58900_().m_60734_()).m_135827_().equals("storagedrawers")) continue;
            for (int i = 0; i < other.m_6643_(); ++i) {
                ItemStack stack = be.inventory.extractItem(output, be.inventory.m_8020_(output).m_41741_() - other.m_8020_(i).m_41613_(), true);
                if (!other.m_7013_(i, stack) || !other.m_8020_(i).m_41619_() && (!other.m_7013_(i, stack) || !ItemStack.m_150942_((ItemStack)other.m_8020_(i), (ItemStack)stack) || other.m_8020_(i).m_41613_() + stack.m_41613_() > other.m_6893_())) continue;
                be.inventory.m_6836_(output, other.insertItem(i, stack, false));
            }
        }
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
    }

    static {
        HAS_LAVA = s -> CobblestoneGeneratorBlockEntity.hasFluidAsBucket(s, (Fluid)Fluids.f_76195_);
        HAS_WATER = s -> CobblestoneGeneratorBlockEntity.hasFluidAsBucket(s, (Fluid)Fluids.f_76193_);
    }
}

