/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtil {
    private static final Vec3 fromOrigin = new Vec3(-0.5, -0.5, -0.5);

    public static AABB rotate(AABB box, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> box;
            case Direction.UP -> new AABB(box.f_82288_, -box.f_82289_, -box.f_82290_, box.f_82291_, -box.f_82292_, -box.f_82293_);
            case Direction.NORTH -> new AABB(box.f_82288_, -box.f_82290_, box.f_82289_, box.f_82291_, -box.f_82293_, box.f_82292_);
            case Direction.SOUTH -> new AABB(-box.f_82288_, -box.f_82290_, -box.f_82289_, -box.f_82291_, -box.f_82293_, -box.f_82292_);
            case Direction.WEST -> new AABB(box.f_82289_, -box.f_82290_, -box.f_82288_, box.f_82292_, -box.f_82293_, -box.f_82291_);
            case Direction.EAST -> new AABB(-box.f_82289_, -box.f_82290_, box.f_82288_, -box.f_82292_, -box.f_82293_, box.f_82291_);
        };
    }

    public static AABB rotate(AABB box, Rotation rotation) {
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> box;
            case Rotation.CLOCKWISE_90 -> new AABB(-box.f_82290_, box.f_82289_, box.f_82288_, -box.f_82293_, box.f_82292_, box.f_82291_);
            case Rotation.CLOCKWISE_180 -> new AABB(-box.f_82288_, box.f_82289_, -box.f_82290_, -box.f_82291_, box.f_82292_, -box.f_82293_);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.f_82290_, box.f_82289_, -box.f_82288_, box.f_82293_, box.f_82292_, -box.f_82291_);
        };
    }

    public static AABB rotateHorizontal(AABB box, Direction side) {
        return switch (side) {
            case Direction.NORTH -> VoxelShapeUtil.rotate(box, Rotation.NONE);
            case Direction.SOUTH -> VoxelShapeUtil.rotate(box, Rotation.CLOCKWISE_180);
            case Direction.WEST -> VoxelShapeUtil.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            case Direction.EAST -> VoxelShapeUtil.rotate(box, Rotation.CLOCKWISE_90);
            default -> box;
        };
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelShapeUtil.rotate(shape, box -> VoxelShapeUtil.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelShapeUtil.rotate(shape, box -> VoxelShapeUtil.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelShapeUtil.rotate(shape, box -> VoxelShapeUtil.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.m_83299_();
        for (AABB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(Shapes.m_83064_((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.m_82386_(VoxelShapeUtil.fromOrigin.f_82479_, VoxelShapeUtil.fromOrigin.f_82480_, VoxelShapeUtil.fromOrigin.f_82481_))).m_82386_(-VoxelShapeUtil.fromOrigin.f_82479_, -VoxelShapeUtil.fromOrigin.f_82481_, -VoxelShapeUtil.fromOrigin.f_82481_)));
        }
        return VoxelShapeUtil.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelShapeUtil.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelShapeUtil.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelShapeUtil.batchCombine(Shapes.m_83144_(), BooleanOp.f_82685_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.m_83296_() : combinedShape;
    }
}

