/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IFactoryItem;
import wily.factoryapi.base.client.IFactoryBlockEntityWLRenderer;

public class ScreenUtil {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void drawString(PoseStack stack, String text, int x, int y, int color, boolean shadow) {
        Font font = ScreenUtil.mc.f_91062_;
        MultiBufferSource.BufferSource source = mc.m_91269_().m_110104_();
        font.m_272078_(text, (float)x, (float)y, color, shadow, stack.m_85850_().m_252922_(), (MultiBufferSource)source, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
        RenderSystem.disableDepthTest();
        source.m_109911_();
        RenderSystem.enableDepthTest();
    }

    public static void prepTextScale(PoseStack poseStack, Consumer<PoseStack> runnable, float x, float y, float scale) {
        float yAdd = 4.0f - scale * 8.0f / 2.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(x, y + yAdd, 0.0f);
        poseStack.m_85841_(scale, scale, scale);
        runnable.accept(poseStack);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawGUIBackground(GuiGraphics graphics, int x, int y, int width, int height, int outlineColor, int mainColor, int shadowColor, int lightColor) {
        graphics.m_280509_(x + 2, y + 2, x + width - 2, y + height - 2, mainColor);
        graphics.m_280509_(x + 2, y + 1, x + width - 3, y + 3, lightColor);
        graphics.m_280509_(x + 3, y + 3, x + 4, y + 4, lightColor);
        graphics.m_280509_(x + 1, y + 2, x + 3, y + height - 3, lightColor);
        graphics.m_280509_(x + 3, y + height - 1, x + width - 3, y + height - 3, shadowColor);
        graphics.m_280509_(x + width - 1, y + 3, x + width - 3, y + height - 3, shadowColor);
        graphics.m_280509_(x + width - 4, y + height - 4, x + width - 2, y + height - 2, shadowColor);
        graphics.m_280509_(x + 2, y, x + width - 3, y + 1, outlineColor);
        graphics.m_280509_(x + 3, y + height - 1, x + width - 3, y + height, outlineColor);
        graphics.m_280509_(x, y + 2, x + 1, y + height - 3, outlineColor);
        graphics.m_280509_(x + width - 1, y + 3, x + width, y + height - 3, outlineColor);
        BiConsumer<Integer, Integer> outlinePixel = (posx, posy) -> graphics.m_280509_(posx.intValue(), posy.intValue(), posx + 1, posy + 1, outlineColor);
        outlinePixel.accept(x + 1, y + 1);
        outlinePixel.accept(x + width - 3, y + 1);
        outlinePixel.accept(x + width - 2, y + 2);
        outlinePixel.accept(x + 1, y + height - 3);
        outlinePixel.accept(x + 2, y + height - 2);
        outlinePixel.accept(x + width - 2, y + height - 3);
        outlinePixel.accept(x + width - 3, y + height - 2);
    }

    public static void drawGUIBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.drawGUIBackground(graphics, x, y, width, height, -16777216, -3750202, -11184811, -1);
    }

    public static void drawGUISlot(GuiGraphics graphics, int x, int y, int width, int height, int shadowColor, int lightColor, int cornerColor, Integer backGroundColor) {
        graphics.m_280509_(x, y, x + width - 1, y + 1, shadowColor);
        graphics.m_280509_(x, y + 1, x + 1, y + height - 1, shadowColor);
        graphics.m_280509_(x + 1, y + height - 1, x + width, y + height, lightColor);
        graphics.m_280509_(x + width - 1, y + 1, x + width, y + height - 1, lightColor);
        graphics.m_280509_(x + width - 1, y + 1, x + width, y + height - 1, lightColor);
        graphics.m_280509_(x + width - 1, y, x + width, y + 1, cornerColor);
        graphics.m_280509_(x, y + height - 1, x + 1, y + height, cornerColor);
        if (backGroundColor != null) {
            graphics.m_280509_(x + 1, y + 1, x + width - 1, y + height - 1, backGroundColor.intValue());
        }
    }

    public static void drawGUISlot(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.drawGUISlot(graphics, x, y, width, height, -13158601, -1, -7631989, -7631989);
    }

    public static void drawGUISubSlot(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.drawGUISlot(graphics, x, y, width, height, -16777216, -1, -13158601, -14342875);
    }

    public static void drawGUIFluidSlot(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.drawGUISlot(graphics, x, y, width, height, -13158601, -1, -7631989, -8947849);
    }

    public static void drawGUISlotOutline(GuiGraphics graphics, int x, int y, int width, int height) {
        ScreenUtil.drawGUISlot(graphics, x, y, width, height, -10263709, -5066062, -8158333, null);
    }

    public static void renderScaled(PoseStack stack, String text, int x, int y, float scale, int color, boolean shadow) {
        ScreenUtil.prepTextScale(stack, m -> ScreenUtil.drawString(stack, text, 0, 0, color, shadow), x, y, scale);
    }

    public static BakedModel getItemStackModel(ItemRenderer itemRenderer, ItemStack stack) {
        return itemRenderer.m_174264_(stack, null, null, 1);
    }

    public static ScreenRectangle rect2iToRectangle(Rect2i rect) {
        return new ScreenRectangle(new ScreenPosition(rect.m_110085_(), rect.m_110086_()), rect.m_110090_(), rect.m_110091_());
    }

    public static void renderGuiBlock(GuiGraphics graphics, @Nullable BlockEntity be, BlockState state, int i, int j, float scaleX, float scaleY, float rotateX, float rotateY) {
        ItemRenderer itemRenderer = mc.m_91291_();
        ItemStack stack = state.m_60734_().m_5456_().m_7968_();
        BakedModel bakedModel = ScreenUtil.getItemStackModel(itemRenderer, stack);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)i + 8.0f, (float)j + 8.0f, 250.0f);
        graphics.m_280168_().m_85841_(1.0f, -1.0f, 1.0f);
        graphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        graphics.m_280168_().m_85841_(scaleX, scaleY, 0.5f);
        graphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(rotateX));
        graphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(rotateY));
        Lighting.m_84930_();
        Consumer<BakedModel> defaultRender = b -> itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, b);
        if (bakedModel.m_7521_()) {
            stack.m_41784_().m_128365_("BlockEntityTag", (Tag)be.m_5995_());
            Item item = state.m_60734_().m_5456_();
            if (item instanceof IFactoryItem) {
                IFactoryItem item2 = (IFactoryItem)item;
                bakedModel.m_7442_().m_269404_(ItemDisplayContext.NONE).m_111763_(false, graphics.m_280168_());
                graphics.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
                item2.clientExtension(c -> {
                    BlockEntityWithoutLevelRenderer patt8193$temp = c.getCustomRenderer(mc.m_167982_(), mc.m_167973_());
                    if (patt8193$temp instanceof IFactoryBlockEntityWLRenderer) {
                        IFactoryBlockEntityWLRenderer renderer = (IFactoryBlockEntityWLRenderer)patt8193$temp;
                        renderer.renderByItemBlockState(state, stack, ItemDisplayContext.NONE, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_);
                    }
                });
            } else {
                defaultRender.accept(bakedModel);
            }
        } else {
            defaultRender.accept(mc.m_91289_().m_110910_(state));
        }
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
    }

    public static void playButtonDownSound(float grave) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)grave));
    }
}

