/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonObject;
import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidStackUtil {
    public static FluidStack fromJson(JsonObject jsonObject) {
        if (jsonObject != null) {
            String string2 = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"fluid", (String)"minecraft:empty");
            long amount = FluidStackUtil.getPlatformFluidAmount(GsonHelper.m_13828_((JsonObject)jsonObject, (String)"amount", (long)1000L));
            return FluidStack.create((Fluid)((Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(string2))), (long)amount);
        }
        return FluidStack.empty();
    }

    public static FluidStack fromTag(CompoundTag tag) {
        if (tag.m_128441_("FluidName") || tag.m_128441_("fluidVariant") && Platform.isFabric()) {
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(Platform.isFabric() ? tag.m_128469_("fluidVariant").m_128461_("fluid") : tag.m_128461_("FluidName")));
            if (fluid == Fluids.f_76191_) {
                return FluidStack.empty();
            }
            return FluidStack.create((Fluid)fluid, (long)tag.m_128454_(Platform.isFabric() ? "amount" : "Amount"));
        }
        return FluidStack.empty();
    }

    public static CompoundTag toTag(FluidStack stack) {
        CompoundTag tag = new CompoundTag();
        if (stack != null && !stack.isEmpty()) {
            tag.m_128356_(Platform.isFabric() ? "amount" : "Amount", stack.getAmount());
            CompoundTag fluidTag = tag;
            if (Platform.isFabric()) {
                fluidTag = new CompoundTag();
                tag.m_128365_("fluidVariant", (Tag)fluidTag);
            }
            fluidTag.m_128359_(Platform.isFabric() ? "fluid" : "FluidName", BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid()).toString());
        }
        return tag;
    }

    public static long getPlatformFluidAmount(long amount) {
        return (long)((float)amount / 1000.0f * (float)FluidStack.bucketAmount());
    }
}

