/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Matrix4f;

public class FluidRenderUtil {
    public static void renderTiledFluid(GuiGraphics graphics, int posX, int posY, int i, int j, int renderAmount, int fluidWidth, TextureAtlasSprite fluidSprite) {
        int drawWidth = Math.min(fluidWidth - i, 16);
        int drawHeight = Math.min(renderAmount - j, 16);
        int drawX = posX + i;
        int drawY = posY + j;
        float minU = fluidSprite.m_118409_();
        float maxU = fluidSprite.m_118410_();
        float minV = fluidSprite.m_118411_();
        float maxV = fluidSprite.m_118412_();
        float dH = minV + (maxV - minV) * (float)drawHeight / 16.0f;
        float dW = minU + (maxU - minU) * (float)drawWidth / 16.0f;
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, (float)drawX, (float)(drawY + drawHeight), 0.0f).m_7421_(minU, dH).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(drawX + drawWidth), (float)(drawY + drawHeight), 0.0f).m_7421_(dW, dH).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)(drawX + drawWidth), (float)drawY, 0.0f).m_7421_(dW, minV).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)drawX, (float)drawY, 0.0f).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public static TextureAtlasSprite fluidSprite(FluidStack fluid, boolean hasColor) {
        TextureAtlasSprite fluidSprite = FluidStackHooks.getStillTexture((FluidStack)fluid);
        if (hasColor) {
            int color = FluidStackHooks.getColor((FluidStack)fluid);
            float a = (float)((color & 0xFF000000) >> 24) / 255.0f;
            a = a <= 0.001f ? 1.0f : a;
            float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((color & 0xFF00) >> 8) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
        return fluidSprite;
    }
}

