/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.util.FluidStackUtil;

public class CompoundTagUtil {
    public static boolean compoundContains(CompoundTag comparator, CompoundTag contains) {
        HashMap map = new HashMap(comparator.f_128329_);
        for (String key : contains.m_128431_()) {
            block3: {
                CompoundTag ct2;
                Object object;
                block4: {
                    ListTag l2;
                    if (!map.containsKey(key)) continue;
                    if (((Tag)map.get(key)).m_7916_().equals(contains.m_128423_(key).m_7916_())) break block3;
                    object = map.get(key);
                    if (!(object instanceof ListTag)) break block4;
                    ListTag l1 = (ListTag)object;
                    object = contains.m_128423_(key);
                    if (object instanceof ListTag && (l2 = (ListTag)object).containsAll((Collection)l1)) break block3;
                }
                if (!((object = map.get(key)) instanceof CompoundTag)) continue;
                CompoundTag ct1 = (CompoundTag)object;
                object = contains.m_128423_(key);
                if (!(object instanceof CompoundTag) || !CompoundTagUtil.compoundContains(ct1, ct2 = (CompoundTag)object)) continue;
            }
            map.remove(key);
        }
        return map.isEmpty();
    }

    public static CompoundTag getFromJson(JsonObject obj) {
        CompoundTag tag = new CompoundTag();
        JsonObject nbt = obj.getAsJsonObject("nbt");
        if (obj.has("nbt") && nbt != null) {
            tag = CompoundTagUtil.jsonObject(nbt);
        }
        CompoundTagUtil.putJsonFluidTag(tag, obj);
        return tag;
    }

    public static CompoundTag putJsonFluidTag(CompoundTag tag, JsonObject obj) {
        JsonObject fluidJson = obj.getAsJsonObject("fluidStack");
        if (obj.has("fluidStack") && fluidJson != null) {
            CompoundTag fluid = new CompoundTag();
            String name = GsonHelper.m_13851_((JsonObject)fluidJson, (String)"fluid", (String)"minecraft:empty");
            if (Platform.isForge()) {
                fluid.m_128359_("FluidName", name);
            } else {
                CompoundTag fluidVariant = new CompoundTag();
                fluidVariant.m_128359_("fluid", name);
                fluid.m_128365_("fluidVariant", (Tag)fluidVariant);
            }
            fluid.m_128356_(Platform.isForge() ? "Amount" : "amount", FluidStackUtil.getPlatformFluidAmount(GsonHelper.m_13828_((JsonObject)fluidJson, (String)"amount", (long)1000L)));
            tag.m_128365_(Platform.isForge() ? "Fluid" : "fluidStorage", (Tag)fluid);
        }
        return tag;
    }

    public static CompoundTag jsonObject(JsonObject obj) {
        CompoundTag tag = new CompoundTag();
        if (obj != null) {
            obj.asMap().forEach((s, e) -> {
                JsonArray a;
                if (e instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)e;
                    CompoundTagUtil.jsonPrimitiveNbt(tag, s, p);
                } else if (e instanceof JsonArray && !(a = (JsonArray)e).isEmpty()) {
                    ListTag arr = new ListTag();
                    a.forEach(t -> {
                        if (t instanceof JsonPrimitive) {
                            JsonPrimitive p = (JsonPrimitive)t;
                            CompoundTagUtil.jsonPrimitiveListTag(arr, p);
                        }
                    });
                    tag.m_128365_(s, (Tag)arr);
                } else if (e instanceof JsonObject) {
                    JsonObject o = (JsonObject)e;
                    tag.m_128365_(s, (Tag)CompoundTagUtil.jsonObject(o));
                }
            });
        }
        return tag;
    }

    public static void jsonPrimitiveNbt(CompoundTag tag, String s, JsonPrimitive p) {
        if (p.isNumber()) {
            Number n = p.getAsNumber();
            if (n instanceof Long) {
                Long l = (Long)n;
                tag.m_128356_(s, l.longValue());
            } else if (n instanceof Float) {
                Float f = (Float)n;
                tag.m_128350_(s, f.floatValue());
            } else if (n instanceof Short) {
                Short st = (Short)n;
                tag.m_128376_(s, st.shortValue());
            } else if (n instanceof Byte) {
                Byte bt = (Byte)n;
                tag.m_128344_(s, bt.byteValue());
            } else {
                tag.m_128405_(s, n.intValue());
            }
        } else if (p.isBoolean()) {
            tag.m_128379_(s, p.getAsBoolean());
        } else if (p.isString()) {
            tag.m_128359_(s, p.getAsString());
        }
    }

    public static void jsonPrimitiveListTag(ListTag tag, JsonPrimitive p) {
        if (p.isNumber()) {
            Number n = p.getAsNumber();
            if (n instanceof Long) {
                Long l = (Long)n;
                tag.add((Object)LongTag.m_128882_((long)l));
            } else if (n instanceof Float) {
                Float f = (Float)n;
                tag.add((Object)FloatTag.m_128566_((float)f.floatValue()));
            } else if (n instanceof Short) {
                Short st = (Short)n;
                tag.add((Object)ShortTag.m_129258_((short)st));
            } else if (n instanceof Byte) {
                Byte bt = (Byte)n;
                tag.add((Object)ByteTag.m_128266_((byte)bt));
            } else {
                tag.add((Object)IntTag.m_128679_((int)n.intValue()));
            }
        } else if (p.isBoolean()) {
            tag.add((Object)ByteTag.m_128273_((boolean)p.getAsBoolean()));
        } else if (p.isString()) {
            tag.add((Object)StringTag.m_129297_((String)p.getAsString()));
        }
    }

    public static List<Item> getItemComponents(ItemStack itemStack) {
        ArrayList<Item> list = new ArrayList<Item>();
        if (itemStack.m_41782_() && !itemStack.m_41783_().m_128437_("Components", 8).isEmpty()) {
            itemStack.m_41783_().m_128437_("Components", 8).forEach(t -> list.add((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(t.m_7916_()))));
        }
        return list;
    }
}

