/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.forge.mixin;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import wily.factoryapi.base.FactoryItemFluidHandler;
import wily.factoryapi.base.IFluidHandlerItem;

@Mixin(value={IFluidHandlerItem.class})
public interface FluidHandlerItem
extends IForgeItem {
    default public IFluidHandlerItem<?> self() {
        return (IFluidHandlerItem)((Object)this);
    }

    @Nullable
    default public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                IFluidHandlerItem<?> storageItem = FluidHandlerItem.this.self();
                if (capability == ForgeCapabilities.FLUID_HANDLER_ITEM) {
                    return LazyOptional.of(() -> new FactoryItemFluidHandler(storageItem.getCapacity(), stack, storageItem::isFluidValid, storageItem.getTransport())).cast();
                }
                return LazyOptional.empty();
            }
        };
    }
}

