/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.forge.base;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.forge.base.FluidMultiUtil;

public interface ForgeFluidHandlerPlatform
extends IPlatformFluidHandler,
IPlatformHandlerApi<IFluidHandler> {
    @Override
    default public SlotsIdentifier identifier() {
        return SlotsIdentifier.GENERIC;
    }

    @Override
    @NotNull
    default public FluidStack getFluidStack() {
        return FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)((IFluidHandler)this.getHandler()).getFluidInTank(0));
    }

    @Override
    default public long getMaxFluid() {
        return ((IFluidHandler)this.getHandler()).getTankCapacity(0);
    }

    @Override
    default public boolean isFluidValid(@NotNull FluidStack stack) {
        return ((IFluidHandler)this.getHandler()).isFluidValid(0, FluidStackHooksForge.toForge((FluidStack)stack));
    }

    @Override
    default public long fill(FluidStack resource, boolean simulate) {
        return ((IFluidHandler)this.getHandler()).fill(FluidStackHooksForge.toForge((FluidStack)resource), FluidMultiUtil.fluidActionOf(simulate));
    }

    @Override
    @NotNull
    default public FluidStack drain(FluidStack resource, boolean simulate) {
        return FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)((IFluidHandler)this.getHandler()).drain(FluidStackHooksForge.toForge((FluidStack)resource), FluidMultiUtil.fluidActionOf(simulate)));
    }

    @Override
    @NotNull
    default public FluidStack drain(long maxDrain, boolean simulate) {
        return this.drain(this.getFluidStack().copyWithAmount(maxDrain), simulate);
    }

    @Override
    default public void setFluid(FluidStack fluidStack) {
        if (!this.getFluidStack().isEmpty()) {
            this.drain(this.getFluidStack(), false);
        }
        this.fill(fluidStack, false);
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    @Override
    default public CompoundTag serializeTag() {
        return new CompoundTag();
    }

    @Override
    default public void deserializeTag(CompoundTag nbt) {
    }
}

