/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.forge;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.forge.base.FluidMultiUtil;

public class ItemContainerUtilImpl {
    public static boolean isFluidContainer(ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public static IFluidHandlerItem getItemFluidHandler(ItemStack stack) {
        return (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(() -> new RuntimeException("Non FluidContainer"));
    }

    public static ItemStack getFluidContainer(ItemStack stack) {
        if (!ItemContainerUtilImpl.isFluidContainer(stack)) {
            return stack;
        }
        return ItemContainerUtilImpl.getItemFluidHandler(stack).getContainer();
    }

    public static FluidStack getFluid(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return ItemContainerUtilImpl.getFluid(stack);
    }

    public static FluidStack getFluid(ItemStack stack) {
        if (ItemContainerUtilImpl.isFluidContainer(stack)) {
            return FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)((IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().get()).getFluidInTank(0));
        }
        return FluidStack.empty();
    }

    public static ItemContainerUtil.ItemFluidContext fillItem(ItemStack stack, Player player, InteractionHand hand, FluidStack fluidStack) {
        if (!ItemContainerUtilImpl.isFluidContainer(stack) || player == null && stack.m_41613_() != 1) {
            return new ItemContainerUtil.ItemFluidContext(stack);
        }
        IFluidHandler.FluidAction action = FluidMultiUtil.fluidActionOf(player != null && player.m_7500_());
        ItemStack toFill = action.execute() ? stack.m_255036_(1) : stack.m_41777_();
        IFluidHandlerItem tank = (IFluidHandlerItem)toFill.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().get();
        long amount = tank.fill(FluidStackHooksForge.toForge((FluidStack)fluidStack), action);
        if (player != null && amount > 0L) {
            SoundEvent sound;
            if (action.execute()) {
                if (stack.m_41613_() > 1) {
                    player.m_21008_(hand, stack.m_255036_(stack.m_41613_() - 1));
                    player.m_36356_(tank.getContainer());
                } else {
                    player.m_21008_(hand, tank.getContainer());
                }
            }
            if ((sound = fluidStack.getFluid().getFluidType().getSound(FluidStackHooksForge.toForge((FluidStack)fluidStack), SoundActions.BUCKET_FILL)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
        }
        return new ItemContainerUtil.ItemFluidContext(FluidStack.create((Fluid)fluidStack.getFluid(), (long)amount), tank.getContainer());
    }

    public static long fillItem(FluidStack fluidStack, Player player, InteractionHand hand) {
        return ItemContainerUtilImpl.fillItem(player.m_21120_(hand), player, hand, fluidStack).fluidStack().getAmount();
    }

    public static ItemContainerUtil.ItemFluidContext fillItem(ItemStack stack, FluidStack fluidStack) {
        return ItemContainerUtilImpl.fillItem(stack, null, null, fluidStack);
    }

    public static ItemContainerUtil.ItemFluidContext drainItem(long maxDrain, ItemStack stack, Player player, InteractionHand hand) {
        if (!ItemContainerUtilImpl.isFluidContainer(stack) || player == null && stack.m_41613_() != 1) {
            return new ItemContainerUtil.ItemFluidContext(stack);
        }
        IFluidHandler.FluidAction action = FluidMultiUtil.fluidActionOf(player != null && player.m_7500_());
        ItemStack toDrain = action.execute() ? stack.m_255036_(1) : stack.m_41777_();
        IFluidHandlerItem tank = (IFluidHandlerItem)toDrain.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().get();
        FluidStack fluidStack = FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)tank.drain((int)maxDrain, action));
        if (player != null && fluidStack.getAmount() > 0L) {
            SoundEvent sound;
            if (action.execute()) {
                if (stack.m_41613_() > 1) {
                    player.m_21008_(hand, stack.m_255036_(stack.m_41613_() - 1));
                    player.m_36356_(tank.getContainer());
                } else {
                    player.m_21008_(hand, tank.getContainer());
                }
            }
            if ((sound = fluidStack.getFluid().getFluidType().getSound(FluidStackHooksForge.toForge((FluidStack)fluidStack), SoundActions.BUCKET_EMPTY)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
        }
        return new ItemContainerUtil.ItemFluidContext(fluidStack, tank.getContainer());
    }

    public static FluidStack drainItem(long maxDrain, Player player, InteractionHand hand) {
        return ItemContainerUtilImpl.drainItem(maxDrain, player.m_21120_(hand), player, hand).fluidStack();
    }

    public static ItemContainerUtil.ItemFluidContext drainItem(long maxDrain, ItemStack stack) {
        return ItemContainerUtilImpl.drainItem(maxDrain, stack, null, null);
    }

    public static boolean isEnergyContainer(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static int insertEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerUtilImpl.insertEnergy(energy, player.m_21120_(hand)).contextEnergy();
    }

    public static ItemContainerUtil.ItemEnergyContext insertEnergy(int energy, ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
        return new ItemContainerUtil.ItemEnergyContext(energyStorage.receiveEnergy(energy, false), stack);
    }

    public static int extractEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerUtilImpl.extractEnergy(energy, player.m_21120_(hand)).contextEnergy();
    }

    public static ItemContainerUtil.ItemEnergyContext extractEnergy(int energy, ItemStack stack) {
        if (!ItemContainerUtilImpl.isEnergyContainer(stack)) {
            return new ItemContainerUtil.ItemEnergyContext(0, stack);
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
        return new ItemContainerUtil.ItemEnergyContext(energyStorage.extractEnergy(energy, false), stack);
    }

    public static int getEnergy(ItemStack stack) {
        if (!ItemContainerUtilImpl.isEnergyContainer(stack)) {
            return 0;
        }
        return ((IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).getEnergyStored();
    }
}

