/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.forge;

import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.IItemHandler;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.Storages;
import wily.factoryapi.forge.base.CapabilityUtil;
import wily.factoryapi.forge.base.FactoryCapabilities;

public class FactoryAPIPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static IPlatformFluidHandler getItemFluidHandler(ItemStack container) {
        IPlatformFluidHandler f;
        Object t;
        Optional opt = container.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        IPlatformFluidHandler iPlatformFluidHandler = opt.isPresent() ? ((t = opt.get()) instanceof IPlatformFluidHandler ? (f = (IPlatformFluidHandler)t) : opt::get) : null;
        return iPlatformFluidHandler;
    }

    public static IPlatformEnergyStorage getItemEnergyStorage(ItemStack container) {
        IPlatformEnergyStorage f;
        Object t;
        Optional opt = container.getCapability(ForgeCapabilities.ENERGY).resolve();
        IPlatformEnergyStorage iPlatformEnergyStorage = opt.isPresent() ? ((t = opt.get()) instanceof IPlatformEnergyStorage ? (f = (IPlatformEnergyStorage)t) : opt::get) : null;
        return iPlatformEnergyStorage;
    }

    public static Component getPlatformEnergyComponent() {
        return Component.m_237113_((String)"Forge Energy (FE)").m_130940_(ChatFormatting.GREEN);
    }

    public static IFactoryStorage getPlatformFactoryStorage(final BlockEntity be) {
        if (be instanceof IFactoryStorage) {
            IFactoryStorage st = (IFactoryStorage)be;
            return st;
        }
        FactoryAPIPlatform.platformStorageWrappersCache.entrySet().removeIf(e -> ((BlockEntity)e.getKey()).m_58901_());
        return FactoryAPIPlatform.platformStorageWrappersCache.computeIfAbsent(be, be1 -> new IFactoryStorage(){

            @Override
            public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(Storages.Storage<T> storage, Direction direction) {
                Capability<?> capability = CapabilityUtil.storageToCapability(storage);
                if (capability != null && be.getCapability(capability, direction).isPresent()) {
                    Object handler = be.getCapability(capability, direction).resolve().get();
                    if (storage == Storages.ENERGY) {
                        return () -> {
                            IPlatformEnergyStorage iPlatformEnergyStorage;
                            if (handler instanceof IPlatformEnergyStorage) {
                                IPlatformEnergyStorage energyHandler = (IPlatformEnergyStorage)handler;
                                iPlatformEnergyStorage = energyHandler;
                            } else {
                                iPlatformEnergyStorage = () -> (IEnergyStorage)handler;
                            }
                            return iPlatformEnergyStorage;
                        };
                    }
                    if (storage == Storages.CRAFTY_ENERGY && handler instanceof ICraftyEnergyStorage) {
                        ICraftyEnergyStorage energyHandler = (ICraftyEnergyStorage)handler;
                        return () -> energyHandler;
                    }
                    if (storage == Storages.ITEM) {
                        return () -> {
                            IPlatformItemHandler iPlatformItemHandler;
                            if (handler instanceof IPlatformItemHandler) {
                                IPlatformItemHandler itemHandler = (IPlatformItemHandler)handler;
                                iPlatformItemHandler = itemHandler;
                            } else {
                                iPlatformItemHandler = () -> (IItemHandler)handler;
                            }
                            return iPlatformItemHandler;
                        };
                    }
                    if (storage == Storages.FLUID) {
                        return () -> {
                            IPlatformFluidHandler iPlatformFluidHandler;
                            if (handler instanceof IPlatformFluidHandler) {
                                IPlatformFluidHandler fluidHandler = (IPlatformFluidHandler)handler;
                                iPlatformFluidHandler = fluidHandler;
                            } else {
                                iPlatformFluidHandler = () -> (IFluidHandler)handler;
                            }
                            return iPlatformFluidHandler;
                        };
                    }
                }
                return ArbitrarySupplier.empty();
            }
        });
    }

    public static ICraftyEnergyStorage getItemCraftyEnergyStorage(ItemStack container) {
        return (ICraftyEnergyStorage)container.getCapability(FactoryCapabilities.CRAFTY_ENERGY).orElse(null);
    }
}

