/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client.drawable;

import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableCustomWidth;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;

public class FactoryDrawableSlider
extends AbstractDrawableButton<FactoryDrawableSlider> {
    private final DrawableCustomWidth<?> sliderBackground;
    public int value;
    public final int maxValue;
    public int relativePosX = 0;
    public boolean dragging = false;
    protected Function<FactoryDrawableSlider, Component> customText;

    public FactoryDrawableSlider(int x, int y, Function<FactoryDrawableSlider, Component> customText, IFactoryDrawableType buttonImage, IFactoryDrawableType sliderBackground, int buttonWidth, int sliderWidth, int initialValue, int maxValue) {
        super(x, y, buttonImage);
        this.customText = customText;
        this.sliderBackground = new DrawableCustomWidth(sliderBackground);
        this.sliderBackground.customWidth = sliderWidth;
        this.value = initialValue;
        this.maxValue = maxValue;
        this.customWidth = buttonWidth;
    }

    public FactoryDrawableSlider(int x, int y, Function<FactoryDrawableSlider, Component> customText, IFactoryDrawableType buttonImage, int buttonWidth, int sliderWidth, int initialValue, int maxValue) {
        this(x, y, customText, buttonImage, IFactoryDrawableType.create(buttonImage.texture(), buttonImage.uvX() + buttonImage.width(), buttonImage.uvY(), sliderWidth, buttonImage.height()), buttonWidth, sliderWidth, initialValue, maxValue);
    }

    public int getValue() {
        return this.value;
    }

    public float getPercentage() {
        return (float)this.value / (float)this.maxValue;
    }

    @Override
    public boolean m_6375_(double d, double e, int i) {
        if (this.inMouseLimit(d, e) && !this.inButtonLimit(d, e)) {
            this.value = this.getActualValue(d);
        }
        return super.m_6375_(d, e, i);
    }

    protected int getActualValue(double mouseX) {
        return Math.round(Math.max(0.0f, Math.min(((float)mouseX - (float)this.m_110085_()) / (float)this.sliderBackground.width() * (float)this.maxValue, (float)this.maxValue)));
    }

    public boolean m_6348_(double d, double e, int i) {
        this.dragging = false;
        this.selected = false;
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int i, double f, double g) {
        if (!((Boolean)this.visible.get()).booleanValue()) {
            return false;
        }
        if (this.inButtonLimit(mouseX, mouseY) || this.dragging) {
            this.dragging = true;
            this.selected = true;
            this.value = this.getActualValue(mouseX);
            this.onPress.accept(this, i);
            return true;
        }
        return false;
    }

    @Override
    public boolean inMouseLimit(double mouseX, double mouseY) {
        return this.sliderBackground.inMouseLimit((int)mouseX, (int)mouseY, this.m_110085_(), this.m_110086_());
    }

    public boolean inButtonLimit(double mouseX, double mouseY) {
        return IFactoryDrawableType.getMouseLimit(mouseX, mouseY, this.relativePosX, this.m_110086_(), this.width(), this.height());
    }

    @Override
    public void draw(GuiGraphics graphics) {
        if (this.dragging) {
            this.selected = true;
        }
        this.sliderBackground.draw(graphics, this.m_110085_(), this.m_110086_());
        Component comp = this.customText.apply(this);
        if (comp != null && !comp.getString().isEmpty()) {
            graphics.m_280430_(this.mc.f_91062_, comp, this.m_110085_() + (this.sliderBackground.width() - this.mc.f_91062_.m_92895_(comp.getString())) / 2, this.m_110086_() + this.height() / 2 - 4, -1);
        }
        this.relativePosX = (int)((float)this.m_110085_() + this.getPercentage() * (float)(this.sliderBackground.width() - this.width()));
        this.draw(graphics, this.relativePosX, this.m_110086_());
    }
}

