/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import dev.architectury.fluid.FluidStack;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryItemFluidHandler;
import wily.factoryapi.base.IFactoryItem;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportState;

public interface IFluidHandlerItem<T extends IPlatformFluidHandler>
extends IFactoryItem {
    default public T getFluidStorage(ItemStack stack) {
        return (T)FactoryAPIPlatform.getItemFluidHandler(stack);
    }

    public long getCapacity();

    default public boolean isFluidValid(FluidStack fluidStack) {
        return true;
    }

    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    @Override
    default public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(Storages.Storage<T> storage, ItemStack stack) {
        if (storage == Storages.FLUID_ITEM) {
            return () -> new FactoryItemFluidHandler(this.getCapacity(), stack, this::isFluidValid, this.getTransport());
        }
        return () -> null;
    }
}

