/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.IPlatformItemFluidHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidStackUtil;

public class FactoryItemFluidHandler
extends FactoryFluidHandler
implements IPlatformItemFluidHandler {
    private final ItemStack container;

    public FactoryItemFluidHandler(long capacity, ItemStack container) {
        this(capacity, container, f -> true, TransportState.EXTRACT_INSERT);
    }

    public FactoryItemFluidHandler(long capacity, ItemStack stack, Predicate<FluidStack> validator, TransportState transportState) {
        super(capacity, null, validator, SlotsIdentifier.GENERIC, transportState);
        this.container = stack;
    }

    private CompoundTag getFluidCompound(ItemStack stack) {
        return ItemContainerUtil.isBlockItem(stack) ? stack.m_41784_().m_128469_("BlockEntityTag").m_128469_("singleTank") : stack.m_41784_().m_128469_(Platform.isFabric() ? "fluidStorage" : "Fluid");
    }

    public String getStorageKey() {
        return ItemContainerUtil.isBlockItem(this.container) ? "singleTank" : (Platform.isFabric() ? "fluidStorage" : "Fluid");
    }

    @Override
    public void setFluid(FluidStack fluid) {
        boolean b = ItemContainerUtil.isBlockItem(this.container);
        CompoundTag tag = this.container.m_41784_();
        if (b) {
            tag = tag.m_128469_("BlockEntityTag");
        }
        CompoundTag newTag = FluidStackUtil.toTag(fluid);
        tag.m_128365_(this.getStorageKey(), (Tag)newTag);
        if (b) {
            this.container.m_41783_().m_128365_("BlockEntityTag", (Tag)tag);
        }
    }

    @Override
    @NotNull
    public FluidStack getFluidStack() {
        return FluidStackUtil.fromTag(this.getFluidCompound(this.container));
    }

    @Override
    public void deserializeTag(CompoundTag tag) {
        this.getFluidCompound(this.container).m_128365_(this.getStorageKey(), (Tag)tag);
    }

    @Override
    public CompoundTag serializeTag() {
        return this.getFluidCompound(this.container);
    }

    @Override
    public long fill(FluidStack resource, boolean simulate) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        FluidStack contained = this.getFluidStack();
        if (contained.isEmpty()) {
            long fillAmount = Math.min(this.capacity, resource.getAmount());
            if (!simulate) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            long fillAmount = Math.min(this.capacity - contained.getAmount(), resource.getAmount());
            if (!simulate && fillAmount > 0L) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0L;
    }

    @Override
    @NotNull
    public FluidStack drain(long maxDrain, boolean simulate) {
        if (this.container.m_41613_() != 1 || maxDrain <= 0L || !this.getTransport().canExtract()) {
            return FluidStack.empty();
        }
        FluidStack contained = this.getFluidStack();
        if (contained.isEmpty()) {
            return FluidStack.empty();
        }
        long drainAmount = Math.min(contained.getAmount(), maxDrain);
        FluidStack drained = contained.copy();
        drained.setAmount(drainAmount);
        if (!simulate) {
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
        return drained;
    }

    protected void setContainerToEmpty() {
        this.container.m_41749_(this.getStorageKey());
    }

    @Override
    public void setCapacity(long capacity) {
        this.getFluidCompound(this.container).m_128405_("capacity", (int)capacity);
    }

    @Override
    public ItemStack getContainer() {
        return this.container;
    }
}

