/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.TransportState;

public class FactoryEnergyStorage
implements IPlatformEnergyStorage {
    public static final String KEY = "energy";
    protected int energy = 0;
    public int maxOutput;
    public int maxInput;
    protected int capacity;
    BlockEntity be;
    protected TransportState transportState;

    public FactoryEnergyStorage(int capacity, @Nullable BlockEntity be, TransportState transportState) {
        this.maxOutput = this.maxInput = capacity;
        this.capacity = this.maxInput;
        this.be = be;
        this.transportState = transportState;
    }

    public FactoryEnergyStorage(int capacity, BlockEntity be) {
        this(capacity, be, TransportState.EXTRACT_INSERT);
    }

    @Override
    public void m_6596_() {
        if (this.be != null) {
            this.be.m_6596_();
        }
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int receiveEnergy(int maxInsert, boolean simulate) {
        if (!this.getTransport().canInsert()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxReceive(), maxInsert);
        if (!simulate && energyReceived != 0) {
            this.energy += energyReceived;
            this.m_6596_();
        }
        return energyReceived;
    }

    @Override
    public int consumeEnergy(int maxExtracted, boolean simulate) {
        if (!this.getTransport().canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getMaxConsume(), maxExtracted);
        if (!simulate) {
            this.energy -= energyExtracted;
            this.m_6596_();
        }
        return energyExtracted;
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    @Override
    public int getMaxConsume() {
        return Math.min(this.getEnergyStored(), this.maxOutput);
    }

    @Override
    public int getMaxReceive() {
        return Math.min(this.getEnergySpace(), this.maxInput);
    }

    @Override
    public TransportState getTransport() {
        return this.transportState;
    }

    @Override
    public CompoundTag serializeTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(KEY, this.energy);
        return tag;
    }

    @Override
    public boolean isRemoved() {
        return this.be.m_58901_();
    }

    @Override
    public void deserializeTag(CompoundTag nbt) {
        this.setEnergyStored(nbt.m_128451_(KEY));
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public static class SidedWrapper
    extends FactoryEnergyStorage
    implements IModifiableTransportHandler {
        private final IPlatformEnergyStorage energyStorage;

        public SidedWrapper(FactoryEnergyStorage energyStorage) {
            super(energyStorage.getMaxEnergyStored(), energyStorage.be, energyStorage.getTransport());
            this.energyStorage = energyStorage;
        }

        @Override
        public int getEnergyStored() {
            return this.energyStorage.getEnergyStored();
        }

        @Override
        public void setEnergyStored(int energy) {
            this.energyStorage.setEnergyStored(energy);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return this.energyStorage.receiveEnergy(maxReceive, simulate);
        }

        @Override
        public int consumeEnergy(int maxExtract, boolean simulate) {
            return this.energyStorage.consumeEnergy(maxExtract, simulate);
        }

        @Override
        public void setTransport(TransportState state) {
            this.transportState = state;
        }
    }
}

