/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum FactoryCapacityTiers {
    BURNED((Component)Component.m_237115_((String)"tier.factory_api.burned").m_130940_(ChatFormatting.DARK_RED), 0.0, 0, 0),
    BASIC((Component)Component.m_237115_((String)"tier.factory_api.basic").m_130940_(ChatFormatting.GRAY), 0.2, 800, 1),
    ADVANCED((Component)Component.m_237115_((String)"tier.factory_api.advanced").m_130940_(ChatFormatting.RED), 0.6, 2000, 3),
    HIGH((Component)Component.m_237115_((String)"tier.factory_api.high").m_130940_(ChatFormatting.BLUE), 0.5, 4000, 8),
    ULTIMATE((Component)Component.m_237115_((String)"tier.factory_api.ultimate").m_130940_(ChatFormatting.DARK_PURPLE), 0.63, 6000, 12),
    QUANTUM((Component)Component.m_237115_((String)"tier.factory_api.quantum").m_130940_(ChatFormatting.DARK_AQUA), 0.8, 10000, 16),
    CREATIVE((Component)Component.m_237115_((String)"tier.factory_api.creative").m_130940_(ChatFormatting.LIGHT_PURPLE), 1.0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    private final double conductivity;
    public final int initialCapacity;
    public final int capacityMultiplier;
    public final Component localizedName;

    private FactoryCapacityTiers(Component name, double j, int initialCapacity, int multiplier) {
        this.localizedName = name;
        this.conductivity = j;
        this.initialCapacity = initialCapacity;
        this.capacityMultiplier = multiplier;
    }

    public MutableComponent getEnergyTierComponent(boolean isStored) {
        return this.getPrefixComponent("energy", isStored).m_130940_(ChatFormatting.AQUA).m_7220_(this.localizedName);
    }

    public MutableComponent getOutputTierComponent() {
        return this.getPrefixComponent("energy", I18n.m_118938_((String)"tier.factory_api.output", (Object[])new Object[0])).m_130940_(ChatFormatting.AQUA).m_7220_(this.localizedName);
    }

    public MutableComponent getTierComponent(boolean isStored) {
        return this.getPrefixComponent("capacity", isStored).m_130940_(ChatFormatting.GRAY).m_7220_(this.localizedName);
    }

    public MutableComponent getPrefixComponent(String keyType, boolean isStored) {
        if (isStored) {
            return this.getPrefixComponent(keyType, I18n.m_118938_((String)"tier.factory_api.stored", (Object[])new Object[0]));
        }
        return this.getPrefixComponent(keyType, "");
    }

    public MutableComponent getPrefixComponent(String keyType, Object ... objects) {
        return Component.m_237110_((String)"tier.factory_api.display", (Object[])new Object[]{I18n.m_118938_((String)("tier.factory_api." + keyType), (Object[])objects)});
    }

    public boolean supportTier(FactoryCapacityTiers tier) {
        return this.ordinal() >= tier.ordinal();
    }

    public double getConductivity() {
        return this.conductivity;
    }

    public double getPowFactor() {
        return Math.pow(this.conductivity, 2.0);
    }

    public boolean isBurned() {
        return this == BURNED;
    }

    public int getDefaultCapacity() {
        return this.initialCapacity * 10;
    }

    public int getStorageCapacity() {
        return this.getDefaultCapacity() * this.capacityMultiplier;
    }

    public FactoryCapacityTiers increase(int ordinal) {
        return FactoryCapacityTiers.values()[Math.min(FactoryCapacityTiers.values().length - 1, this.ordinal() + ordinal)];
    }

    public int convertEnergyTo(int energy, FactoryCapacityTiers tier) {
        return (int)Math.round(Math.max((double)energy + (this.getConductivity() - tier.getConductivity()) * (double)energy * (double)this.initialCapacity / (double)tier.initialCapacity, 0.0));
    }
}

