/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class PlayerEquipsUtil {
    @Nonnull
    public static <T> T _null() {
        return null;
    }

    public static boolean wearingFullGobberArmor(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        return head.m_41720_() == ItemInit.GOBBER2_HELMET.get() && chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE.get() && legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS.get() && feet.m_41720_() == ItemInit.GOBBER2_BOOTS.get();
    }

    public static boolean wearingFullNetherArmor(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        return head.m_41720_() == ItemInit.GOBBER2_HELMET_NETHER.get() && chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get() && legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_NETHER.get() && feet.m_41720_() == ItemInit.GOBBER2_BOOTS_NETHER.get();
    }

    public static boolean wearingFullEndArmor(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        return head.m_41720_() == ItemInit.GOBBER2_HELMET_END.get() && chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_END.get() && legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_END.get() && feet.m_41720_() == ItemInit.GOBBER2_BOOTS_END.get();
    }

    public static boolean isPlayerGotVoidProtection(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        return head.m_41720_() == ItemInit.GOBBER2_HELMET_DRAGON.get() && chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get() && legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get() && feet.m_41720_() == ItemInit.GOBBER2_BOOTS_DRAGON.get();
    }

    public static boolean isPlayerGotWaterBreathing(Player player) {
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_MEDALLION_BREATHING.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_MEDALLION_BREATHING.get())) {
            return true;
        }
        return (Boolean)GobberConfigBuilder.ENABLE_ARMOR_WATER_BREATHING.get() != false && (head.m_41720_() == ItemInit.GOBBER2_HELMET.get() || head.m_41720_() == ItemInit.GOBBER2_HELMET_NETHER.get() || head.m_41720_() == ItemInit.GOBBER2_HELMET_END.get() || head.m_41720_() == ItemInit.GOBBER2_HELMET_DRAGON.get());
    }

    public static boolean isPlayerGotFallProtection(Player player) {
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (mainHand.m_41720_() == ItemInit.GOBBER2_RING_ASCENT.get() || offHand.m_41720_() == ItemInit.GOBBER2_RING_ASCENT.get() || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_ASCENT.get())) {
            return true;
        }
        return (Boolean)GobberConfigBuilder.ENABLE_ARMOR_NO_FALL_DAMAGE.get() != false && (legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS.get() || legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_NETHER.get() || legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_END.get() || legs.m_41720_() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get());
    }

    public static boolean isPlayerGotBlastProtection(Player player) {
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        return (Boolean)GobberConfigBuilder.ENABLE_ARMOR_NO_FALL_DAMAGE.get() != false && (feet.m_41720_() == ItemInit.GOBBER2_BOOTS_END.get() || feet.m_41720_() == ItemInit.GOBBER2_BOOTS_DRAGON.get());
    }

    public static boolean isPlayerGotFireProtection(Player player) {
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack mainHand = player.m_21205_();
        if (mainHand.m_41720_() == ItemInit.GOBBER2_RING_BLAZE.get() || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_BLAZE.get())) {
            return true;
        }
        if (PlayerEquipsUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_PHOENIX.get()) || PlayerEquipsUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_PHOENIX.get())) {
            return true;
        }
        if (chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get()) {
            return true;
        }
        return (Boolean)GobberConfigBuilder.ENABLE_ARMOR_FIRE_PROTECTION.get() != false && (chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get() || chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_END.get() || chest.m_41720_() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get());
    }

    public static boolean isPlayerGotStealth(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41720_() == ItemInit.GOBBER2_RING_STEALTH.get() && offHand.m_41619_();
    }

    public static boolean isPlayerGotStealthInHand(Player player) {
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41720_() == ItemInit.GOBBER2_RING_STEALTH.get() && offHand.m_41619_();
    }

    public static boolean hasArrowInInventory(Player player) {
        Inventory inv = player.m_150109_();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (!(stack.m_41720_() instanceof ArrowItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemInInventory(Player player, Item item) {
        Inventory inv = player.m_150109_();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemInInventory(Player player, Item item) {
        Inventory inv = player.m_150109_();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41720_() != item) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasItemInEnderchest(Player player, Item item) {
        PlayerEnderChestContainer end_inv = player.m_36327_();
        for (int slot = 0; slot < end_inv.m_6643_(); ++slot) {
            ItemStack stack = end_inv.m_8020_(slot);
            if (stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemInEnderchest(Player player, Item item) {
        PlayerEnderChestContainer end_inv = player.m_36327_();
        for (int slot = 0; slot < end_inv.m_6643_(); ++slot) {
            ItemStack stack = end_inv.m_8020_(slot);
            if (stack.m_41720_() != item) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

