/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingDismissal
extends Item {
    double velocity = (Double)GobberConfigBuilder.RING_DISMISSAL_VELOCITY.get();
    double lift = (Double)GobberConfigBuilder.RING_DISMISSAL_LIFT.get();
    double range = (Double)GobberConfigBuilder.RING_DISMISSAL_RANGE.get();

    public ItemCustomRingDismissal(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player && !world.f_46443_) {
            Player player = (Player)entity;
            ItemStack equipped = player.m_21205_();
            if (!world.f_46443_ && stack == equipped) {
                double d1;
                double d0;
                double z;
                double y;
                Vec3 look = player.m_20154_().m_82541_();
                double lookX = look.m_7096_();
                double lookY = look.m_7098_();
                double lookZ = look.m_7094_();
                double x = player.m_20185_();
                Mob hostileMob = this.scanForHostileMobs(world, x, y = player.m_20186_(), z = player.m_20189_(), d0 = this.range, d1 = 4.0);
                if (hostileMob != null) {
                    hostileMob.m_5997_(lookX * this.velocity, lookY * this.lift, lookZ * this.velocity);
                }
            }
        }
    }

    private Mob scanForHostileMobs(Level world, double xpos, double ypos, double zpos, double d0, double d1) {
        List list = world.m_45976_(Mob.class, new AABB(xpos - d0, ypos - d1, zpos - d0, xpos + d0, ypos + d1, zpos + d0));
        Mob closestMob = null;
        for (Mob entitymob : list) {
            MobCategory isCreature = entitymob.getClassification(true);
            if (isCreature == MobCategory.CREATURE || entitymob instanceof Evoker || entitymob instanceof Guardian || entitymob instanceof Vex || entitymob instanceof Vindicator || entitymob instanceof WitherBoss || entitymob instanceof EnderDragon) continue;
            closestMob = entitymob;
            return closestMob;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.gobber2.gobber2_ring_dismissal.line1").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.gobber2.works_in_main_hand").m_130940_(ChatFormatting.YELLOW));
    }
}

