/*
 * Decompiled with CFR 0.152.
 */
package ihh.propertymodifier;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import ihh.propertymodifier.ConfigObject;
import ihh.propertymodifier.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class Config {
    static final ForgeConfigSpec SPEC;
    static final ForgeConfigSpec.BooleanValue LOG_SUCCESSFUL;
    static final ForgeConfigSpec.BooleanValue LOG_ERRORS;
    private static final ForgeConfigSpec.BooleanValue GENERATE_BLOCK_STATES;
    private static final ForgeConfigSpec.BooleanValue GENERATE_BLOCKS;
    private static final ForgeConfigSpec.BooleanValue GENERATE_ITEMS;
    private static final ForgeConfigSpec.BooleanValue GENERATE_ARMOR;
    private static final ForgeConfigSpec.BooleanValue GENERATE_TOOLS;
    private static final ForgeConfigSpec.BooleanValue GENERATE_ENCHANTMENTS;
    private static final ForgeConfigSpec.BooleanValue GENERATE_COMPOSTING;
    private static final ForgeConfigSpec.IntValue DEFAULT_ENCHANTMENT_VALUE;
    private static final ConfigObject<Map<String, Float>> DESTROY_TIME;
    private static final ConfigObject<Map<String, Boolean>> REQUIRES_TOOL;
    private static final ConfigObject<Map<String, Integer>> LIGHT_EMISSION;
    private static final ConfigObject<Map<String, Float>> EXPLOSION_RESISTANCE;
    private static final ConfigObject<Map<String, Float>> FRICTION;
    private static final ConfigObject<Map<String, Float>> SPEED_FACTOR;
    private static final ConfigObject<Map<String, Float>> JUMP_FACTOR;
    private static final ConfigObject<Map<String, Integer>> MAX_DAMAGE;
    private static final ConfigObject<Map<String, Integer>> MAX_STACK_SIZE;
    private static final ConfigObject<Map<String, Boolean>> FIRE_RESISTANT;
    private static final ConfigObject<Map<String, String>> RARITY;
    private static final ConfigObject<Map<String, Integer>> ENCHANTMENT_VALUE;
    private static final ConfigObject<Map<String, String>> REPAIR_MATERIAL;
    private static final ConfigObject<Map<String, Integer>> DEFENSE;
    private static final ConfigObject<Map<String, Float>> TOUGHNESS;
    private static final ConfigObject<Map<String, Float>> KNOCKBACK_RESISTANCE;
    private static final ConfigObject<Map<String, Float>> EFFICIENCY;
    private static final ConfigObject<Map<String, Float>> ATTACK_DAMAGE;
    private static final ConfigObject<Map<String, Float>> ATTACK_SPEED;
    private static final ConfigObject<Map<String, String>> ENCHANTMENT_RARITY;
    private static final ForgeConfigSpec.BooleanValue CLEAR_COMPOSTING;
    private static final ConfigObject<Map<String, Float>> COMPOSTING;
    static final ForgeConfigSpec.BooleanValue CLEAR_STRIPPING;
    private static final ConfigObject<Map<String, String>> STRIPPING;
    static final ForgeConfigSpec.BooleanValue CLEAR_FLATTENING;
    private static final ConfigObject<Map<String, String>> FLATTENING;
    static final ForgeConfigSpec.BooleanValue CLEAR_TILLING;
    private static final ConfigObject<Map<String, String>> TILLING;
    private static final ConfigObject<Map<String, Boolean>> TILLING_NEEDS_AIR;
    private static final ConfigObject<Map<String, ResourceLocation>> TILLING_ITEM_DROP;
    private static final ConfigObject<Map<String, String>> ATTRIBUTES;
    public static Map<BlockState, Float> DESTROY_TIME_STATES;
    public static Map<BlockState, Boolean> REQUIRES_TOOL_STATES;
    public static Map<BlockState, Integer> LIGHT_EMISSION_STATES;
    public static Map<Block, Float> DESTROY_TIME_BLOCKS;
    public static Map<Block, Boolean> REQUIRES_TOOL_BLOCKS;
    public static Map<Block, Integer> LIGHT_EMISSION_BLOCKS;
    public static Map<Item, Integer> ENCHANTMENT_VALUES;
    public static Map<Item, Lazy<Ingredient>> REPAIR_MATERIALS;
    static Map<Item, Multimap<Attribute, AttributeModifier>> MODIFIERS;
    static Map<Block, BlockState> AXE_STRIPPING;
    static Map<Block, BlockState> SHOVEL_FLATTENING;
    static Map<Block, Triple<BlockState, Boolean, Item>> HOE_TILLING;
    static Map<EntityType<?>, Map<Attribute, Double>> ENTITY_ATTRIBUTES;
    private static final AttributeModifier EMPTY_MODIFIER;
    private static boolean SEARCH_RELOAD;

    static void read() {
        Triple<Object, Object, Object> triple;
        DESTROY_TIME.get().forEach(Config.parseBlockStatesIntoMap(DESTROY_TIME_STATES, DESTROY_TIME_BLOCKS));
        DESTROY_TIME_STATES.keySet().stream().filter(e -> DESTROY_TIME_STATES.get(e).floatValue() < -1.0f).forEach(e -> {
            DESTROY_TIME_STATES.remove(e);
            Logger.error("Invalid destroy time value " + e);
        });
        DESTROY_TIME_BLOCKS.keySet().stream().filter(e -> DESTROY_TIME_BLOCKS.get(e).floatValue() < -1.0f).forEach(e -> {
            DESTROY_TIME_BLOCKS.remove(e);
            Logger.error("Invalid destroy time value " + e);
        });
        REQUIRES_TOOL.get().forEach(Config.parseBlockStatesIntoMap(REQUIRES_TOOL_STATES, REQUIRES_TOOL_BLOCKS));
        LIGHT_EMISSION.get().forEach(Config.parseBlockStatesIntoMap(LIGHT_EMISSION_STATES, LIGHT_EMISSION_BLOCKS));
        LIGHT_EMISSION_STATES.keySet().stream().filter(e -> LIGHT_EMISSION_STATES.get(e) < 0 || LIGHT_EMISSION_STATES.get(e) > 15).forEach(e -> {
            LIGHT_EMISSION_STATES.remove(e);
            Logger.error("Invalid light emission value " + e);
        });
        LIGHT_EMISSION_BLOCKS.keySet().stream().filter(e -> LIGHT_EMISSION_BLOCKS.get(e) < -1).forEach(e -> {
            LIGHT_EMISSION_BLOCKS.remove(e);
            Logger.error("Invalid light emission value " + e);
        });
        HashMap explosionResistance = new HashMap();
        EXPLOSION_RESISTANCE.get().forEach(Config.parseBlocksIntoMap(explosionResistance));
        for (Object block : explosionResistance.keySet()) {
            float value = ((Float)explosionResistance.get(block)).floatValue();
            if (value < 0.0f) {
                Logger.error("Invalid explosion resistance value " + value);
                continue;
            }
            ((Block)block).f_60444_ = value;
        }
        HashMap friction = new HashMap();
        FRICTION.get().forEach(Config.parseBlocksIntoMap(friction));
        for (Block block : friction.keySet()) {
            float value = ((Float)friction.get(block)).floatValue();
            if (value < 0.0f) {
                Logger.error("Invalid friction value " + value);
                continue;
            }
            block.f_60447_ = value;
        }
        HashMap speedFactor = new HashMap();
        SPEED_FACTOR.get().forEach(Config.parseBlocksIntoMap(speedFactor));
        for (Block block : speedFactor.keySet()) {
            float value = ((Float)speedFactor.get(block)).floatValue();
            if (value < 0.0f) {
                Logger.error("Invalid speed factor value " + value);
                continue;
            }
            block.f_60448_ = value;
        }
        HashMap jumpFactor = new HashMap();
        JUMP_FACTOR.get().forEach(Config.parseBlocksIntoMap(jumpFactor));
        for (Block block : jumpFactor.keySet()) {
            float value = ((Float)jumpFactor.get(block)).floatValue();
            if (value < 0.0f) {
                Logger.error("Invalid jump factor value " + value);
                continue;
            }
            block.f_60449_ = value;
        }
        HashMap maxDamage = new HashMap();
        MAX_DAMAGE.get().forEach(Config.parseItemsIntoMap(maxDamage));
        for (Item item : maxDamage.keySet()) {
            int value = (Integer)maxDamage.get(item);
            if (item.f_41371_ == 0) {
                Logger.error("Cannot set the max damage value for non-damageable item " + item);
                continue;
            }
            if (value < 0) {
                Logger.error("Invalid max damage value " + value);
                continue;
            }
            item.f_41371_ = value;
        }
        HashMap maxStackSize = new HashMap();
        MAX_STACK_SIZE.get().forEach(Config.parseItemsIntoMap(maxStackSize));
        for (Item item : maxStackSize.keySet()) {
            int value = (Integer)maxStackSize.get(item);
            if (item.f_41370_ == 1) {
                Logger.error("Cannot set the max stack size value for non-damageable item " + item);
                continue;
            }
            if (value < 1 || value > 64) {
                Logger.error("Invalid max stack size value " + value);
                continue;
            }
            item.f_41370_ = value;
        }
        HashMap<Item, Boolean> fireResistant = new HashMap<Item, Boolean>();
        FIRE_RESISTANT.get().forEach(Config.parseItemsIntoMap(fireResistant));
        fireResistant.forEach((k, v) -> {
            k.f_41372_ = v;
        });
        HashMap<Item, Rarity> rarity = new HashMap<Item, Rarity>();
        RARITY.get().forEach((k, v) -> {
            try {
                Rarity r = Rarity.valueOf((String)v.toUpperCase(Locale.ROOT));
                ForgeRegistries.ITEMS.getKeys().stream().filter(e -> e.toString().matches((String)k)).forEach(e -> rarity.put((Item)ForgeRegistries.ITEMS.getValue(e), r));
            }
            catch (IllegalArgumentException e2) {
                Logger.error("Could not find rarity " + v + " mentioned in entry \"" + k + "\" = " + v);
            }
        });
        rarity.forEach((k, v) -> {
            k.f_41369_ = v;
        });
        HashMap enchantmentValue = new HashMap();
        ENCHANTMENT_VALUE.get().forEach(Config.parseItemsIntoMap(enchantmentValue));
        for (Item item : enchantmentValue.keySet()) {
            int value = (Integer)enchantmentValue.get(item);
            if (value < 0) {
                Logger.error("Invalid enchantment value " + value);
                continue;
            }
            ENCHANTMENT_VALUES.put(item, value);
        }
        REPAIR_MATERIAL.get().forEach((k, v) -> ForgeRegistries.ITEMS.getKeys().stream().filter(e -> e.toString().matches((String)k)).forEach(e -> REPAIR_MATERIALS.put((Item)ForgeRegistries.ITEMS.getValue(e), (Lazy<Ingredient>)Lazy.of(() -> v.startsWith("#") ? Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(v.substring(1)))) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(v))})))));
        HashMap<ArmorItem, Triple<Object, Object, Object>> armor = new HashMap<ArmorItem, Triple<Object, Object, Object>>();
        HashMap defense = new HashMap();
        DEFENSE.get().forEach(Config.parseItemsIntoMap(defense));
        for (Object item : defense.keySet()) {
            int value = (Integer)defense.get(item);
            if (!(item instanceof ArmorItem)) {
                Logger.error((Item)item + " is not an armor item and thus cannot have its defense modified");
                continue;
            }
            if (value < 0) {
                Logger.error("Invalid defense value " + value);
                continue;
            }
            Triple<Object, Object, Object> triple2 = armor.getOrDefault(item, new Triple<Object, Object, Object>(null, null, null));
            triple2.a = value;
            armor.put((ArmorItem)item, triple2);
        }
        HashMap toughness = new HashMap();
        TOUGHNESS.get().forEach(Config.parseItemsIntoMap(toughness));
        for (Item item : toughness.keySet()) {
            float value = ((Float)toughness.get(item)).floatValue();
            if (!(item instanceof ArmorItem)) {
                Logger.error(item + " is not an armor item and thus cannot have its toughness modified");
                continue;
            }
            if (value < 0.0f) {
                Logger.error("Invalid toughness value " + value);
                continue;
            }
            Triple<Object, Object, Object> triple3 = armor.getOrDefault(item, new Triple<Object, Object, Object>(null, null, null));
            triple3.b = Float.valueOf(value);
            armor.put((ArmorItem)item, triple3);
        }
        HashMap knockbackResistance = new HashMap();
        KNOCKBACK_RESISTANCE.get().forEach(Config.parseItemsIntoMap(knockbackResistance));
        for (Item item : knockbackResistance.keySet()) {
            float value = ((Float)knockbackResistance.get(item)).floatValue();
            if (!(item instanceof ArmorItem)) {
                Logger.error(item + " is not an armor item and thus cannot have its knockback resistance modified");
                continue;
            }
            if (value < 0.0f) {
                Logger.error("Invalid knockback resistance value " + value);
                continue;
            }
            Triple<Object, Object, Object> triple4 = armor.getOrDefault(item, new Triple<Object, Object, Object>(null, null, null));
            triple4.c = Float.valueOf(value);
            armor.put((ArmorItem)item, triple4);
        }
        for (ArmorItem item : armor.keySet()) {
            Triple triple5 = (Triple)armor.get(item);
            if (triple5.a != null) {
                item.f_40381_ = (Integer)triple5.a;
            }
            if (triple5.b != null) {
                item.f_40382_ = ((Float)triple5.b).floatValue();
            }
            if (triple5.c != null) {
                item.f_40378_ = ((Float)triple5.c).floatValue();
            }
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Attribute attribute : item.f_40383_.keys()) {
                if (attribute == Attributes.f_22284_ || attribute == Attributes.f_22285_ || attribute == Attributes.f_22278_) continue;
                builder.putAll((Object)attribute, (Iterable)item.f_40383_.get((Object)attribute));
            }
            Pair<AttributeModifier, Double> oldDefense = Config.getAttributeValue(Attributes.f_22284_, (Multimap<Attribute, AttributeModifier>)item.f_40383_);
            Pair<AttributeModifier, Double> oldToughness = Config.getAttributeValue(Attributes.f_22285_, (Multimap<Attribute, AttributeModifier>)item.f_40383_);
            Pair<AttributeModifier, Double> oldKnockbackResistance = Config.getAttributeValue(Attributes.f_22278_, (Multimap<Attribute, AttributeModifier>)item.f_40383_);
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(((AttributeModifier)oldDefense.a).m_22209_(), ((AttributeModifier)oldDefense.a).m_22214_(), triple5.a != null ? (double)((Integer)triple5.a).intValue() : (Double)oldDefense.b, ((AttributeModifier)oldDefense.a).m_22217_()));
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(((AttributeModifier)oldToughness.a).m_22209_(), ((AttributeModifier)oldToughness.a).m_22214_(), triple5.b != null ? (double)((Float)triple5.b).floatValue() : (Double)oldToughness.b, ((AttributeModifier)oldToughness.a).m_22217_()));
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(((AttributeModifier)oldKnockbackResistance.a).m_22209_(), ((AttributeModifier)oldKnockbackResistance.a).m_22214_(), triple5.c != null ? (double)(((Float)triple5.c).floatValue() / 10.0f) : (Double)oldKnockbackResistance.b, ((AttributeModifier)oldKnockbackResistance.a).m_22217_()));
            item.f_40383_ = builder.build();
        }
        HashMap efficiency = new HashMap();
        EFFICIENCY.get().forEach(Config.parseItemsIntoMap(efficiency));
        for (Item item : efficiency.keySet()) {
            float value = ((Float)efficiency.get(item)).floatValue();
            if (!(item instanceof DiggerItem)) {
                Logger.error(item + " is not a tool item and thus cannot have its efficiency modified");
                continue;
            }
            if (value < 0.0f) {
                Logger.error("Invalid efficiency value " + value);
                continue;
            }
            ((DiggerItem)item).f_40980_ = value;
        }
        HashMap<Object, Pair<Object, Object>> weapons = new HashMap<Object, Pair<Object, Object>>();
        HashMap attackDamage = new HashMap();
        ATTACK_DAMAGE.get().forEach(Config.parseItemsIntoMap(attackDamage));
        for (Object item : attackDamage.keySet()) {
            float value = ((Float)attackDamage.get(item)).floatValue();
            if (value < 0.0f) {
                Logger.error("Invalid attack damage value " + value);
                continue;
            }
            Pair<Object, Object> pair = weapons.getOrDefault(item, new Pair<Object, Object>(null, null));
            pair.a = Float.valueOf(value);
            weapons.put(item, pair);
        }
        HashMap attackSpeed = new HashMap();
        ATTACK_SPEED.get().forEach(Config.parseItemsIntoMap(attackSpeed));
        for (Item item : attackSpeed.keySet()) {
            float value = ((Float)attackSpeed.get(item)).floatValue();
            if (value < 0.0f) {
                Logger.error("Invalid attack speed value " + value);
                continue;
            }
            Pair<Object, Object> pair = weapons.getOrDefault(item, new Pair<Object, Object>(null, null));
            pair.b = Float.valueOf(value);
            weapons.put(item, pair);
        }
        for (Item item : weapons.keySet()) {
            Float damage = (Float)((Pair)weapons.get((Object)item)).a;
            Float speed = (Float)((Pair)weapons.get((Object)item)).b;
            MODIFIERS.put(item, Config.createToolAttributes((Multimap<Attribute, AttributeModifier>)item.m_7167_(EquipmentSlot.MAINHAND), damage, speed));
            if (item instanceof DiggerItem) {
                DiggerItem digger = (DiggerItem)item;
                if (damage == null) continue;
                digger.f_40981_ = damage.floatValue();
                continue;
            }
            if (!(item instanceof SwordItem)) continue;
            SwordItem sword = (SwordItem)item;
            if (damage == null) continue;
            sword.f_43266_ = damage.floatValue();
        }
        HashMap<Enchantment, Enchantment.Rarity> enchantmentRarity = new HashMap<Enchantment, Enchantment.Rarity>();
        ENCHANTMENT_RARITY.get().forEach((k, v) -> {
            try {
                Enchantment.Rarity r = Enchantment.Rarity.valueOf((String)v.toUpperCase(Locale.ROOT));
                ForgeRegistries.ENCHANTMENTS.getKeys().stream().filter(e -> e.toString().matches((String)k)).forEach(e -> enchantmentRarity.put((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(e), r));
            }
            catch (IllegalArgumentException e2) {
                Logger.error("Could not find rarity " + v + " mentioned in entry \"" + k + "\" = " + v);
            }
        });
        enchantmentRarity.forEach((k, v) -> {
            k.f_44674_ = v;
        });
        if (((Boolean)CLEAR_COMPOSTING.get()).booleanValue()) {
            ComposterBlock.f_51914_.clear();
        }
        HashMap composting = new HashMap();
        COMPOSTING.get().forEach(Config.parseItemsIntoMap(composting));
        for (Object item : composting.keySet()) {
            float value = ((Float)composting.get(item)).floatValue();
            if (value < 0.0f || value > 1.0f) {
                Logger.error("Invalid composting value " + value);
                continue;
            }
            ComposterBlock.f_51914_.put(item, value);
        }
        HashMap stripping = new HashMap();
        STRIPPING.get().forEach(Config.parseBlocksIntoMap(stripping));
        for (Block block : stripping.keySet()) {
            String value = (String)stripping.get(block);
            try {
                AXE_STRIPPING.put(block, BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)value, (boolean)true).f_234748_());
            }
            catch (CommandSyntaxException e2) {
                Logger.error("Could not find block state " + value);
            }
        }
        HashMap flattening = new HashMap();
        FLATTENING.get().forEach(Config.parseBlocksIntoMap(flattening));
        for (Object block : flattening.keySet()) {
            String value = (String)flattening.get(block);
            try {
                SHOVEL_FLATTENING.put((Block)block, BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)value, (boolean)true).f_234748_());
            }
            catch (CommandSyntaxException e3) {
                Logger.error("Could not find block state " + value);
            }
        }
        HashMap tillingTemp = new HashMap();
        TILLING.get().forEach(Config.parseBlocksIntoMap(tillingTemp));
        for (Object block : tillingTemp.keySet()) {
            String value = (String)tillingTemp.get(block);
            triple = HOE_TILLING.getOrDefault(block, new Triple<Object, Object, Object>(null, null, null));
            try {
                triple.a = BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)value, (boolean)true).f_234748_();
                HOE_TILLING.put((Block)block, triple);
            }
            catch (CommandSyntaxException e4) {
                Logger.error("Could not find block state " + value);
            }
        }
        HashMap tillingNeedsAir = new HashMap();
        TILLING_NEEDS_AIR.get().forEach(Config.parseBlocksIntoMap(tillingNeedsAir));
        for (Block block : tillingNeedsAir.keySet()) {
            triple = HOE_TILLING.getOrDefault(block, new Triple<Object, Object, Object>(null, null, null));
            triple.b = tillingNeedsAir.get(block);
            HOE_TILLING.put(block, triple);
        }
        HashMap tillingItemDrop = new HashMap();
        TILLING_ITEM_DROP.get().forEach(Config.parseBlocksIntoMap(tillingItemDrop));
        for (Block block : tillingItemDrop.keySet()) {
            ResourceLocation value = (ResourceLocation)tillingItemDrop.get(block);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(value);
            if (item != null) {
                Triple<Object, Object, Object> triple6 = HOE_TILLING.getOrDefault(block, new Triple<Object, Object, Object>(null, null, null));
                triple6.c = item;
                HOE_TILLING.put(block, triple6);
                continue;
            }
            Logger.error("Could not find item " + value);
        }
        ATTRIBUTES.get().forEach((k, v) -> {
            List<EntityType> types = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(e -> Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(e)).toString().matches((String)k)).toList();
            if (types.isEmpty()) {
                Logger.error("Could not find entity type " + k);
                return;
            }
            String[] array = v.split(";");
            if (array.length != 2) {
                return;
            }
            List<Attribute> attributes = ForgeRegistries.ATTRIBUTES.getValues().stream().filter(e -> Objects.requireNonNull(ForgeRegistries.ATTRIBUTES.getKey(e)).toString().matches(array[0])).toList();
            if (attributes.isEmpty()) {
                Logger.error("Could not find attribute " + k);
                return;
            }
            try {
                double value = Double.parseDouble(array[1]);
                for (EntityType type : types) {
                    Map map = ENTITY_ATTRIBUTES.getOrDefault(type, new HashMap());
                    for (Attribute attribute : attributes) {
                        map.put(attribute, value);
                    }
                    ENTITY_ATTRIBUTES.put(type, map);
                }
            }
            catch (NumberFormatException e2) {
                Logger.error("Invalid attribute value " + array[1]);
            }
        });
        Config.generate();
    }

    static void searchReload() {
        if (SEARCH_RELOAD) {
            Minecraft.m_91087_().m_91271_();
        }
    }

    private static <T> BiConsumer<String, T> parseBlockStatesIntoMap(Map<BlockState, T> stateMap, Map<Block, T> blockMap) {
        return (k, v) -> {
            if (k.contains("[")) {
                try {
                    stateMap.put(BlockStateParser.m_245437_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (String)k, (boolean)true).f_234748_(), v);
                }
                catch (CommandSyntaxException e) {
                    Logger.error("Could not find block state " + k + " mentioned in entry \"" + k + "\" = " + v);
                }
            } else {
                Config.parseBlocksIntoMap(blockMap).accept((String)k, (String)v);
            }
        };
    }

    private static <T> BiConsumer<String, T> parseBlocksIntoMap(Map<Block, T> map) {
        return (k, v) -> ForgeRegistries.BLOCKS.getKeys().stream().filter(e -> e.toString().matches((String)k)).forEach(e -> map.put((Block)ForgeRegistries.BLOCKS.getValue(e), v));
    }

    private static <T> BiConsumer<String, T> parseItemsIntoMap(Map<Item, T> map) {
        return (k, v) -> ForgeRegistries.ITEMS.getKeys().stream().filter(e -> e.toString().matches((String)k)).forEach(e -> map.put((Item)ForgeRegistries.ITEMS.getValue(e), v));
    }

    private static Multimap<Attribute, AttributeModifier> createToolAttributes(Multimap<Attribute, AttributeModifier> map, Float damage, Float speed) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Attribute attribute : map.keys()) {
            if (attribute == Attributes.f_22281_ || attribute == Attributes.f_22283_) continue;
            builder.putAll((Object)attribute, (Iterable)map.get((Object)attribute));
        }
        Pair<AttributeModifier, Double> oldDamage = Config.getAttributeValue(Attributes.f_22281_, map);
        Pair<AttributeModifier, Double> oldSpeed = Config.getAttributeValue(Attributes.f_22283_, map);
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(((AttributeModifier)oldDamage.a).m_22209_(), ((AttributeModifier)oldDamage.a).m_22214_(), (damage != null ? (double)damage.floatValue() : (Double)oldDamage.b) - 1.0, ((AttributeModifier)oldDamage.a).m_22217_()));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(((AttributeModifier)oldSpeed.a).m_22209_(), ((AttributeModifier)oldSpeed.a).m_22214_(), (speed != null ? (double)speed.floatValue() : (Double)oldSpeed.b) - 4.0, ((AttributeModifier)oldSpeed.a).m_22217_()));
        return builder.build();
    }

    private static Pair<AttributeModifier, Double> getAttributeValue(Attribute attribute, Multimap<Attribute, AttributeModifier> map) {
        double base;
        Collection collection = map.get((Object)attribute);
        double result = base = attribute.m_22082_();
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            result += modifier.m_22218_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            result += base * modifier.m_22218_();
        }
        for (AttributeModifier modifier : collection) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            result *= modifier.m_22218_();
        }
        return new Pair<AttributeModifier, Double>(collection.stream().findFirst().orElse(EMPTY_MODIFIER), result);
    }

    private static void generate() {
        StringBuilder builder = new StringBuilder("# This config file is for getting default values, for use in propertymodifier-common.toml. It is NOT directly usable!\n");
        if (((Boolean)GENERATE_BLOCK_STATES.get()).booleanValue()) {
            builder.append("# Note: For blocks with multiple states, only the value of the default state is listed.\n[blocks_and_blockstates]\n");
            builder.append("    # If not listed, the value for a block is 0.\n    [blocks_and_blockstates.destroy_time]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                float destroySpeed = block.m_49966_().f_60599_;
                if (destroySpeed == 0.0f) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(destroySpeed).append("\n");
            }
            builder.append("    # If not listed, the value for a block is false.\n    [blocks_and_blockstates.requires_tool]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                boolean requiresTool = block.m_49966_().m_60834_();
                if (!requiresTool) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(true).append("\n");
            }
            builder.append("    # If not listed, the value for a block is 0.\n    [blocks_and_blockstates.light_emission]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                float lightEmission = block.m_49966_().f_60594_;
                if (lightEmission == 0.0f) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(lightEmission).append("\n");
            }
        }
        if (((Boolean)GENERATE_BLOCKS.get()).booleanValue()) {
            builder.append("[blocks]\n");
            builder.append("    # If not listed, the value for a block is 0.\n    [blocks.explosion_resistance]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                float explosionResistance = block.m_7325_();
                if (explosionResistance == 0.0f) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(explosionResistance).append("\n");
            }
            builder.append("    # If not listed, the value for a block is 0.6.\n    [blocks.friction]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                float friction = block.m_49958_();
                if (friction == 0.6f) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(friction).append("\n");
            }
            builder.append("    # If not listed, the value for a block is 1.\n    [blocks.speed_factor]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                float speedFactor = block.m_49961_();
                if (speedFactor == 1.0f) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(speedFactor).append("\n");
            }
            builder.append("    # If not listed, the value for a block is 1.\n    [blocks.jump_factor]\n");
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                float jumpFactor = block.m_49964_();
                if (jumpFactor == 1.0f) continue;
                builder.append("        \"").append(ForgeRegistries.BLOCKS.getKey((Object)block)).append("\" = ").append(jumpFactor).append("\n");
            }
        }
        if (((Boolean)GENERATE_ITEMS.get()).booleanValue()) {
            builder.append("# Note: Due to repair materials not being resolvable at the time this config is generated, it is impossible to list them.\n[items]\n");
            builder.append("    # If not listed, the value for an item is 0.\n    [items.max_damage]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                int maxDamage = item.m_41462_();
                if (maxDamage == 0) continue;
                builder.append("        \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(maxDamage).append("\n");
            }
            builder.append("    # If not listed, the value for an item is 64.\n    [items.max_stack_size]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                int maxStackSize = item.m_41459_();
                if (maxStackSize == 64) continue;
                builder.append("        \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(maxStackSize).append("\n");
            }
            builder.append("    # If not listed, the value for an item is false.\n    [items.fire_resistant]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                boolean fireResistant = item.m_41475_();
                if (!fireResistant) continue;
                builder.append("        \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(true).append("\n");
            }
            builder.append("    # If not listed, the value for an item is \"common\".\n    [items.rarity]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                Rarity rarity = item.f_41369_;
                if (rarity == Rarity.COMMON) continue;
                builder.append("        \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = \"").append(rarity.toString().toLowerCase(Locale.ROOT)).append("\"\n");
            }
            builder.append("    # If not listed, the value for an item is the value specified in default_enchantment_value.\n    [items.enchantment_value]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                int enchantmentValue = item.m_6473_();
                if (enchantmentValue == (Integer)DEFAULT_ENCHANTMENT_VALUE.get()) continue;
                builder.append("        \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(enchantmentValue).append("\n");
            }
        }
        if (((Boolean)GENERATE_ARMOR.get()).booleanValue()) {
            builder.append("    [items.armor]\n");
            builder.append("        # If not listed, the value for an item is 0.\n        [items.armor.defense]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ArmorItem armor;
                int defense;
                if (!(item instanceof ArmorItem) || (defense = (armor = (ArmorItem)item).m_40404_()) == 0) continue;
                builder.append("            \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(defense).append("\n");
            }
            builder.append("        # If not listed, the value for an item is 0.\n        [items.armor.toughness]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                ArmorItem armor;
                float toughness;
                if (!(item instanceof ArmorItem) || (toughness = (armor = (ArmorItem)item).m_40405_()) == 0.0f) continue;
                builder.append("            \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(toughness).append("\n");
            }
            builder.append("        # If not listed, the value for an item is 0.\n        [items.armor.knockback_resistance]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!(item instanceof ArmorItem)) continue;
                ArmorItem armor = (ArmorItem)item;
                float knockbackResistance = armor.f_40378_;
                if (knockbackResistance == 0.0f) continue;
                builder.append("            \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(knockbackResistance).append("\n");
            }
        }
        if (((Boolean)GENERATE_TOOLS.get()).booleanValue()) {
            SwordItem sword;
            DiggerItem digger;
            builder.append("    [items.tools]\n");
            builder.append("        # If not listed, the value for an item is 0.\n        [items.tools.efficiency]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!(item instanceof DiggerItem)) continue;
                DiggerItem digger2 = (DiggerItem)item;
                float efficiency = digger2.f_40980_;
                if (efficiency == 0.0f) continue;
                builder.append("            \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(efficiency).append("\n");
            }
            builder.append("        # If not listed, the value for an item is 0.\n        [items.tools.attack_damage]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                float damage;
                if (item instanceof DiggerItem) {
                    digger = (DiggerItem)item;
                    damage = ((Double)Config.getAttributeValue((Attribute)Attributes.f_22281_, (Multimap<Attribute, AttributeModifier>)digger.f_40982_).b).floatValue();
                } else if (item instanceof SwordItem) {
                    sword = (SwordItem)item;
                    damage = ((Double)Config.getAttributeValue((Attribute)Attributes.f_22281_, (Multimap<Attribute, AttributeModifier>)sword.f_43267_).b).floatValue();
                } else {
                    if (!(item instanceof TridentItem)) continue;
                    TridentItem trident = (TridentItem)item;
                    damage = ((Double)Config.getAttributeValue((Attribute)Attributes.f_22281_, (Multimap<Attribute, AttributeModifier>)trident.f_43379_).b).floatValue();
                }
                if (damage == 0.0f) continue;
                builder.append("            \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(damage).append("\n");
            }
            builder.append("        # If not listed, the value for an item is 0.\n        [items.tools.attack_speed]\n");
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                float speed;
                if (item instanceof DiggerItem) {
                    digger = (DiggerItem)item;
                    speed = ((Double)Config.getAttributeValue((Attribute)Attributes.f_22283_, (Multimap<Attribute, AttributeModifier>)digger.f_40982_).b).floatValue();
                } else if (item instanceof SwordItem) {
                    sword = (SwordItem)item;
                    speed = ((Double)Config.getAttributeValue((Attribute)Attributes.f_22283_, (Multimap<Attribute, AttributeModifier>)sword.f_43267_).b).floatValue();
                } else {
                    if (!(item instanceof TridentItem)) continue;
                    TridentItem trident = (TridentItem)item;
                    speed = ((Double)Config.getAttributeValue((Attribute)Attributes.f_22283_, (Multimap<Attribute, AttributeModifier>)trident.f_43379_).b).floatValue();
                }
                if (speed == 0.0f) continue;
                builder.append("            \"").append(ForgeRegistries.ITEMS.getKey((Object)item)).append("\" = ").append(speed).append("\n");
            }
        }
        if (((Boolean)GENERATE_ENCHANTMENTS.get()).booleanValue()) {
            builder.append("[enchantments]\n");
            builder.append("    # If not listed, the value for an enchantment is \"common\".\n    [enchantment.rarity]\n");
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
                Enchantment.Rarity rarity = enchantment.m_44699_();
                if (rarity == Enchantment.Rarity.COMMON) continue;
                builder.append("        \"").append(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment)).append("\" = \"").append(rarity.toString().toLowerCase(Locale.ROOT)).append("\"\n");
            }
        }
        if (((Boolean)GENERATE_COMPOSTING.get()).booleanValue()) {
            builder.append("[composting]\n");
            builder.append("    [composting.composting]\n");
            for (Item item : ComposterBlock.f_51914_.keySet()) {
                builder.append("        \"").append(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_())).append("\" = \"").append(ComposterBlock.f_51914_.getFloat((Object)item)).append("\"\n");
            }
        }
        builder.append("# Due to internal reasons, stripping, flattening, tilling and entity modifiers cannot be extracted.\n");
        File file = new File(FMLPaths.CONFIGDIR.get().toString() + File.separator + "propertymodifier_generated.toml");
        if (!file.exists()) {
            try {
                file.createNewFile();
                if (!file.exists() || file.isDirectory() || !file.canWrite()) {
                    Logger.error("Could not write default config!");
                    return;
                }
            }
            catch (IOException e) {
                Logger.error("Could not write default config!");
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(builder.toString());
        }
        catch (IOException e) {
            Logger.error("Could not write default config!");
        }
    }

    static {
        DESTROY_TIME_STATES = new HashMap<BlockState, Float>();
        REQUIRES_TOOL_STATES = new HashMap<BlockState, Boolean>();
        LIGHT_EMISSION_STATES = new HashMap<BlockState, Integer>();
        DESTROY_TIME_BLOCKS = new HashMap<Block, Float>();
        REQUIRES_TOOL_BLOCKS = new HashMap<Block, Boolean>();
        LIGHT_EMISSION_BLOCKS = new HashMap<Block, Integer>();
        ENCHANTMENT_VALUES = new HashMap<Item, Integer>();
        REPAIR_MATERIALS = new HashMap<Item, Lazy<Ingredient>>();
        MODIFIERS = new HashMap<Item, Multimap<Attribute, AttributeModifier>>();
        AXE_STRIPPING = new HashMap<Block, BlockState>();
        SHOVEL_FLATTENING = new HashMap<Block, BlockState>();
        HOE_TILLING = new HashMap<Block, Triple<BlockState, Boolean, Item>>();
        ENTITY_ATTRIBUTES = new HashMap();
        EMPTY_MODIFIER = new AttributeModifier("Property Modifier empty modifier", 0.0, AttributeModifier.Operation.ADDITION);
        SEARCH_RELOAD = false;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("logging");
        LOG_SUCCESSFUL = builder.comment("Whether to log successful operations or not.").define("log_successful", false);
        LOG_ERRORS = builder.comment("Whether to log failed operations or not.").define("log_errors", true);
        builder.pop();
        builder.comment("Generates a config with all non-default values in propertymodifier-generated.toml.").push("generating");
        GENERATE_BLOCK_STATES = builder.comment("Generates block state-related entries.").define("block_states", false);
        GENERATE_BLOCKS = builder.comment("Generates block-related entries.").define("blocks", false);
        GENERATE_ITEMS = builder.comment("Generates item-related entries.").define("items", false);
        GENERATE_ARMOR = builder.comment("Generates armor-related entries.").define("armor", false);
        GENERATE_TOOLS = builder.comment("Generates tool-related entries.").define("tools", false);
        GENERATE_ENCHANTMENTS = builder.comment("Generates enchantment-related entries.").define("enchantments", false);
        GENERATE_COMPOSTING = builder.comment("Generates composting-related entries.").define("composting", false);
        DEFAULT_ENCHANTMENT_VALUE = builder.comment("The default enchantment value used. 0 in vanilla, but mods such as Apotheosis may change this.").defineInRange("default_enchantment_value", 0, 0, 1000000);
        builder.pop();
        builder.comment("Set the respective values here by adding lines in the respective groups. Keys can be either a block (e.g. \"minecraft:stripped_birch_wood\"), a block regex (e.g. \"minecraft:.*_block\") or a blockstate definition (e.g. \"minecraft:grass_block[snowy=true]\"). Block regexes cannot contain the [] characters, as their presence will be interpreted as a blockstate definition instead.").push("blocks_and_blockstates");
        DESTROY_TIME = ConfigObject.of(builder.comment(new String[]{"Set the destroy time for a block (state). Dirt has 0.5, stone has 1.5, obsidian has 50. -1 makes the block unbreakable. Examples (without the leading #):", "\"minecraft:grass_block[snowy=true]\" = 100", "\"minecraft:.*_planks\" = 100"}), "destroy_time", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        REQUIRES_TOOL = ConfigObject.of(builder.comment(new String[]{"Set the tool requirement of a block (state). Must be true or false. Examples (without the leading #):", "\"minecraft:diamond_ore\" = false", "\"minecraft:oak_log\" = true"}), "requires_tool", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL), Map.of("test", false));
        LIGHT_EMISSION = ConfigObject.of(builder.comment(new String[]{"Set the light emission of a block (state). Must be an integer between 0 and 15. Examples (without the leading #):", "\"minecraft:redstone_torch[lit=true]\" = 15", "\"minecraft:.*_bricks\" = 7"}), "light_emission", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT), Map.of("test", 0));
        builder.pop();
        builder.comment("Set the respective values here by adding lines in the respective groups. Keys can be either a block (e.g. \"minecraft:stripped_birch_wood\") or a block regex (e.g. \"minecraft:.*_block\").").push("blocks");
        EXPLOSION_RESISTANCE = ConfigObject.of(builder.comment(new String[]{"Set the explosion resistance for a block. Dirt has 0.5, stone and has 6, obsidian has 1200. 3600000 or more makes the block completely explosion resistant. Example (without the leading #):", "\"minecraft:dirt\" = 1000"}), "explosion_resistance", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        FRICTION = ConfigObject.of(builder.comment(new String[]{"Set the friction for a block. 0.6 for most blocks, 0.8 for slime blocks, 0.98 for ice, packed ice and frosted ice, and 0.989 for blue ice. Example (without the leading #):", "\"minecraft:.*ice\" = 0.6"}), "friction", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        SPEED_FACTOR = ConfigObject.of(builder.comment(new String[]{"Set the speed factor for a block. 1 for most blocks, 0.4 for soul sand and honey blocks. Example (without the leading #):", "\"minecraft:soul_sand\" = 1"}), "speed_factor", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        JUMP_FACTOR = ConfigObject.of(builder.comment(new String[]{"Set the speed factor for a block. 1 for most blocks, 0.5 for honey blocks. Example (without the leading #):", "\"minecraft:honey_block\" = 1"}), "jump_factor", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        builder.pop();
        builder.comment("Set the respective values here by adding lines in the respective groups. Keys can be either an item (e.g. \"minecraft:stripped_birch_wood\") or an item regex (e.g. \"minecraft:diamond.*\").").push("items");
        MAX_DAMAGE = ConfigObject.of(builder.comment(new String[]{"Set the max damage (durability) of an item. Only items that already have durability can have this value altered. Example (without the leading #):", "\"minecraft:diamond_.*\" = 5000"}), "max_damage", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT), Map.of("test", 0));
        MAX_STACK_SIZE = ConfigObject.of(builder.comment(new String[]{"Set the max stack size of an item. Only values between 2 and 64 are supported. Items that have durability cannot have this value altered. Example (without the leading #):", "\"minecraft:ender_pearl\" = 64"}), "max_stack_size", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT), Map.of("test", 0));
        FIRE_RESISTANT = ConfigObject.of(builder.comment(new String[]{"Set this value to true to make an item fire resistant (like netherite is), or set it to false to make it burn in fire and lava. Example (without the leading #):", "\"minecraft:netherite_ingot\" = false"}), "fire_resistant", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL), Map.of("test", false));
        RARITY = ConfigObject.of(builder.comment(new String[]{"Set the rarity (item color) of an item. Must be a valid rarity name. Example (without the leading #):", "\"minecraft:beacon\" = \"common\"", "Default rarities (mods may add more!): \"common\", \"uncommon\", \"rare\", \"epic\""}), "rarity", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        ENCHANTMENT_VALUE = ConfigObject.of(builder.comment(new String[]{"Set the enchantment value of an item. Higher value means better enchantments on average. May not always have a noticeable effect. Example (without the leading #):", "\"minecraft:.*_hoe\" = 40"}), "enchantment_value", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT), Map.of("test", 0));
        REPAIR_MATERIAL = ConfigObject.of(builder.comment(new String[]{"Set the repair material of an item. May be an item or a tag containing multiple items, with a # before the tag id. Example (without the leading #):", "\"minecraft:wooden_.*\" = \"#minecraft:fishes\""}), "repair_material", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        builder.comment("Set the values for armor.").push("armor");
        DEFENSE = ConfigObject.of(builder.comment(new String[]{"Set the defense value of an armor item. May not work on modded armors, please file an issue if that's the case. Example (without the leading #):", "\"minecraft:golden_chestplate\" = 10"}), "defense", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT), Map.of("test", 0));
        TOUGHNESS = ConfigObject.of(builder.comment(new String[]{"Set the toughness value of an armor item. May not work on modded armors, please file an issue if that's the case. Example (without the leading #):", "\"minecraft:golden_boots\" = 1"}), "toughness", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        KNOCKBACK_RESISTANCE = ConfigObject.of(builder.comment(new String[]{"Set the knockback resistance of an armor item. May not work on modded armors, please file an issue if that's the case. Example (without the leading #):", "\"minecraft:golden_leggings\" = 0.1"}), "knockback_resistance", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        builder.pop();
        builder.comment("Set the values for tools, swords and tridents.").push("tools");
        EFFICIENCY = ConfigObject.of(builder.comment(new String[]{"Set the efficiency value of a tool. May not work on modded tools, please file an issue if that's the case. Also doesn't work on shears, due to internal problems with that. Example (without the leading #):", "\"minecraft:iron_pickaxe\" = 16"}), "efficiency", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        ATTACK_DAMAGE = ConfigObject.of(builder.comment(new String[]{"Set the attack damage of a tool or weapon. May not work on modded tools, please file an issue if that's the case. Example (without the leading #):", "\"minecraft:netherite_sword\" = 12"}), "attack_damage", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        ATTACK_SPEED = ConfigObject.of(builder.comment(new String[]{"Set the attack speed of a tool or weapon. May not work on modded tools, please file an issue if that's the case. Example (without the leading #):", "\"minecraft:netherite_pickaxe\" = 2.5"}), "attack_speed", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        builder.pop();
        builder.pop();
        builder.comment("Set the values for enchantments.").push("enchantments");
        ENCHANTMENT_RARITY = ConfigObject.of(builder.comment(new String[]{"Set the rarity of an enchantment. Must be a valid rarity name. Example (without the leading #):", "\"minecraft:mending\" = \"common\"", "Default rarities (mods may add more!): \"common\", \"uncommon\", \"rare\", \"very_rare\""}), "rarity", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        builder.pop();
        builder.comment("Add or remove compostables.").push("composting");
        CLEAR_COMPOSTING = builder.comment("Whether to remove all predefined compostables or not.").define("clear", false);
        COMPOSTING = ConfigObject.of(builder.comment(new String[]{"Add new compostables here. Consists of an item or item regex and a float between 0 and 1, representing the chance that the composter level is increased. Example (without the leading #):", "\"minecraft:netherite_scrap\" = 0.8"}), "composting", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.FLOAT), Map.of("test", Float.valueOf(0.0f)));
        builder.pop();
        builder.comment("Set the values for axe stripping.").push("stripping");
        CLEAR_STRIPPING = builder.comment("Whether to remove all predefined stripping values or not.").define("clear", false);
        STRIPPING = ConfigObject.of(builder.comment(new String[]{"Add new stripping transitions here. Consists of a block or block regex and a block or block state, representing the output. Example (without the leading #):", "\"minecraft:.*_planks\" = \"minecraft:infested_cobblestone\""}), "stripping", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        builder.pop();
        builder.comment("Set the values for shovel flattening.").push("flattening");
        CLEAR_FLATTENING = builder.comment("Whether to remove all predefined flattening values or not.").define("clear", false);
        FLATTENING = ConfigObject.of(builder.comment(new String[]{"Add new flattening transitions here. Consists of a block or block regex and a block or block state, representing the output. Example (without the leading #):", "\"minecraft:.*_planks\" = \"minecraft:infested_cobblestone\""}), "flattening", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        builder.pop();
        builder.comment("Set the values for hoe tilling.").push("tilling");
        CLEAR_TILLING = builder.comment("Whether to remove all predefined tilling values or not.").define("clear", false);
        TILLING = ConfigObject.of(builder.comment(new String[]{"Add new tilling transitions here. Consists of a block or block regex and a block or block state, representing the output. Example (without the leading #):", "\"minecraft:diamond_block\" = \"minecraft:emerald_block\""}), "tilling", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        TILLING_NEEDS_AIR = ConfigObject.of(builder.comment(new String[]{"Whether a certain tilling transition needs air above to work. Consists of a block or block regex and a boolean value (true or false). If left unspecified, true is assumed. Example (without the leading #):", "\"minecraft:diamond_block\" = false"}), "needs_air", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL), Map.of("test", false));
        TILLING_ITEM_DROP = ConfigObject.of(builder.comment(new String[]{"The item that is dropped when tilling. Consists of a block or block regex and an item id. If left unspecified, no item is dropped. Example (without the leading #):", "\"minecraft:diamond_block\" = \"minecraft:iron_nugget\""}), "item_drop", Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_), Map.of("test", new ResourceLocation("missingno")));
        builder.pop();
        builder.comment("Set the values for entities.").push("entities");
        ATTRIBUTES = ConfigObject.of(builder.comment(new String[]{"Set the default attributes for entities. Format is \"entityid\" = \"attributeid;value\". Cannot add new attributes to mobs, can only alter those that are present by default anyway. Example (without the leading #):", "\"minecraft:zombie\" = \"minecraft:generic.attack_damage;10\""}), "default_attributes", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), Map.of("test", ""));
        builder.pop();
        SPEC = builder.build();
    }

    static class Triple<A, B, C> {
        public A a;
        public B b;
        public C c;

        public Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }
    }

    static class Pair<A, B> {
        public A a;
        public B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

