/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util.surroundings;

import com.github.leawind.util.math.LMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3i;

public class Surroundings {
    private static final Pattern BLANK_PATTERN = Pattern.compile("[\\s\\n|]");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[\\s\\n|]+");
    private final Map<String, List<Vector3i>> identifierMap = new HashMap<String, List<Vector3i>>();
    private final Map<String, Matches> matchesMap = new HashMap<String, Matches>();

    public Surroundings(String expr) {
        String[] tokens = SEPARATOR_PATTERN.split(BLANK_PATTERN.matcher(expr).replaceAll(" ").trim());
        for (int i = 0; i < tokens.length; ++i) {
            List<Object> offsets;
            String word = tokens[i];
            if (this.identifierMap.containsKey(word)) {
                offsets = this.identifierMap.get(word);
            } else {
                offsets = new ArrayList(27);
                this.identifierMap.put(word, offsets);
            }
            int ix = i % 3;
            int iy = i / 3 % 3;
            int iz = i / 9;
            offsets.add(new Vector3i(ix - 1, iy - 1, iz - 1));
        }
    }

    public void clear() {
        this.matchesMap.clear();
    }

    public void rematch(BlockPos center, BlockGetter level, Predicate<BlockState> predicate) {
        this.clear();
        this.match(center, level, predicate);
    }

    public void match(BlockPos center, BlockGetter level, Predicate<BlockState> predicate) {
        for (String identifier : this.getIdentifiers()) {
            Matches seq = new Matches(this.getOffsets(identifier), center, level);
            this.matchesMap.put(identifier, seq);
        }
        for (Matches seq : this.matchesMap.values()) {
            seq.apply(predicate);
        }
    }

    public Matches getMatches(String identifier) {
        if (!this.matchesMap.containsKey(identifier)) {
            throw new IllegalArgumentException("Unknown identifier: " + identifier);
        }
        return this.matchesMap.get(identifier);
    }

    public Set<String> getIdentifiers() {
        return this.identifierMap.keySet();
    }

    public List<Vector3i> getOffsets(String identifier) {
        if (!this.identifierMap.containsKey(identifier)) {
            throw new IllegalStateException("Unknown identifier: " + identifier);
        }
        return this.identifierMap.get(identifier);
    }

    public static class Matches {
        private final BlockState[] blockStates;
        private final Vector3i[] offsets;
        private final boolean[] states;
        private boolean isApplied = false;

        private Matches(List<Vector3i> offsets, BlockPos center, BlockGetter level) {
            this.blockStates = new BlockState[offsets.size()];
            this.states = new boolean[offsets.size()];
            this.offsets = new Vector3i[offsets.size()];
            offsets.toArray(this.offsets);
            for (int i = 0; i < this.blockStates.length; ++i) {
                Vector3i offset = offsets.get(i);
                BlockPos pos = center.m_121955_(LMath.toVec3i(offset));
                this.blockStates[i] = level.m_8055_(pos);
            }
        }

        public void apply(Predicate<BlockState> predicate) {
            for (int i = 0; i < this.blockStates.length; ++i) {
                this.states[i] = predicate.test(this.blockStates[i]);
            }
            this.isApplied = true;
        }

        public boolean all() {
            if (!this.isApplied) {
                throw new IllegalStateException("No predicate applied yet");
            }
            for (boolean s : this.states) {
                if (s) continue;
                return false;
            }
            return true;
        }

        public boolean all(Predicate<BlockState> predicate) {
            for (BlockState blockState : this.blockStates) {
                if (predicate.test(blockState)) continue;
                return false;
            }
            return true;
        }

        public boolean any() {
            if (!this.isApplied) {
                throw new IllegalStateException("No predicate applied yet");
            }
            for (boolean s : this.states) {
                if (s) continue;
                return true;
            }
            return false;
        }

        public boolean any(Predicate<BlockState> predicate) {
            for (BlockState blockState : this.blockStates) {
                if (!predicate.test(blockState)) continue;
                return true;
            }
            return false;
        }

        public int count() {
            int sum = 0;
            for (boolean s : this.states) {
                if (!s) continue;
                ++sum;
            }
            return sum;
        }

        public int count(Predicate<BlockState> predicate) {
            int sum = 0;
            for (BlockState state : this.blockStates) {
                if (!predicate.test(state)) continue;
                ++sum;
            }
            return sum;
        }

        public boolean has(Vector3i v) {
            for (Vector3i offset : this.offsets) {
                if (!offset.equals((Object)v)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("SurroundingPattern:\n");
            for (int z = 0; z < 3; ++z) {
                s.append("  | ");
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        Vector3i v = new Vector3i(x, y, z);
                        if (this.has(v)) {
                            s.append('#').append(' ');
                            continue;
                        }
                        s.append("  ");
                    }
                    s.append("| ");
                }
                s.append("\n");
            }
            return s.toString();
        }
    }
}

