/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util.math.smoothvalue;

import com.github.leawind.util.math.LMath;
import com.github.leawind.util.math.smoothvalue.ExpSmoothValue;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ExpSmoothVector3d
extends ExpSmoothValue<Vector3d> {
    public ExpSmoothVector3d() {
        super(new Vector3d(0.0), new Vector3d(1.0), new Vector3d(0.0), new Vector3d(0.0), new Vector3d(0.0));
    }

    public void setTarget(double x, double y, double z) {
        ((Vector3d)this.target).set(x, y, z);
    }

    public void setValue(double x, double y, double z) {
        ((Vector3d)this.value).set(x, y, z);
    }

    @Override
    public void setTarget(@NotNull Vector3d target) {
        ((Vector3d)this.target).set((Vector3dc)target);
    }

    @Override
    @NotNull
    public Vector3d get(double t) {
        return new Vector3d((Vector3dc)this.lastValue).lerp((Vector3dc)this.value, t);
    }

    @Override
    protected void saveLastValue() {
        ((Vector3d)this.lastValue).set((Vector3dc)this.value);
    }

    @Override
    protected void updateWithOutSavingLastValue(double period) {
        Vector3d t = LMath.pow(new Vector3d((Vector3dc)this.smoothFactor), new Vector3d((Vector3dc)this.smoothFactorWeight).mul(period)).negate().add(1.0, 1.0, 1.0);
        LMath.lerp((Vector3d)this.value, (Vector3d)this.target, t);
    }

    @Override
    public void setValue(@NotNull Vector3d v) {
        ((Vector3d)this.value).set((Vector3dc)v);
    }

    @Override
    public void set(@NotNull Vector3d v) {
        ((Vector3d)this.value).set((Vector3dc)v);
        ((Vector3d)this.target).set((Vector3dc)v);
    }

    @Override
    public void setSmoothFactor(@NotNull Vector3d smoothFactor) {
        ((Vector3d)this.smoothFactor).set((Vector3dc)smoothFactor);
    }

    @Override
    public void setSmoothFactor(double d) {
        this.setSmoothFactor(d, d, d);
    }

    @Override
    public void setMT(@NotNull Vector3d multiplier, @NotNull Vector3d time) {
        if (multiplier.x < 0.0 || multiplier.x > 1.0) {
            throw new IllegalArgumentException("Multiplier.x should in [0,1]: " + multiplier.x);
        }
        if (multiplier.y < 0.0 || multiplier.y > 1.0) {
            throw new IllegalArgumentException("Multiplier.y should in [0,1]: " + multiplier.y);
        }
        if (multiplier.z < 0.0 || multiplier.z > 1.0) {
            throw new IllegalArgumentException("Multiplier.z should in [0,1]: " + multiplier.z);
        }
        if (time.x < 0.0 || time.y < 0.0 || time.z < 0.0) {
            throw new IllegalArgumentException("Invalid time, non-negative required, but got " + time);
        }
        ((Vector3d)this.smoothFactor).set(time.x == 0.0 ? 0.0 : Math.pow(multiplier.x, 1.0 / time.x), time.y == 0.0 ? 0.0 : Math.pow(multiplier.y, 1.0 / time.y), time.z == 0.0 ? 0.0 : Math.pow(multiplier.z, 1.0 / time.z));
    }

    @Override
    public void setHalflife(@NotNull Vector3d halflife) {
        this.setMT(new Vector3d(0.5), halflife);
    }

    @Override
    public void setHalflife(double halflife) {
        this.setMT(new Vector3d(0.5), new Vector3d(halflife));
    }

    private void setSmoothFactor(double x, double y, double z) {
        ((Vector3d)this.smoothFactor).set(x, y, z);
    }

    public void setSmoothFactorWeight(double x, double y, double z) {
        ((Vector3d)this.smoothFactorWeight).set(x, y, z);
    }
}

