/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util.math.smoothvalue;

import com.github.leawind.util.math.LMath;
import com.github.leawind.util.math.smoothvalue.ExpSmoothValue;
import org.jetbrains.annotations.NotNull;

public class ExpSmoothDouble
extends ExpSmoothValue<Double> {
    @NotNull
    public static ExpSmoothDouble createWithHalflife(double halflife) {
        ExpSmoothDouble v = new ExpSmoothDouble();
        v.setHalflife(halflife);
        return v;
    }

    public ExpSmoothDouble() {
        super(0.0, 1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void setTarget(double target) {
        this.target = target;
    }

    @Override
    public void setTarget(@NotNull Double target) {
        this.target = target;
    }

    @Override
    @NotNull
    public Double get(double t) {
        return LMath.lerp((Double)this.lastValue, (Double)this.value, t);
    }

    @Override
    protected void saveLastValue() {
        this.lastValue = this.value;
    }

    @Override
    protected void updateWithOutSavingLastValue(double period) {
        this.value = LMath.lerp((Double)this.value, (Double)this.target, 1.0 - Math.pow((Double)this.smoothFactor, (Double)this.smoothFactorWeight * period));
    }

    @Override
    public void setValue(@NotNull Double d) {
        this.value = d;
    }

    @Override
    public void set(@NotNull Double d) {
        this.value = this.target = d;
    }

    @Override
    public void setSmoothFactor(@NotNull Double smoothFactor) {
        this.smoothFactor = smoothFactor;
    }

    @Override
    public void setSmoothFactor(double smoothFactor) {
        this.smoothFactor = smoothFactor;
    }

    @Override
    public void setMT(@NotNull Double multiplier, @NotNull Double time) {
        if (multiplier < 0.0 || multiplier > 1.0) {
            throw new IllegalArgumentException("Multiplier should in [0,1]: " + multiplier);
        }
        if (time < 0.0) {
            throw new IllegalArgumentException("Invalid time, non-negative required, but got " + time);
        }
        this.setSmoothFactor(time == 0.0 ? 0.0 : Math.pow(multiplier, 1.0 / time));
    }

    @Override
    public void setHalflife(@NotNull Double halflife) {
        this.setMT(0.5, halflife);
    }

    @Override
    public void setHalflife(double halflife) {
        this.setMT(0.5, halflife);
    }

    public void setSmoothFactorWeight(double weight) {
        this.smoothFactorWeight = weight;
    }

    @Override
    public void setValue(double d) {
        this.value = d;
    }
}

