/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util.math.smoothvalue;

import com.github.leawind.util.math.LMath;
import com.github.leawind.util.math.smoothvalue.ExpSmoothDouble;
import org.jetbrains.annotations.NotNull;

public class ExpRotSmoothDouble
extends ExpSmoothDouble {
    private double cycle;

    @NotNull
    public static ExpRotSmoothDouble createWithHalflife(double cycle, double halflife) {
        ExpRotSmoothDouble v = new ExpRotSmoothDouble(cycle);
        v.setHalflife(halflife);
        return v;
    }

    public ExpRotSmoothDouble(double cycle) {
        this.setCycle(cycle);
    }

    public double getCycle() {
        return this.cycle;
    }

    public void setCycle(double cycle) {
        this.cycle = cycle;
    }

    @Override
    public void setTarget(double d) {
        super.setTarget(LMath.floorMod(d, this.cycle));
    }

    @Override
    @NotNull
    public Double get(double t) {
        this.lastValue = LMath.floorMod((Double)this.lastValue, this.cycle);
        this.value = LMath.floorMod((Double)this.value, this.cycle);
        double delta = LMath.floorMod((Double)this.value - (Double)this.lastValue, this.cycle);
        if (delta > this.cycle / 2.0) {
            delta -= this.cycle;
        }
        this.value = (Double)this.lastValue + delta;
        return LMath.lerp((Double)this.lastValue, (Double)this.value, t);
    }

    @Override
    protected void updateWithOutSavingLastValue(double period) {
        this.value = LMath.floorMod((Double)this.value, this.cycle);
        this.target = LMath.floorMod((Double)this.target, this.cycle);
        double delta = LMath.floorMod((Double)this.target - (Double)this.value, this.cycle);
        if (delta > this.cycle / 2.0) {
            delta -= this.cycle;
        }
        this.target = (Double)this.value + delta;
        this.value = LMath.lerp((Double)this.value, (Double)this.target, 1.0 - Math.pow((Double)this.smoothFactor, (Double)this.smoothFactorWeight * period));
    }

    @Override
    public void set(@NotNull Double d) {
        d = LMath.floorMod(d, this.cycle);
        super.set(d);
    }

    @Override
    public void setHalflife(double halflife) {
        super.setHalflife(halflife);
    }

    @Override
    public void setValue(double d) {
        d = LMath.floorMod(d, this.cycle);
        super.setValue(d);
    }
}

