/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.util;

import org.jetbrains.annotations.NotNull;

public class Zone {
    public final double min;
    public final double max;

    @NotNull
    public static Zone of(double min, double max) throws IllegalArgumentException {
        return new Zone(min, max);
    }

    @NotNull
    public static Zone ofAuto(double a, double b) {
        return a < b ? new Zone(a, b) : new Zone(b, a);
    }

    @NotNull
    public static Zone ofRadius(double center, double radius) throws IllegalArgumentException {
        return new Zone(center - radius, center + radius);
    }

    @NotNull
    public static Zone ofLength(double center, double length) throws IllegalArgumentException {
        return new Zone(center - length / 2.0, center + length / 2.0);
    }

    public Zone(double min, double max) throws IllegalArgumentException {
        if (min > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum: " + min + " > " + max);
        }
        this.min = min;
        this.max = max;
    }

    public double radius() {
        return (this.max - this.min) / 2.0;
    }

    public String toString() {
        return "Zone[" + this.min + ", " + this.max + "]";
    }

    @NotNull
    public Zone scale(double scale) {
        return Zone.ofLength(this.center(), this.length() * scale);
    }

    public double center() {
        return (this.min + this.max) / 2.0;
    }

    public double length() {
        return this.max - this.min;
    }

    @NotNull
    public Zone intersection(@NotNull Zone zone) throws IllegalArgumentException {
        return new Zone(Math.max(this.min, zone.min), Math.min(this.max, zone.max));
    }

    @NotNull
    public Zone union(@NotNull Zone zone) {
        if (!this.hasIntersection(zone)) {
            throw new IllegalArgumentException("Zones do not intersect");
        }
        return new Zone(Math.min(this.min, zone.min), Math.max(this.max, zone.max));
    }

    @NotNull
    public Zone expendRadius(double d) throws IllegalArgumentException {
        if (d < 0.0) {
            throw new IllegalArgumentException("Expected non-negative, got " + d);
        }
        return new Zone(this.min - d, this.max + d);
    }

    @NotNull
    public Zone expend(double a, double b) {
        if (a < 0.0 || b < 0.0) {
            throw new IllegalArgumentException("Expected non-negative, got (" + a + ", " + b + ")");
        }
        return new Zone(this.min - a, this.max + b);
    }

    @NotNull
    public Zone squeeze(double d) throws IllegalArgumentException {
        if (d > this.radius()) {
            throw new IllegalArgumentException("Squeeze too much!");
        }
        return new Zone(this.min + d, this.max - d);
    }

    @NotNull
    public Zone squeezeSafely(double d) {
        double r = Math.min(d, this.radius());
        return Zone.ofAuto(this.min + r, this.max - r);
    }

    public boolean hasIntersection(@NotNull Zone zone) {
        return this.min <= zone.max && zone.min <= this.max;
    }

    @NotNull
    public Zone move(double offset) {
        return new Zone(this.min + offset, this.max + offset);
    }

    public boolean lessThan(@NotNull Zone zone) {
        return this.max <= zone.min;
    }

    public boolean greaterThan(@NotNull Zone zone) {
        return this.min >= zone.max;
    }

    @NotNull
    public Zone lessNeighbor(double length) throws IllegalArgumentException {
        if (length < 0.0) {
            throw new IllegalArgumentException("Length must be non-negative, not " + length);
        }
        return new Zone(this.min - length, this.min);
    }

    @NotNull
    public Zone greaterNeighbor(double length) throws IllegalArgumentException {
        if (length < 0.0) {
            throw new IllegalArgumentException("Length must be non-negative, not " + length);
        }
        return new Zone(this.max, this.max + length);
    }

    public double nearest(double value) {
        return Math.min(Math.max(value, this.min), this.max);
    }

    public double furthest(double value) {
        return value <= this.center() ? this.max : this.min;
    }

    public double distance(double value) {
        return value < this.min ? this.min - value : (value > this.max ? value - this.max : 0.0);
    }

    public boolean in(@NotNull Zone zone) {
        return zone.min <= this.min && this.max <= zone.max;
    }

    public boolean contains(@NotNull Zone zone) {
        return zone.min >= this.min && zone.max <= this.max;
    }

    public boolean contains(double value) {
        return this.min <= value && value <= this.max;
    }

    @NotNull
    public Zone withMax(double max) throws IllegalArgumentException {
        return new Zone(this.min, max);
    }

    @NotNull
    public Zone withMin(double min) throws IllegalArgumentException {
        return new Zone(min, this.max);
    }
}

