/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.screen;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.screen.ClothConfigScreenBuilder;
import com.github.leawind.thirdperson.screen.YaclConfigScreenBuilder;
import com.github.leawind.util.PossibleSupplier;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigScreenBuilder {
    private static Map<String, PossibleSupplier<ConfigScreenBuilder>> builders = new HashMap<String, PossibleSupplier<ConfigScreenBuilder>>();

    @Nullable
    public static ConfigScreenBuilder getBuilder() {
        Map<String, PossibleSupplier<ConfigScreenBuilder>> availables = ConfigScreenBuilder.getAvailableBuidlers();
        if (availables.isEmpty()) {
            return null;
        }
        return availables.getOrDefault(ThirdPerson.getConfig().config_screen_api, availables.values().iterator().next()).get();
    }

    @NotNull
    public static Map<String, PossibleSupplier<ConfigScreenBuilder>> getAvailableBuidlers() {
        HashMap<String, PossibleSupplier<ConfigScreenBuilder>> availableBuilders = new HashMap<String, PossibleSupplier<ConfigScreenBuilder>>();
        builders.forEach((name, builder) -> {
            if (builder.available()) {
                availableBuilders.put((String)name, (PossibleSupplier<ConfigScreenBuilder>)builder);
            }
        });
        return availableBuilders;
    }

    @NotNull
    public abstract Screen build(@NotNull Config var1, @Nullable Screen var2);

    static {
        builders.put("Cloth Config", PossibleSupplier.of(() -> new ClothConfigScreenBuilder(), () -> Platform.isModLoaded((String)"cloth-config") || Platform.isModLoaded((String)"cloth_config")));
        builders.put("YACL", PossibleSupplier.of(() -> new YaclConfigScreenBuilder(), () -> Platform.isModLoaded((String)"yet_another_config_lib_v3") && (!Platform.isForge() || Platform.getMod((String)"yet_another_config_lib_v3").getVersion().startsWith("3.2."))));
        Set<String> availables = ConfigScreenBuilder.getAvailableBuidlers().keySet();
        availables.forEach(name -> ThirdPerson.LOGGER.debug("Found available config screen builder: {}", name));
        if (availables.isEmpty()) {
            ThirdPerson.LOGGER.warn("No config screen API available.");
        }
    }
}

