/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.resources;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.util.ItemPredicateUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ItemPredicateManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String ID = "item_patterns";
    private static final String SET_HOLD_TO_AIM = "hold_to_aim";
    private static final String SET_USE_TO_AIM = "use_to_aim";
    private static final String SET_USE_TO_FIRST_PERSON = "use_to_first_person";
    public final Map<String, Set<String>> holdToAimItemPatterns = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> useToAimItemPatterns = new HashMap<String, Set<String>>();
    public final Map<String, Set<String>> useToFirstPersonItemPatterns = new HashMap<String, Set<String>>();
    public final Set<ItemPredicate> holdToAimItemPredicates = new HashSet<ItemPredicate>();
    public final Set<ItemPredicate> useToAimItemPredicates = new HashSet<ItemPredicate>();
    public final Set<ItemPredicate> useToFirstPersonItemPredicates = new HashSet<ItemPredicate>();

    public ItemPredicateManager() {
        super(GSON, ID);
    }

    public void apply(@NotNull Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profile) {
        this.holdToAimItemPatterns.clear();
        this.useToAimItemPatterns.clear();
        this.useToFirstPersonItemPatterns.clear();
        map.forEach((resourceLocation, jsonElement) -> {
            JsonArray obj = jsonElement.getAsJsonArray();
            String[] resourcePath = resourceLocation.m_135815_().split("/");
            String namespace = resourceLocation.m_135827_();
            if (resourcePath.length >= 2) {
                String resourceSetName;
                switch (resourceSetName = resourcePath[0]) {
                    case "hold_to_aim": {
                        this.addToSet(namespace, this.holdToAimItemPatterns, obj);
                        break;
                    }
                    case "use_to_aim": {
                        this.addToSet(namespace, this.useToAimItemPatterns, obj);
                        break;
                    }
                    case "use_to_first_person": {
                        this.addToSet(namespace, this.useToFirstPersonItemPatterns, obj);
                    }
                }
            }
        });
        this.reparse();
    }

    private void addToSet(String defaultNs, @NotNull Map<String, Set<String>> patternMap, @NotNull JsonArray arr) {
        Set<Object> patterns;
        if (patternMap.containsKey(defaultNs)) {
            patterns = patternMap.get(defaultNs);
        } else {
            patterns = new HashSet();
            patternMap.put(defaultNs, patterns);
        }
        arr.forEach(ele -> {
            try {
                String pattern = ele.getAsString();
                patterns.add(pattern);
            }
            catch (Throwable e) {
                ThirdPerson.LOGGER.warn(e.getMessage());
            }
        });
        arr.size();
    }

    public void reparse() {
        this.holdToAimItemPredicates.clear();
        this.useToAimItemPredicates.clear();
        this.useToFirstPersonItemPredicates.clear();
        int count = this.parseToSet(this.holdToAimItemPredicates, this.holdToAimItemPatterns);
        if (count > 0) {
            ThirdPerson.LOGGER.info("Loaded {} hold_to_aim item patterns from resource pack", (Object)count);
        }
        if ((count = this.parseToSet(this.useToAimItemPredicates, this.useToAimItemPatterns)) > 0) {
            ThirdPerson.LOGGER.info("Loaded {} use_to_aim item patterns from resource pack", (Object)count);
        }
        if ((count = this.parseToSet(this.useToFirstPersonItemPredicates, this.useToFirstPersonItemPatterns)) > 0) {
            ThirdPerson.LOGGER.info("Loaded {} use_to_first_person item patterns from resource pack", (Object)count);
        }
    }

    private int parseToSet(Set<ItemPredicate> predicates, Map<String, Set<String>> patternMap) {
        int count = 0;
        for (String defaultNs : patternMap.keySet()) {
            Set<String> patterns = patternMap.get(defaultNs);
            for (String pattern : patterns) {
                try {
                    predicates.add(ItemPredicateUtil.parse(pattern));
                    ++count;
                }
                catch (IllegalArgumentException e) {
                    ThirdPerson.LOGGER.warn("Skip invalid item pattern: {} Because {}", (Object)pattern, (Object)e.getMessage());
                }
            }
        }
        return count;
    }
}

