/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.cameraoffset;

import com.github.leawind.thirdperson.cameraoffset.AbstractCameraOffsetMode;
import com.github.leawind.thirdperson.cameraoffset.CameraOffsetModeAiming;
import com.github.leawind.thirdperson.cameraoffset.CameraOffsetModeNormal;
import com.github.leawind.thirdperson.config.Config;
import org.jetbrains.annotations.NotNull;

public class CameraOffsetScheme {
    @NotNull
    private final AbstractCameraOffsetMode normalMode;
    @NotNull
    private final AbstractCameraOffsetMode aimingMode;
    private boolean isAiming = false;

    public CameraOffsetScheme(@NotNull Config config) {
        this.normalMode = new CameraOffsetModeNormal(config);
        this.aimingMode = new CameraOffsetModeAiming(config);
    }

    @NotNull
    public AbstractCameraOffsetMode getMode() {
        return this.isAiming() ? this.aimingMode : this.normalMode;
    }

    public AbstractCameraOffsetMode getNormalMode() {
        return this.normalMode;
    }

    public AbstractCameraOffsetMode getAimingMode() {
        return this.aimingMode;
    }

    @NotNull
    public AbstractCameraOffsetMode getAnotherMode() {
        return this.isAiming() ? this.normalMode : this.aimingMode;
    }

    public void setSide(double side) {
        this.setSide(side > 0.0);
    }

    public void setSide(boolean isCameraLeftOfPlayer) {
        this.aimingMode.setSide(isCameraLeftOfPlayer);
        this.normalMode.setSide(isCameraLeftOfPlayer);
    }

    public void toNextSide() {
        this.aimingMode.toNextSide();
        this.normalMode.toNextSide();
    }

    public boolean isCentered() {
        return this.getMode().isCentered();
    }

    public void setCentered(boolean isCentered) {
        this.getMode().setCentered(isCentered);
        this.getAnotherMode().setCentered(isCentered);
    }

    public boolean isAiming() {
        return this.isAiming;
    }

    public void setAiming(boolean aiming) {
        this.isAiming = aiming;
    }
}

