/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.cameraoffset;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.cameraoffset.AbstractCameraOffsetMode;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.util.math.LMath;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3d;

public class CameraOffsetModeAiming
extends AbstractCameraOffsetMode {
    public CameraOffsetModeAiming(@NotNull Config config) {
        super(config);
    }

    @Override
    @NotNull
    public Vector3d getEyeSmoothHalflife() {
        return new Vector3d(this.config.aiming_smooth_halflife_horizon, this.config.aiming_smooth_halflife_vertical, this.config.aiming_smooth_halflife_horizon);
    }

    @Override
    public double getDistanceSmoothHalflife() {
        return this.config.aiming_distance_smooth_halflife;
    }

    @Override
    @NotNull
    public Vector2d getOffsetSmoothHalflife() {
        return new Vector2d(this.config.aiming_camera_offset_smooth_halflife);
    }

    @Override
    public double getDistanceLimit() {
        return this.config.aiming_max_distance;
    }

    @Override
    public void setDistanceLimit(double distance) {
        this.config.aiming_max_distance = distance;
    }

    @Override
    public boolean isCentered() {
        return this.config.aiming_is_centered;
    }

    @Override
    public void setCentered(boolean isCentered) {
        this.config.aiming_is_centered = isCentered;
    }

    @Override
    public boolean isCameraLeftOfPlayer() {
        return this.config.aiming_offset_x > 0.0;
    }

    @Override
    public void toNextSide() {
        ThirdPerson.LOGGER.debug("Switching camera to the other side");
        if (this.isCentered()) {
            this.setCentered(false);
        } else {
            this.config.aiming_offset_x = -this.config.aiming_offset_x;
        }
    }

    @Override
    public void setSideOffsetRatio(@NotNull Vector2d v) {
        this.config.aiming_offset_x = LMath.clamp(v.x, -1.0, 1.0);
        this.config.aiming_offset_y = LMath.clamp(v.y, -1.0, 1.0);
    }

    @Override
    public double getCenterOffsetRatio() {
        return this.config.aiming_offset_center;
    }

    @Override
    public void setCenterOffsetRatio(double offset) {
        this.config.aiming_offset_center = LMath.clamp(offset, -1.0, 1.0);
    }

    @Override
    @NotNull
    public Vector2d getSideOffsetRatio(@NotNull Vector2d v) {
        return v.set(this.config.aiming_offset_x, this.config.aiming_offset_y);
    }
}

