/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.dragonheart.Item;

import com.dragon.dragonheart.CuriosItem;
import com.dragon.dragonheart.config.ConfigCommon;
import com.dragon.dragonheart.utils.AddAttributeSafety;
import com.dragon.dragonheart.utils.RemoveAttributeSafety;
import com.dragon.dragonheart.utils.TooltipWithoutShift;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class FallenAngelRing {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dragonheart");
    static UUID uuid = UUID.fromString("87EA5892-601C-428F-3EE4-45BB6D24D26B");
    public static final RegistryObject<Item> FALLEN_ANGEL_RING = ITEMS.register("fallen_angel_ring", () -> new CuriosItem(new Item.Properties().m_41487_(1).m_41486_()){

        @Override
        protected void equipfirst(LivingEntity livingEntity) {
            AttributeModifier modifier = new AttributeModifier(uuid, "Fallen Angel Ring sub health", -((Double)ConfigCommon.FALLEN_ANGEL_RING_SUB_HEALTH.get()).doubleValue(), AttributeModifier.Operation.ADDITION);
            AddAttributeSafety.addModifierSafety(livingEntity, Attributes.f_22276_, modifier);
        }

        @Override
        protected void equipmentTick(LivingEntity livingEntity) {
            if (livingEntity.m_21124_(MobEffects.f_19605_) == null) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, (Integer)ConfigCommon.FALLEN_ANGEL_RING_REGENERATION.get() - 1));
            }
            if (livingEntity.m_21124_(MobEffects.f_19605_) != null && Objects.requireNonNull(livingEntity.m_21124_(MobEffects.f_19605_)).m_19557_() < 20) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, (Integer)ConfigCommon.FALLEN_ANGEL_RING_REGENERATION.get() - 1));
            }
        }

        @Override
        protected void unequip(LivingEntity livingEntity) {
            AttributeModifier modifier = new AttributeModifier(uuid, "Fallen Angel Ring sub health", -((Double)ConfigCommon.FALLEN_ANGEL_RING_SUB_HEALTH.get()).doubleValue(), AttributeModifier.Operation.ADDITION);
            RemoveAttributeSafety.removeModifierSafety(livingEntity, Attributes.f_22276_, modifier);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            if (Screen.m_96638_()) {
                if (ChatFormatting.m_126647_((int)167) != null) {
                    tooltip.add((Component)Component.m_237115_((String)"item.dragonheart.ability.desc").m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.fallen_angel_ring.desc", (Object[])new Object[]{(Double)ConfigCommon.FALLEN_ANGEL_RING_SUB_MAGIC_DAMAGE.get() * 100.0}).m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.fallen_angel_ring.desc1", (Object[])new Object[]{(Double)ConfigCommon.FALLEN_ANGEL_RING_DAMAGE_TO_UNDEAD.get() * 100.0}).m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.fallen_angel_ring.desc2", (Object[])new Object[]{(int)((Integer)ConfigCommon.FALLEN_ANGEL_RING_REGENERATION.get())}).m_130940_(ChatFormatting.m_126647_((int)167)));
                    tooltip.add((Component)Component.m_237119_().m_130946_("-").m_130946_(String.valueOf(ConfigCommon.FALLEN_ANGEL_RING_SUB_HEALTH.get())).m_7220_((Component)Component.m_237115_((String)"item.dragonheart.max_health.desc")).m_130940_(ChatFormatting.m_126647_((int)167)));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"item.dragonheart.ability.desc").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.fallen_angel_ring.desc", (Object[])new Object[]{(Double)ConfigCommon.FALLEN_ANGEL_RING_SUB_MAGIC_DAMAGE.get() * 100.0}).m_130940_(ChatFormatting.BLUE));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.fallen_angel_ring.desc1", (Object[])new Object[]{(Double)ConfigCommon.FALLEN_ANGEL_RING_DAMAGE_TO_UNDEAD.get() * 100.0}).m_130940_(ChatFormatting.GREEN));
                    tooltip.add((Component)Component.m_237110_((String)"item.dragonheart.fallen_angel_ring.desc2", (Object[])new Object[]{(int)((Integer)ConfigCommon.FALLEN_ANGEL_RING_REGENERATION.get())}).m_130940_(ChatFormatting.RED));
                    tooltip.add((Component)Component.m_237119_().m_130946_("-").m_130946_(String.valueOf(ConfigCommon.FALLEN_ANGEL_RING_SUB_HEALTH.get())).m_7220_((Component)Component.m_237115_((String)"item.dragonheart.max_health.desc")).m_130940_(ChatFormatting.DARK_RED).m_130940_(ChatFormatting.BOLD));
                }
            } else {
                TooltipWithoutShift.tooltipWithoutShift(tooltip, "fallen_angel_ring");
            }
        }

        @NotNull
        public Component m_7626_(@NotNull ItemStack stack) {
            return Component.m_237115_((String)super.m_7626_(stack).getString()).m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
    });

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

