/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.snowwaifu.common.entity.impl;

import committee.nova.snowwaifu.common.config.SWConfig;
import committee.nova.snowwaifu.common.entity.ai.FollowOwnerGoal;
import committee.nova.snowwaifu.common.entity.ai.HoverBeamGoal;
import committee.nova.snowwaifu.common.entity.ai.OwnerHurtByTargetGoal;
import committee.nova.snowwaifu.common.entity.ai.OwnerHurtTargetGoal;
import committee.nova.snowwaifu.common.entity.api.TamableMob;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.entity.IBreathAttacker;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.util.EntityUtil;

public class SnowWaifuEntity
extends TamableMob
implements IBreathAttacker {
    private static final EntityDataAccessor<Boolean> BEAM_FLAG = SynchedEntityData.m_135353_(SnowWaifuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SnowWaifuEntity(EntityType<? extends SnowWaifuEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 360, true);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HoverBeamGoal(this, 20));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this, 2.0, 10.0f, 2.0f, true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, l -> l instanceof Enemy));
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_);
    }

    public boolean m_6094_() {
        return false;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22280_, 0.23).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)SWConfig.snowWaifuMaxHealth.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.75);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BEAM_FLAG, (Object)false);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(true);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.SNOW_QUEEN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.SNOW_QUEEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.SNOW_QUEEN_DEATH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        for (int i = 0; i < 3; ++i) {
            float px = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.3f;
            float py = this.m_20192_() + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.5f;
            float pz = (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.3f;
            this.m_9236_().m_7106_((ParticleOptions)TFParticleType.SNOW_GUARDIAN.get(), this.f_19790_ + (double)px, this.f_19791_ + (double)py, this.f_19792_ + (double)pz, 0.0, 0.0, 0.0);
        }
        if (this.isBreathing() && this.m_6084_()) {
            Vec3 look = this.m_20252_(1.0f);
            double dist = 0.5;
            double px = this.m_20185_() + look.m_7096_() * dist;
            double py = this.m_20186_() + (double)1.7f + look.m_7098_() * dist;
            double pz = this.m_20189_() + look.m_7094_() * dist;
            for (int i = 0; i < 10; ++i) {
                double dx = look.m_7096_();
                double dy = look.m_7098_();
                double dz = look.m_7094_();
                double spread = 2.0 + this.m_217043_().m_188500_() * 2.5;
                double velocity = 2.0 + this.m_217043_().m_188500_() * 0.15;
                dx += this.m_217043_().m_188583_() * 0.0075 * spread;
                dy += this.m_217043_().m_188583_() * 0.0075 * spread;
                dz += this.m_217043_().m_188583_() * 0.0075 * spread;
                this.m_9236_().m_7106_((ParticleOptions)TFParticleType.ICE_BEAM.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_20919_ > 0) {
            for (int i = 0; i < 5; ++i) {
                double d = this.m_217043_().m_188583_() * 0.02;
                double d1 = this.m_217043_().m_188583_() * 0.02;
                double d2 = this.m_217043_().m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)(this.m_217043_().m_188499_() ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), this.m_20185_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.m_217043_().m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.m_217043_().m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d, d1, d2);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_150930_(Items.f_42409_) && player == this.m_269323_() && player.m_6144_()) {
            this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
            this.m_146870_();
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((Item)TFItems.SNOW_QUEEN_TROPHY.get()).m_7968_());
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public int m_8132_() {
        return 85;
    }

    public int m_21529_() {
        return 360;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (target == owner) {
            return false;
        }
        return !(target instanceof SnowWaifuEntity);
    }

    @Override
    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        ItemEntity trophy = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_(), ((Item)TFItems.SNOW_QUEEN_TROPHY.get()).m_7968_());
        this.m_9236_().m_7967_((Entity)trophy);
    }

    public boolean m_7327_(Entity entity) {
        return entity.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
    }

    public void m_20093_() {
        if (!this.m_5825_()) {
            this.m_20254_(5);
            if (this.m_6469_(this.m_269291_().m_269233_(), 4.0f)) {
                this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
                EntityUtil.killLavaAround((Entity)this);
            }
        }
    }

    public boolean isBreathing() {
        return (Boolean)this.m_20088_().m_135370_(BEAM_FLAG);
    }

    public void setBreathing(boolean flag) {
        this.m_20088_().m_135381_(BEAM_FLAG, (Object)flag);
    }

    public void doBreathAttack(Entity target) {
        float dmg = ((Double)SWConfig.snowWaifuBreathAttackDamage.get()).floatValue();
        if (target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), dmg)) {
            this.m_5634_(dmg / 2.0f);
        }
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("health_percent", (double)(this.m_21223_() / this.m_21233_()));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("health_percent", 6)) {
            double percent = Mth.m_14008_((double)tag.m_128459_("health_percent"), (double)0.01, (double)1.0);
            this.m_21153_((float)(percent * (Double)SWConfig.snowWaifuMaxHealth.get()));
        }
    }
}

