/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.snowwaifu.common.entity.ai;

import committee.nova.snowwaifu.common.entity.impl.SnowWaifuEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.ai.goal.HoverBaseGoal;

public class HoverBeamGoal
extends HoverBaseGoal<SnowWaifuEntity> {
    private int hoverTimer;
    private final int maxHoverTime;

    public HoverBeamGoal(SnowWaifuEntity snowQueen, int hoverTime) {
        super((Mob)snowQueen, 6.0f, 6.0f);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxHoverTime = hoverTime;
        this.hoverTimer = 0;
    }

    public boolean m_8036_() {
        LivingEntity target = ((SnowWaifuEntity)this.attacker).m_5448_();
        if (target == null) {
            return false;
        }
        return target.m_6084_();
    }

    public boolean m_8045_() {
        LivingEntity target = ((SnowWaifuEntity)this.attacker).m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8041_() {
        this.hoverTimer = 0;
        ((SnowWaifuEntity)this.attacker).setBreathing(false);
        ((SnowWaifuEntity)this.attacker).m_21573_().m_26573_();
    }

    public void m_8037_() {
        double offsetZ;
        double offsetY;
        double offsetX;
        double distanceDesired;
        LivingEntity target = ((SnowWaifuEntity)this.attacker).m_5448_();
        if (target == null) {
            ((SnowWaifuEntity)this.attacker).m_21573_().m_26573_();
            return;
        }
        float tracking = 1.0f;
        ((SnowWaifuEntity)this.attacker).m_21391_((Entity)target, tracking, tracking);
        ((SnowWaifuEntity)this.attacker).m_21563_().m_148051_((Entity)target);
        if (target.m_20275_(this.hoverPosX, this.hoverPosY, this.hoverPosZ) > 20.0) {
            Vec3 dir = ((SnowWaifuEntity)this.attacker).m_146892_().m_82546_(target.m_146892_()).m_82541_();
            Vec3 targetPointRaw = target.m_146892_().m_82549_(dir.m_82490_(10.0));
            this.hoverPosX = targetPointRaw.f_82479_;
            this.hoverPosY = target.m_20188_() + 6.0;
            this.hoverPosZ = targetPointRaw.f_82481_;
        }
        ++this.hoverTimer;
        if (this.hoverTimer >= this.maxHoverTime) {
            ((SnowWaifuEntity)this.attacker).setBreathing(true);
            this.doRayAttack();
        }
        if ((distanceDesired = Math.sqrt((offsetX = this.hoverPosX - ((SnowWaifuEntity)this.attacker).m_20185_()) * offsetX + (offsetY = this.hoverPosY - ((SnowWaifuEntity)this.attacker).m_20186_()) * offsetY + (offsetZ = this.hoverPosZ - ((SnowWaifuEntity)this.attacker).m_20189_()) * offsetZ)) > 3.0) {
            ((SnowWaifuEntity)this.attacker).m_21573_().m_26519_(this.hoverPosX, this.hoverPosY, this.hoverPosZ, 1.0);
        } else {
            ((SnowWaifuEntity)this.attacker).m_21573_().m_26573_();
        }
    }

    private void doRayAttack() {
        double range = 20.0;
        double offset = 10.0;
        Vec3 srcVec = new Vec3(((SnowWaifuEntity)this.attacker).m_20185_(), ((SnowWaifuEntity)this.attacker).m_20186_() + 0.25, ((SnowWaifuEntity)this.attacker).m_20189_());
        Vec3 lookVec = ((SnowWaifuEntity)this.attacker).m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range);
        List possibleList = ((SnowWaifuEntity)this.attacker).m_9236_().m_45933_((Entity)this.attacker, ((SnowWaifuEntity)this.attacker).m_20191_().m_82386_(lookVec.m_7096_() * offset, lookVec.m_7098_() * offset, lookVec.m_7094_() * offset).m_82377_(range, range, range));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.m_6087_() || possibleEntity == this.attacker || possibleEntity == ((SnowWaifuEntity)this.attacker).m_269323_()) continue;
            float borderSize = possibleEntity.m_6143_();
            AABB collisionBB = possibleEntity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                ((SnowWaifuEntity)this.attacker).doBreathAttack(possibleEntity);
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            ((SnowWaifuEntity)this.attacker).doBreathAttack(possibleEntity);
            hitDist = possibleDist;
        }
    }
}

