/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util;

import java.util.EnumMap;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.ParticleStatus;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.vanilla.mode.QualityMode;
import team.teampotato.ruok.gui.vanilla.mode.WeatherMode;
import team.teampotato.ruok.util.Options;

public class Quality {
    private static final EnumMap<QualityMode, QualitySettings> QUALITY_SETTINGS_MAP = new EnumMap(QualityMode.class);

    public static void set(@NotNull QualityMode mode) {
        QualitySettings settings = QUALITY_SETTINGS_MAP.get((Object)mode);
        Quality.applySettings(settings);
        RuOK.get().QualityModes = mode;
    }

    private static void applySettings(@NotNull QualitySettings settings) {
        Options.setGraphicsMode(settings.graphicsMode);
        Options.setViewDistance(settings.viewDistance);
        Options.setVsync(settings.vsync);
        Options.setParticles(settings.particlesMode);
        Options.setAo(settings.ao);
        Options.setCloudRenderMode(settings.cloudRenderMode);
        Options.setEntityShadows(settings.entityShadows);
        RuOK.get().maxEntityEntities = settings.maxEntityEntities;
        RuOK.get().entitiesDistance = settings.entitiesDistance;
        RuOK.get().RenderWeather = settings.weather;
        RuOK.get().RenderTNTExplosions = settings.renderTNTExplosions;
    }

    static {
        QUALITY_SETTINGS_MAP.put(QualityMode.ULTRA, new QualitySettings(WeatherMode.NORMAL, true, 16, false, ParticleStatus.ALL, GraphicsStatus.FABULOUS, true, CloudStatus.FANCY, true, 1024, 512));
        QUALITY_SETTINGS_MAP.put(QualityMode.HIGH, new QualitySettings(WeatherMode.NORMAL, true, 12, true, ParticleStatus.MINIMAL, GraphicsStatus.FANCY, true, CloudStatus.FANCY, true, 512, 256));
        QUALITY_SETTINGS_MAP.put(QualityMode.NORMAL, new QualitySettings(WeatherMode.NORMAL, true, 8, true, ParticleStatus.ALL, GraphicsStatus.FABULOUS, true, CloudStatus.FAST, true, 256, 128));
        QUALITY_SETTINGS_MAP.put(QualityMode.LOW, new QualitySettings(WeatherMode.LOW, true, 6, true, ParticleStatus.MINIMAL, GraphicsStatus.FAST, true, CloudStatus.OFF, false, 128, 64));
        QUALITY_SETTINGS_MAP.put(QualityMode.CRITICAL, new QualitySettings(WeatherMode.CLOSE, false, 2, true, ParticleStatus.MINIMAL, GraphicsStatus.FAST, false, CloudStatus.OFF, false, 64, 32));
    }

    private record QualitySettings(WeatherMode weather, boolean renderTNTExplosions, int viewDistance, boolean vsync, ParticleStatus particlesMode, GraphicsStatus graphicsMode, boolean ao, CloudStatus cloudRenderMode, boolean entityShadows, int maxEntityEntities, int entitiesDistance) {
    }
}

