/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.utils;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class Profiler {
    protected static Logger LOGGER = LogManager.getLogger();
    protected static final List<Analyzer> ANALYZERS = new ArrayList<Analyzer.Invoke>(Arrays.asList(new Analyzer.Invoke(Type.CONTAINS, false, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z"), new Analyzer.Invoke(Type.CONTAINS, true, "kotlin/text/StringsKt", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Z)Z"), new Analyzer.Invoke(Type.CONTAINS, true, "kotlin/text/StringsKt", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence)Z"), new Analyzer.Invoke(Type.EQUALS, false, "java/lang/String", "equals", "(Ljava/lang/Object;)Z"), new Analyzer.Invoke(Type.REGEXP, false, "java/lang/String", "matches", "(Ljava/lang/String;)Z"), new Analyzer.Invoke(Type.REGEXP, false, "java/util/regex/Pattern", "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;")));
    private static final Map<Plafform, String> infoFiles = new HashMap<Plafform, String>();
    @Nullable
    private static Profiler instance;
    private final InfoReader infoReader;

    @NotNull
    public static Profiler getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Profiler has not been initialized.");
        }
        return instance;
    }

    public static Profiler init(InfoReader reader, String suffixArray) {
        if (instance == null) {
            instance = new Profiler(reader, suffixArray);
        }
        return instance;
    }

    private Profiler(InfoReader reader, String suffixArray) {
        ANALYZERS.add(new Analyzer.Construct(Type.SUFFIX, suffixArray.replace('.', '/')));
        this.infoReader = reader;
        instance = this;
    }

    public static String runAsJson() {
        return instance == null ? "" : new GsonBuilder().setPrettyPrinting().create().toJson((Object)instance.run());
    }

    public Report run() {
        File modDirectory = new File("mods");
        Report r = new Report();
        r.jars = this.scanDirectory(modDirectory);
        return r;
    }

    private ArrayList<JarContainer> scanDirectory(File f) {
        File[] files = f.listFiles();
        ArrayList<JarContainer> jcs = new ArrayList<JarContainer>();
        Consumer<JarContainer> callback = jcs::add;
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".jar")) {
                    try (ZipFile mod = new ZipFile(file);){
                        this.scanJar(mod, callback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.isDirectory()) continue;
                jcs.addAll(this.scanDirectory(file));
            }
        }
        return jcs;
    }

    private void scanJar(ZipFile f, Consumer<JarContainer> cbkJar) {
        EnumMap methods = new EnumMap(Type.class);
        for (Type t : Type.values()) {
            methods.put(t, new TreeSet());
        }
        JarContainer ret = new JarContainer();
        f.stream().forEach(entry -> {
            try (InputStream is = f.getInputStream((ZipEntry)entry);){
                if (entry.getName().equals(infoFiles.get((Object)this.infoReader.getPlatform()))) {
                    ret.mods = this.infoReader.readInfo(is);
                } else if (entry.getName().endsWith(".class")) {
                    long size = entry.getSize() + 4L;
                    if (size > Integer.MAX_VALUE) {
                        LOGGER.info("Class file " + entry.getName() + " in jar file " + f.getName() + " is too large, skip.");
                    } else {
                        this.scanClass(is, methods);
                    }
                } else if (entry.getName().endsWith(".jar")) {
                    this.scanJarInJar(is, methods);
                }
            }
            catch (IOException e) {
                LOGGER.info("Fail to read file " + entry.getName() + " in jar file " + f.getName() + ", skip.");
            }
        });
        if (methods.values().stream().anyMatch(i -> !i.isEmpty())) {
            ret.contains = new ArrayList<String>((Collection)methods.get((Object)Type.CONTAINS));
            ret.regExp = new ArrayList<String>((Collection)methods.get((Object)Type.REGEXP));
            ret.suffix = new ArrayList<String>((Collection)methods.get((Object)Type.SUFFIX));
            ret.equals = new ArrayList<String>((Collection)methods.get((Object)Type.EQUALS));
            cbkJar.accept(ret);
        }
    }

    private void scanClass(InputStream is, EnumMap<Type, Set<String>> methods) throws IOException {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(is);
        try {
            classReader.accept((ClassVisitor)classNode, 0);
        }
        catch (Exception e) {
            if (classNode.name != null) {
                LOGGER.info("File decoding of class " + classNode.name + " failed. Try to continue.");
            }
            throw new IOException(e);
        }
        classNode.methods.forEach(methodNode -> {
            for (AbstractInsnNode node : methodNode.instructions) {
                ANALYZERS.forEach(i -> i.analyze(node, classNode, (MethodNode)methodNode, methods));
            }
        });
    }

    private void scanJarInJar(InputStream is, EnumMap<Type, Set<String>> methods) throws IOException {
        ZipEntry entry;
        ZipInputStream stream = new ZipInputStream(is);
        while ((entry = stream.getNextEntry()) != null) {
            if (entry.getName().endsWith(".class")) {
                this.scanClass(stream, methods);
                continue;
            }
            if (!entry.getName().endsWith(".jar")) continue;
            this.scanJarInJar(new ZipInputStream(stream), methods);
        }
    }

    static {
        infoFiles.put(Plafform.FABRIC, "fabric.mod.json");
        infoFiles.put(Plafform.FORGE, "META-INF/mods.toml");
    }

    public static interface InfoReader {
        public Plafform getPlatform();

        public ModContainer[] readInfo(InputStream var1);
    }

    private static abstract class Analyzer {
        Type type;

        public Analyzer(Type type) {
            this.type = type;
        }

        public void analyze(AbstractInsnNode insn, ClassNode clazz, MethodNode method, EnumMap<Type, Set<String>> methods) {
            if (this.match(insn)) {
                methods.get((Object)this.type).add(clazz.name.replace('/', '.') + ":" + method.name + method.desc);
            }
        }

        abstract boolean match(AbstractInsnNode var1);

        private static class Construct
        extends Analyzer {
            String clazz;

            public Construct(Type type, String clazz) {
                super(type);
                this.clazz = clazz;
            }

            @Override
            boolean match(AbstractInsnNode insn) {
                if (insn instanceof TypeInsnNode) {
                    TypeInsnNode tin = (TypeInsnNode)insn;
                    return tin.getOpcode() == 187 && tin.desc.equals(this.clazz);
                }
                return false;
            }
        }

        private static class Invoke
        extends Analyzer {
            String owner;
            String name;
            String desc;
            int op;
            int tag;

            public Invoke(Type type, boolean isStatic, String owner, String name, String desc) {
                super(type);
                this.op = isStatic ? 184 : 182;
                this.tag = isStatic ? 6 : 5;
                this.owner = owner;
                this.name = name;
                this.desc = desc;
            }

            @Override
            boolean match(AbstractInsnNode insn) {
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode node = (MethodInsnNode)insn;
                    return node.getOpcode() == this.op && node.owner.equals(this.owner) && node.name.equals(this.name) && node.desc.equals(this.desc);
                }
                if (insn instanceof InvokeDynamicInsnNode) {
                    InvokeDynamicInsnNode din = (InvokeDynamicInsnNode)insn;
                    if (din.bsmArgs.length != 3) {
                        return false;
                    }
                    Object arg = din.bsmArgs[1];
                    if (arg instanceof Handle) {
                        Handle handle = (Handle)arg;
                        return handle.getTag() == this.tag && handle.getOwner().equals(this.owner) && handle.getName().equals(this.name) && handle.getDesc().equals(this.desc);
                    }
                }
                return false;
            }
        }
    }

    static enum Type {
        CONTAINS,
        EQUALS,
        REGEXP,
        SUFFIX;

    }

    public static class Report {
        List<JarContainer> jars;
    }

    private static class JarContainer {
        ModContainer[] mods;
        List<String> contains;
        List<String> regExp;
        List<String> suffix;
        List<String> equals;

        private JarContainer() {
        }
    }

    public static enum Plafform {
        FABRIC,
        FORGE;

    }

    public static class ModContainer {
        String modid;
        String name;
        String version;

        public ModContainer(String modid, String name, String version) {
            this.modid = modid;
            this.name = name;
            this.version = version;
        }
    }
}

