/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import io.github.reserveword.imblocker.Common;
import io.github.reserveword.imblocker.Config;
import io.github.reserveword.imblocker.IMManager;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.WeakHashMap;

public class IMCheckState {
    private static final EnumSet<IMState> state = EnumSet.copyOf(IMState.NONE);
    private static WeakReference<Object> lastScreen = new WeakReference<Object>(null);
    private static final WeakHashMap<Object, InputClassRule> lastInput = new WeakHashMap();
    public static final char nonPrintable = '\u0000';
    private static int count = Config.INSTANCE.getCheckInterval();

    private static void syncState() {
        boolean im = state.contains((Object)IMState.SCREEN_LIST_MASK) ? state.contains((Object)IMState.SCREEN_LIST) : (state.contains((Object)IMState.SPECIAL_MASK) ? state.contains((Object)IMState.SPECIAL) : state.contains((Object)IMState.TICK) || state.contains((Object)IMState.NON_PRINTABLE));
        IMManager.makeState(im);
    }

    private static void checkScreenList(ScreenInfo screen) {
        if (screen.get() != lastScreen.get()) {
            Common.LOGGER.debug("screen changed to {}", screen.get());
            state.add(IMState.NON_PRINTABLE_CHALLENGE_PENDING);
            IMCheckState.checkSpecialScreenChange(screen);
            lastScreen = new WeakReference<Object>(screen.get());
            if (Config.INSTANCE.inScreenWhitelist(screen.type())) {
                Common.LOGGER.debug("found whitelisted screen");
                state.add(IMState.SCREEN_LIST);
                state.add(IMState.SCREEN_LIST_MASK);
            } else if (Config.INSTANCE.inScreenBlacklist(screen.type())) {
                Common.LOGGER.debug("found blacklisted screen");
                state.remove((Object)IMState.SCREEN_LIST);
                state.add(IMState.SCREEN_LIST_MASK);
            } else {
                state.remove((Object)IMState.SCREEN_LIST_MASK);
                if (screen.get() != null) {
                    Config.INSTANCE.checkScreen(screen.type());
                }
            }
        }
    }

    private static void checkSpecial() {
    }

    private static void checkSpecialScreenChange(ScreenInfo screen) {
        block5: {
            if (screen.isChatScreen()) {
                try {
                    String text = screen.defaultText();
                    if (text.startsWith("/") && Config.INSTANCE.getCheckCommandChat().booleanValue()) {
                        Common.LOGGER.debug("Specially disabled IME for command input");
                        state.remove((Object)IMState.SPECIAL);
                        state.add(IMState.SPECIAL_MASK);
                        break block5;
                    }
                    state.remove((Object)IMState.SPECIAL_MASK);
                }
                catch (Throwable e) {
                    Common.LOGGER.warn("ChatScreen hook running exception:", e);
                }
            } else {
                state.remove((Object)IMState.SPECIAL_MASK);
            }
        }
    }

    private static InputClassRule checkInputClass(Object input) {
        if (!lastInput.containsKey(input)) {
            Common.LOGGER.debug("input box {} ticking", input);
            if (Config.INSTANCE.inInputWhitelist(input.getClass())) {
                Common.LOGGER.debug("found whitelisted input");
                state.remove((Object)IMState.TICK);
                lastInput.put(input, InputClassRule.WHITELIST);
                return InputClassRule.WHITELIST;
            }
            if (Config.INSTANCE.inInputBlacklist(input.getClass())) {
                Common.LOGGER.debug("found blacklisted input");
                state.remove((Object)IMState.TICK);
                lastInput.put(input, InputClassRule.BLACKLIST);
                return InputClassRule.BLACKLIST;
            }
            lastInput.put(input, InputClassRule.NOT_LISTED);
            return InputClassRule.NOT_LISTED;
        }
        return lastInput.get(input);
    }

    private static void checkTick() {
        if (state.contains((Object)IMState.TICK_CHALLENGE)) {
            Common.LOGGER.debug("test failed, im off");
            state.remove((Object)IMState.TICK_CHALLENGE);
            state.remove((Object)IMState.TICK);
        } else if (state.contains((Object)IMState.TICK)) {
            state.add(IMState.TICK_CHALLENGE);
        }
    }

    public static void captureTick(Object input, boolean canWrite) {
        if (canWrite && IMCheckState.checkInputClass(input) != InputClassRule.BLACKLIST) {
            state.add(IMState.TICK);
            state.remove((Object)IMState.TICK_CHALLENGE);
        }
    }

    private static void checkNonPrintable(ScreenInfo screen) {
        if (Config.INSTANCE.getUseExperimental().booleanValue()) {
            if (state.contains((Object)IMState.NON_PRINTABLE_CHALLENGE)) {
                state.remove((Object)IMState.NON_PRINTABLE_CHALLENGE);
                state.remove((Object)IMState.NON_PRINTABLE);
            } else if (state.contains((Object)IMState.NON_PRINTABLE_CHALLENGE_PENDING)) {
                state.add(IMState.NON_PRINTABLE_CHALLENGE);
                Common.LOGGER.debug("inject");
                if (screen.get() != null) {
                    try {
                        screen.charTyped('\u0000', 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                state.remove((Object)IMState.NON_PRINTABLE_CHALLENGE_PENDING);
            }
        } else {
            state.remove((Object)IMState.NON_PRINTABLE);
        }
    }

    public static boolean captureNonPrintable(Object tfw, char ch, boolean canWrite) {
        if (Config.INSTANCE.getUseExperimental().booleanValue() && IMCheckState.checkInputClass(tfw) != InputClassRule.BLACKLIST && ch == '\u0000' && canWrite) {
            state.remove((Object)IMState.NON_PRINTABLE_CHALLENGE);
            state.add(IMState.NON_PRINTABLE);
            Common.LOGGER.debug("captured");
            return true;
        }
        return false;
    }

    public static void clientTick(ScreenInfo screen) {
        IMCheckState.checkScreenList(screen);
        IMCheckState.checkSpecial();
        if (count == 0) {
            IMCheckState.checkTick();
        }
        IMCheckState.checkNonPrintable(screen);
        IMCheckState.syncState();
        count = count > 0 ? --count : Config.INSTANCE.getCheckInterval();
    }

    public static void mouseEvent() {
        state.add(IMState.NON_PRINTABLE_CHALLENGE_PENDING);
    }

    private static enum IMState {
        SCREEN_LIST,
        SPECIAL,
        TICK,
        NON_PRINTABLE,
        SCREEN_LIST_MASK,
        SPECIAL_MASK,
        SPECIAL_CHALLENGE,
        TICK_CHALLENGE,
        NON_PRINTABLE_CHALLENGE,
        NON_PRINTABLE_CHALLENGE_PENDING;

        public static final EnumSet<IMState> NONE;

        static {
            NONE = EnumSet.noneOf(IMState.class);
        }
    }

    public static interface ScreenInfo {
        public Object get();

        public boolean isChatScreen();

        public Class<?> type();

        public String defaultText() throws Throwable;

        public void charTyped(char var1, int var2);
    }

    private static enum InputClassRule {
        NOT_LISTED,
        WHITELIST,
        BLACKLIST;

    }
}

